"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSizeToPixels = exports.LegendSize = exports.LegendLayout = exports.DEFAULT_LEGEND_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let LegendSize = exports.LegendSize = /*#__PURE__*/function (LegendSize) {
  LegendSize["AUTO"] = "auto";
  LegendSize["SMALL"] = "small";
  LegendSize["MEDIUM"] = "medium";
  LegendSize["LARGE"] = "large";
  LegendSize["EXTRA_LARGE"] = "xlarge";
  return LegendSize;
}({});
let LegendLayout = exports.LegendLayout = /*#__PURE__*/function (LegendLayout) {
  LegendLayout["Table"] = "table";
  LegendLayout["List"] = "list";
  return LegendLayout;
}({});
const LegendSizeToPixels = exports.LegendSizeToPixels = {
  [LegendSize.AUTO]: undefined,
  [LegendSize.SMALL]: 80,
  [LegendSize.MEDIUM]: 130,
  [LegendSize.LARGE]: 180,
  [LegendSize.EXTRA_LARGE]: 230
};
const DEFAULT_LEGEND_SIZE = exports.DEFAULT_LEGEND_SIZE = LegendSize.MEDIUM;

/**
 * This is a shared type between XY Expression and Annotation plugins.
 * We've put it here to avoid a circular dependency between the two plugins.
 */