"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ColorPickerLazy: true,
  ColorPicker: true,
  LegendToggleLazy: true,
  LegendToggle: true,
  CurrentTime: true,
  EmptyPlaceholder: true,
  useCommonChartStyles: true
};
exports.ColorPickerLazy = exports.ColorPicker = void 0;
Object.defineProperty(exports, "CurrentTime", {
  enumerable: true,
  get: function () {
    return _current_time.CurrentTime;
  }
});
Object.defineProperty(exports, "EmptyPlaceholder", {
  enumerable: true,
  get: function () {
    return _empty_placeholder.EmptyPlaceholder;
  }
});
exports.LegendToggleLazy = exports.LegendToggle = void 0;
Object.defineProperty(exports, "useCommonChartStyles", {
  enumerable: true,
  get: function () {
    return _common_chart_styles.useCommonChartStyles;
  }
});
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _current_time = require("./current_time");
var _empty_placeholder = require("./empty_placeholder");
var _common_chart_styles = require("./common_chart_styles");
var _endzones = require("./endzones");
Object.keys(_endzones).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _endzones[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _endzones[key];
    }
  });
});
var _warnings = require("./warnings");
Object.keys(_warnings).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _warnings[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _warnings[key];
    }
  });
});
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The Lazily-loaded `ColorPicker` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const ColorPickerLazy = exports.ColorPickerLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./color_picker'))).then(({
  ColorPicker
}) => ({
  default: ColorPicker
})));

/**
 * A `ColorPicker` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `ColorPickerLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const ColorPicker = exports.ColorPicker = (0, _sharedUxUtility.withSuspense)(ColorPickerLazy);

/**
 * The Lazily-loaded `LegendToggle` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const LegendToggleLazy = exports.LegendToggleLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./legend_toggle'))).then(({
  LegendToggle
}) => ({
  default: LegendToggle
})));

/**
 * A `LegendToggle` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `LegendToggleLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const LegendToggle = exports.LegendToggle = (0, _sharedUxUtility.withSuspense)(LegendToggleLazy);