"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectedServicesPage = void 0;
Object.defineProperty(exports, "useClusterConnection", {
  enumerable: true,
  get: function () {
    return _use_cluster_connection.useClusterConnection;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _app_context = require("../../app_context");
var _overview_section = require("./overview_section");
var _services_section = require("./services_section");
var _migration_section = require("./migration_section");
var _disconnect_cluster_modal = require("./disconnect_cluster_modal");
var _use_cluster_connection = require("./use_cluster_connection");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/connected_services/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectedServicesPage = ({
  clusterDetails,
  onServiceUpdate,
  onDisconnect
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    notifications,
    hasConfigurePermission,
    docLinks,
    telemetryService,
    apiService,
    licensing
  } = (0, _app_context.useCloudConnectedAppContext)();
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isDisconnectModalVisible, setIsDisconnectModalVisible] = (0, _react.useState)(false);
  const [isDisconnecting, setIsDisconnecting] = (0, _react.useState)(false);
  const localLicense = (0, _useObservable.default)(licensing.license$);
  const currentLicenseType = localLicense === null || localLicense === void 0 ? void 0 : localLicense.type;
  const closeActionsPopover = () => setIsActionsPopoverOpen(false);
  const toggleActionsPopover = () => setIsActionsPopoverOpen(!isActionsPopoverOpen);
  const showDisconnectModal = () => {
    closeActionsPopover();
    setIsDisconnectModalVisible(true);
  };
  const closeDisconnectModal = () => {
    setIsDisconnectModalVisible(false);
  };
  const handleDisconnectCluster = async () => {
    setIsDisconnecting(true);
    const {
      error
    } = await apiService.disconnectCluster();
    if (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.disconnect.errorTitle', {
          defaultMessage: 'Failed to disconnect cluster'
        }),
        text: error.message
      });
      setIsDisconnecting(false);
      return;
    }
    notifications.toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.disconnect.successTitle', {
        defaultMessage: 'Cluster disconnected successfully'
      }),
      text: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.disconnect.successMessage', {
        defaultMessage: 'Your cluster has been disconnected from Cloud Connect.'
      })
    });
    closeDisconnectModal();

    // Clear cluster details to immediately show onboarding view
    onDisconnect();
  };
  const actionsMenuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "disconnect",
    onClick: showDisconnectModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.actions.disconnectCluster",
    defaultMessage: "Disconnect cluster",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  })))];
  const disconnectModal = isDisconnectModalVisible ? /*#__PURE__*/_react.default.createElement(_disconnect_cluster_modal.DisconnectClusterModal, {
    clusterName: clusterDetails.name,
    onClose: closeDisconnectModal,
    onConfirm: handleDisconnectCluster,
    isLoading: isDisconnecting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }) : null;
  const actionsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: toggleActionsPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.actionsButton",
    defaultMessage: "Actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    direction: "column",
    restrictWidth: 1200,
    grow: false,
    css: {
      background: euiTheme.colors.backgroundBasePlain
    },
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.pageTitle",
      defaultMessage: "Cloud connected services",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }),
    bottomBorder: true,
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.pageDescription",
      defaultMessage: "This cluster is connected to an Elastic Cloud organization. {learnMore}",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.cloud.cloudConnect,
          target: "_blank",
          external: true,
          onMouseDown: () => {
            // Track telemetry for learn more documentation link.
            // We intentionally avoid `onClick` to keep `href` (open-in-new-tab) without violating lint rules.
            telemetryService.trackLinkClicked({
              destination_type: 'cloud_connect_docs'
            });
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.cloudConnect.connectedServices.learnMore",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 165,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }),
    rightSideItems: hasConfigurePermission ? [/*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      key: "actions",
      button: actionsButton,
      isOpen: isActionsPopoverOpen,
      closePopover: closeActionsPopover,
      panelPaddingSize: "none",
      anchorPosition: "downRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: actionsMenuItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 19
      }
    }))] : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_section.OverviewSection, {
    organizationId: clusterDetails.metadata.organization_id,
    connectedAt: clusterDetails.metadata.created_at,
    subscription: clusterDetails.metadata.subscription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_services_section.ServicesSection, {
    services: clusterDetails.services,
    onServiceUpdate: onServiceUpdate,
    subscription: clusterDetails.metadata.subscription,
    currentLicenseType: currentLicenseType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_migration_section.MigrationSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  })), disconnectModal);
};
exports.ConnectedServicesPage = ConnectedServicesPage;