"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/connected_services/overview_section/subscription_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SubscriptionBadge = ({
  subscription
}) => {
  const state = subscription.toLowerCase();
  const capitalizedSubscription = (0, _lodash.capitalize)(subscription);
  switch (state) {
    case 'active':
    case 'trial':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 24,
          columnNumber: 14
        }
      }, capitalizedSubscription);
    case 'inactive':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.cloudConnect.connectedServices.overview.inactiveSubscriptionInfo",
          defaultMessage: "This organization has no active cloud subscription or trial. This may mean the trial expired or was never started.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 31,
            columnNumber: 13
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        iconType: "info",
        iconSide: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }, capitalizedSubscription));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 14
        }
      }, capitalizedSubscription);
  }
};
exports.SubscriptionBadge = SubscriptionBadge;