"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _app_context = require("../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/connected_services/services_section/details_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isLicenseValid = (validLicenseTypes, currentLicenseType) => {
  // If no license requirements, it's valid
  if (!validLicenseTypes || validLicenseTypes.length === 0) {
    return true;
  }
  // If no current license type, consider it valid
  if (!currentLicenseType) {
    return true;
  }
  return validLicenseTypes.includes(currentLicenseType);
};
const formatLicenseList = licenses => {
  const formatted = licenses.map(license => license.toLowerCase() === 'trial' ? 'trial' : (0, _lodash.capitalize)(license));
  if (formatted.length === 1) {
    return formatted[0];
  }
  if (formatted.length === 2) {
    return `${formatted[0]} or ${formatted[1]}`;
  }

  // For 3 or more items: "trial, Basic or Enterprise"
  const allButLast = formatted.slice(0, -1).join(', ');
  const last = formatted[formatted.length - 1];
  return `${allButLast} or ${last}`;
};
const ServiceCard = ({
  serviceKey,
  title,
  enabled,
  supported = true,
  badge,
  badgeTooltip,
  region,
  description,
  learnMoreUrl,
  serviceUrl,
  enableServiceByUrl,
  onEnable,
  onDisable,
  onOpen,
  isLoading = false,
  isCardDisabled = false,
  subscriptionRequired = false,
  hasActiveSubscription = true,
  validLicenseTypes,
  currentLicenseType
}) => {
  const {
    hasConfigurePermission,
    hasActionsSavePrivilege,
    hasAnyDefaultLLMConnectors,
    telemetryService
  } = (0, _app_context.useCloudConnectedAppContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isLicensePopoverOpen, setIsLicensePopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const togglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const closeLicensePopover = () => setIsLicensePopoverOpen(false);
  const toggleLicensePopover = () => setIsLicensePopoverOpen(!isLicensePopoverOpen);
  const renderBadge = () => {
    if (isCardDisabled && badge) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        size: "s",
        label: badge,
        "data-test-subj": "serviceCardComingSoonBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 14
        }
      });
    }
    if (!supported) {
      const unsupportedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "serviceCardUnsupportedBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.unsupported",
        defaultMessage: "Unsupported",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 11
        }
      }));
      if (badgeTooltip) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: badgeTooltip,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 16
          }
        }, unsupportedBadge);
      }
      return unsupportedBadge;
    }
    if (badge) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "serviceCardCustomBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 9
        }
      }, badge);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: enabled ? 'success' : 'subdued',
      "data-test-subj": enabled ? 'serviceCardEnabledBadge' : 'serviceCardDisabledBadge',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 7
      }
    }, enabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.enabled",
      defaultMessage: "Enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.notEnabled",
      defaultMessage: "Not enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }));
  };
  const renderActions = () => {
    if (isCardDisabled) {
      return null;
    }
    if (!isLicenseValid(validLicenseTypes, currentLicenseType) && !supported) {
      const formattedLicenses = formatLicenseList(validLicenseTypes);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        "data-test-subj": "serviceCardLicenseMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.requiresDifferentLicense",
        defaultMessage: "Requires {licenses} license",
        values: {
          licenses: formattedLicenses
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          iconType: "info",
          color: "text",
          "aria-label": _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.licenseInfoAriaLabel', {
            defaultMessage: 'License information'
          }),
          onClick: toggleLicensePopover,
          "data-test-subj": "serviceCardLicenseInfoButton",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 206,
            columnNumber: 17
          }
        }),
        isOpen: isLicensePopoverOpen,
        closePopover: closeLicensePopover,
        panelPaddingSize: "s",
        anchorPosition: "upCenter",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          maxWidth: '300px'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.licenseInfo",
        defaultMessage: "{viewSubscriptionLink} or {extendTrialLink}.",
        values: {
          extendTrialLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://www.elastic.co/trialextension",
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 231,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.extendTrial', {
            defaultMessage: 'extend your trial'
          })),
          viewSubscriptionLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://www.elastic.co/subscriptions",
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 241,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.viewSubscriptionOptions', {
            defaultMessage: 'View subscription options'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 19
        }
      }))))));
    }
    if (!supported) {
      return null;
    }

    // Show subscription requirement message if service requires subscription and there's no active subscription
    if (subscriptionRequired && !hasActiveSubscription) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        "data-test-subj": "serviceCardSubscriptionMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.requiresSubscription",
        defaultMessage: "Requires an active cloud subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.subscriptionInfo', {
          defaultMessage: 'Contact your admin to subscribe to Elastic Cloud.'
        }),
        position: "top",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 282,
          columnNumber: 13
        }
      })));
    }

    // Show permission message if user doesn't have configure permission
    if (!hasConfigurePermission) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        "data-test-subj": "serviceCardPermissionMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.onlyAdminsCanManage",
        defaultMessage: "Only admins can manage services",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.contactAdmin', {
          defaultMessage: 'Contact your admin'
        }),
        position: "top",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 314,
          columnNumber: 13
        }
      })));
    }
    if (enabled) {
      const moreActionsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "boxesHorizontal",
        "aria-label": _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.moreActions', {
          defaultMessage: 'More actions'
        }),
        size: "s",
        display: "empty",
        onClick: togglePopover,
        isLoading: isLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 9
        }
      });
      const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "disable",
        onClick: () => {
          closePopover();
          if (onDisable) {
            onDisable();
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.disable",
        defaultMessage: "Disable service",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 13
        }
      })))];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 9
        }
      }, serviceUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 361,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        href: serviceUrl,
        target: "_blank",
        iconSide: "right",
        iconType: "popout",
        onClick: () => {
          // Track telemetry for opening service
          if (serviceKey) {
            telemetryService.trackLinkClicked({
              destination_type: 'service_portal',
              service_type: serviceKey
            });
          }
          if (onOpen) {
            onOpen();
          }
        },
        disabled: isLoading,
        isLoading: isLoading,
        "data-test-subj": "serviceCardOpenButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.open",
        defaultMessage: "Open",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 384,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 391,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: moreActionsButton,
        isOpen: isPopoverOpen,
        closePopover: closePopover,
        panelPaddingSize: "none",
        anchorPosition: "downRight",
        "data-test-subj": "serviceCardMoreActionsPopover",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: menuItems,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 400,
          columnNumber: 15
        }
      }))));
    }

    // Show external link icon if service is enabled via URL
    if (enableServiceByUrl) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        onClick: onEnable,
        disabled: !onEnable || isLoading,
        isLoading: isLoading,
        iconType: "popout",
        iconSide: "right",
        "data-test-subj": "serviceCardConnectButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 410,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.connect",
        defaultMessage: "Connect",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 419,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: onEnable,
      disabled: !onEnable || isLoading,
      isLoading: isLoading,
      "data-test-subj": "serviceCardConnectButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.connect",
      defaultMessage: "Connect",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    color: isCardDisabled ? 'subdued' : 'plain',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "flexStart",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 17
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 13
    }
  }, renderBadge())), region && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 15
    }
  }, region)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 11
    }
  }, description, ' ', learnMoreUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: learnMoreUrl,
    target: "_blank",
    external: true,
    onClick: () => {
      // Track telemetry for learn more link
      if (serviceKey) {
        telemetryService.trackLinkClicked({
          destination_type: 'service_documentation',
          service_type: serviceKey
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.service.learnMore",
    defaultMessage: "Learn more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 483,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 9
    }
  }, renderActions())), serviceKey === 'eis' && !hasActionsSavePrivilege && !hasAnyDefaultLLMConnectors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.missingPrivileges', {
      defaultMessage: 'Missing privileges'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.service.missingPrivilegesDescription",
    defaultMessage: "Full LLM functionality requires **Customize sub-feature privileges** to be switched on in the Kibana {privilege} privilege. When it is switched off, some features will be unavailable. Contact your administrator to make this change.",
    values: {
      privilege: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 513,
          columnNumber: 30
        }
      }, "Actions and Connectors")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 15
    }
  })))), serviceKey === 'eis' && enabled && hasActionsSavePrivilege && !hasAnyDefaultLLMConnectors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.missingLLMConnectors', {
      defaultMessage: 'Missing LLM connectors'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.service.missingLLMConnectorsDescription",
    defaultMessage: "Configuring LLM models will provide an enhanced experience. Reconnect EIS to install them.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 17
    }
  })))));
};
exports.ServiceCard = ServiceCard;