"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionWizard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../../app_context");
var _translations = require("./translations");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/onboarding/connection_wizard/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectionWizard = ({
  onConnect
}) => {
  const {
    docLinks,
    clusterConfig,
    cloudUrl,
    telemetryService,
    apiService,
    setJustConnected
  } = (0, _app_context.useCloudConnectedAppContext)();
  const [apiKey, setApiKey] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const clusterParams = (0, _utils.buildClusterQueryParams)(clusterConfig);
  const signupParams = clusterParams ? `&${clusterParams}` : '';

  // Build the full redirect URL and encode it for the login link
  const redirectUrl = clusterParams ? `/connect-cluster-services?${clusterParams}` : '/connect-cluster-services';
  const encodedRedirectUrl = encodeURIComponent(redirectUrl);
  const handleConnect = async () => {
    if (!apiKey.trim()) {
      return;
    }
    setIsLoading(true);
    setError(null);
    const {
      data,
      error: apiError
    } = await apiService.authenticate(apiKey.trim());
    if (apiError) {
      setError(apiError.message || 'Failed to authenticate with Cloud Connect');
      setIsLoading(false);
      return;
    }
    if (data !== null && data !== void 0 && data.success) {
      telemetryService.trackClusterConnected();
      setJustConnected(true);
      onConnect();
    }
    setIsLoading(false);
  };
  const handleSignUpClick = () => {
    telemetryService.trackLinkClicked({
      destination_type: 'cloud_signup'
    });
  };
  const handleLoginClick = () => {
    telemetryService.trackLinkClicked({
      destination_type: 'cloud_login'
    });
  };
  const step1 = {
    title: _translations.STEP_1_TITLE,
    titleSize: 'xs',
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, _translations.STEP_1_DESCRIPTION_1), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }, _translations.STEP_1_DESCRIPTION_2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: `${cloudUrl}/registration?onboarding_service_type=ccm${signupParams}`,
      target: "_blank",
      iconType: "popout",
      iconSide: "right",
      onClick: handleSignUpClick,
      "data-test-subj": "connectionWizardSignUpButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, _translations.SIGN_UP_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: `${cloudUrl}/login?redirectTo=${encodedRedirectUrl}`,
      target: "_blank",
      iconType: "popout",
      iconSide: "right",
      onClick: handleLoginClick,
      "data-test-subj": "connectionWizardLoginButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, _translations.LOGIN_BUTTON))))
  };
  const step2 = {
    title: _translations.STEP_2_TITLE,
    titleSize: 'xs',
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "connectionWizardEncryptionWarning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }, (0, _translations.getStep2Description)(docLinks.links.kibana.secureSavedObject)))
  };
  const stepApiKey = {
    title: _translations.STEP_3_TITLE,
    titleSize: 'xs',
    status: 'incomplete',
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }, (0, _translations.getStep3Description)())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: _translations.API_KEY_PLACEHOLDER,
      value: apiKey,
      onChange: e => setApiKey(e.target.value),
      fullWidth: true,
      disabled: isLoading || !(clusterConfig !== null && clusterConfig !== void 0 && clusterConfig.hasEncryptedSOEnabled),
      "data-test-subj": "connectionWizardApiKeyInput",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: handleConnect,
      disabled: !apiKey.trim() || isLoading || !(clusterConfig !== null && clusterConfig !== void 0 && clusterConfig.hasEncryptedSOEnabled),
      isLoading: isLoading,
      "data-test-subj": "connectionWizardConnectButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }, _translations.CONNECT_BUTTON))), error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Authentication failed",
      color: "danger",
      iconType: "error",
      "data-test-subj": "connectionWizardError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 15
      }
    }, error))))
  };

  // Only show step 2 (encryption warning) if encrypted saved objects is not enabled
  const steps = clusterConfig !== null && clusterConfig !== void 0 && clusterConfig.hasEncryptedSOEnabled ? [step1, stepApiKey] : [step1, step2, stepApiKey];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 10
    }
  });
};
exports.ConnectionWizard = ConnectionWizard;