"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceEnabledEventType = exports.serviceDisabledEventType = exports.linkClickedEventType = exports.clusterDisconnectedEventType = exports.clusterConnectedEventType = void 0;
var _constants = require("./constants");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clusterConnectedEventType = exports.clusterConnectedEventType = {
  eventType: _constants.CLOUD_CONNECT_CLUSTER_CONNECTED,
  schema: _schemas.clusterConnectedSchema
};
const clusterDisconnectedEventType = exports.clusterDisconnectedEventType = {
  eventType: _constants.CLOUD_CONNECT_CLUSTER_DISCONNECTED,
  schema: _schemas.clusterDisconnectedSchema
};
const serviceEnabledEventType = exports.serviceEnabledEventType = {
  eventType: _constants.CLOUD_CONNECT_SERVICE_ENABLED,
  schema: _schemas.serviceToggledSchema
};
const serviceDisabledEventType = exports.serviceDisabledEventType = {
  eventType: _constants.CLOUD_CONNECT_SERVICE_DISABLED,
  schema: _schemas.serviceToggledSchema
};
const linkClickedEventType = exports.linkClickedEventType = {
  eventType: _constants.CLOUD_CONNECT_LINK_CLICKED,
  schema: _schemas.linkClickedSchema
};