"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceToggledSchema = exports.linkClickedSchema = exports.clusterDisconnectedSchema = exports.clusterConnectedSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clusterConnectedSchema = exports.clusterConnectedSchema = {};
const clusterDisconnectedSchema = exports.clusterDisconnectedSchema = {};
const serviceToggledSchema = exports.serviceToggledSchema = {
  service_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of cloud service (derived from ClusterDetails services keys)'
    }
  },
  region_id: {
    type: 'keyword',
    _meta: {
      description: 'The cloud region identifier for the service',
      optional: true
    }
  }
};
const linkClickedSchema = exports.linkClickedSchema = {
  destination_type: {
    type: 'keyword',
    _meta: {
      description: 'The destination type of the link (e.g., cloud_connect_docs, cloud_signup, service_documentation, service_portal, migration_docs, onboarding_docs)'
    }
  },
  service_type: {
    type: 'keyword',
    _meta: {
      description: 'The service associated with the link (derived from ClusterDetails services keys), if applicable',
      optional: true
    }
  }
};