"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStorageService = createStorageService;
var _storage = require("../services/storage");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function to create a StorageService instance with all required clients
 * @param context - The request handler context
 * @param getStartServices - Function to get start services
 * @param logger - Logger instance
 * @returns Initialized StorageService instance
 */
async function createStorageService(context, getStartServices, logger) {
  const coreContext = await context.core;
  const [, {
    encryptedSavedObjects
  }] = await getStartServices();
  const encryptedSavedObjectsClient = encryptedSavedObjects.getClient({
    includedHiddenTypes: [_constants.CLOUD_CONNECT_API_KEY_TYPE]
  });
  const savedObjectsClient = coreContext.savedObjects.getClient({
    includedHiddenTypes: [_constants.CLOUD_CONNECT_API_KEY_TYPE]
  });
  return new _storage.StorageService({
    encryptedSavedObjectsClient,
    savedObjectsClient,
    logger
  });
}