"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _features = require("./features");
var _routes = require("./routes");
var _cloud_connect_api_key = require("./saved_objects/cloud_connect_api_key");
var _register_license_sync = require("./lib/register_license_sync");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class CloudConnectedPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", false);
    (0, _defineProperty2.default)(this, "cloudApiUrl", void 0);
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
    this.cloudApiUrl = `${this.config.cloudUrl}/api/v1`;
  }
  setup(core, plugins) {
    var _plugins$cloud;
    this.logger.debug('cloudConnected: Setup');

    // Skip plugin registration if running on Elastic Cloud.
    // This plugin is only for self-managed clusters connecting to Cloud services
    if ((_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && _plugins$cloud.isCloudEnabled) {
      this.logger.debug('cloudConnected: Skipping setup - running on Elastic Cloud');
      this.isCloudEnabled = true;
      return {};
    }

    // Register the feature with privileges
    plugins.features.registerKibanaFeature(_features.cloudConnectedFeature);

    // Register the saved object type for API key storage
    core.savedObjects.registerType(_cloud_connect_api_key.CloudConnectApiKeyType);

    // Register encryption for the API key saved object
    plugins.encryptedSavedObjects.registerType(_cloud_connect_api_key.CloudConnectApiKeyEncryptionParams);

    // Register HTTP routes
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      logger: this.logger,
      getStartServices: core.getStartServices,
      hasEncryptedSOEnabled: plugins.encryptedSavedObjects.canEncrypt,
      cloudApiUrl: this.cloudApiUrl
    });
    return {};
  }
  start(core, plugins) {
    this.logger.debug('cloudConnected: Started');

    // No-op if running on Elastic Cloud (plugin is effectively disabled there).
    if (this.isCloudEnabled) {
      return {};
    }
    this.licenseSubscription = (0, _register_license_sync.registerCloudConnectLicenseSync)({
      savedObjects: core.savedObjects,
      elasticsearchClient: core.elasticsearch.client.asInternalUser,
      encryptedSavedObjects: plugins.encryptedSavedObjects,
      licensing: plugins.licensing,
      logger: this.logger,
      cloudApiUrl: this.cloudApiUrl
    });
    return {};
  }
  stop() {
    var _this$licenseSubscrip;
    (_this$licenseSubscrip = this.licenseSubscription) === null || _this$licenseSubscrip === void 0 ? void 0 : _this$licenseSubscrip.unsubscribe();
    this.licenseSubscription = undefined;
  }
}
exports.CloudConnectedPlugin = CloudConnectedPlugin;