"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectApiKeyType = exports.CloudConnectApiKeyEncryptionParams = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudConnectApiKeySchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string(),
  clusterId: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string())
});
const CloudConnectApiKeyType = exports.CloudConnectApiKeyType = {
  name: _constants.CLOUD_CONNECT_API_KEY_TYPE,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      apiKey: {
        type: 'binary'
      },
      clusterId: {
        type: 'keyword'
      },
      createdAt: {
        type: 'date'
      },
      updatedAt: {
        type: 'date'
      }
    }
  },
  management: {
    importableAndExportable: false,
    displayName: 'Cloud Connect API Key'
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        forwardCompatibility: cloudConnectApiKeySchema.extends({}, {
          unknowns: 'ignore'
        }),
        create: cloudConnectApiKeySchema
      }
    }
  }
};
const CloudConnectApiKeyEncryptionParams = exports.CloudConnectApiKeyEncryptionParams = {
  type: _constants.CLOUD_CONNECT_API_KEY_TYPE,
  attributesToEncrypt: new Set(['apiKey']),
  attributesToIncludeInAAD: new Set(['clusterId'])
};