"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _set_cloud_data_route = require("./set_cloud_data_route");
var _elasticsearch_route = require("./elasticsearch_route");
var _get_cloud_data_route = require("./get_cloud_data_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(opts) {
  const {
    logger,
    elasticsearchUrl,
    router
  } = opts;
  (0, _elasticsearch_route.setElasticsearchRoute)({
    logger,
    elasticsearchUrl,
    router
  });
  (0, _get_cloud_data_route.setGetCloudSolutionDataRoute)({
    logger,
    router
  });
  (0, _set_cloud_data_route.setPostCloudSolutionDataRoute)({
    logger,
    router
  });
}