"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationRoute = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _use_cis_kubernetes_integration = require("./use_cis_kubernetes_integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddIntegrationRoute = category => {
  const cisIntegration = (0, _use_cis_kubernetes_integration.useCisKubernetesIntegration)();
  if (!cisIntegration.isSuccess) return;
  const addIntegrationPath = _public.pagePathGetters.integrations_all({
    category: 'security',
    subCategory: `${category}`
  }).join('');
  return addIntegrationPath;
};
exports.useAddIntegrationRoute = useAddIntegrationRoute;