"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActiveNamespace = void 0;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActiveNamespace = ({
  postureType
}) => {
  const [localStorageActiveNamespace, localStorageSetActiveNamespace] = (0, _useLocalStorage.default)(`${_constants.LOCAL_STORAGE_NAMESPACE_KEY}:${postureType}`, _constants.DEFAULT_NAMESPACE);
  const [activeNamespace, setActiveNamespaceState] = (0, _react.useState)(localStorageActiveNamespace || _constants.DEFAULT_NAMESPACE);
  const updateActiveNamespace = (0, _react.useCallback)(namespace => {
    setActiveNamespaceState(namespace);
    localStorageSetActiveNamespace(namespace);
    const metric = postureType === 'cspm' ? _ui_metrics.CSPM_NAMESPACE_SELECTOR : _ui_metrics.KSPM_NAMESPACE_SELECTOR;
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, metric);
  }, [localStorageSetActiveNamespace, postureType]);
  return {
    activeNamespace,
    updateActiveNamespace
  };
};
exports.useActiveNamespace = useActiveNamespace;