"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspPolicyTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/cloud-security-posture-common/constants");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _i18n = require("@kbn/i18n");
var _subscription_not_allowed = require("../subscription_not_allowed");
var _constants2 = require("../../../common/constants");
var _utils = require("./utils");
var _policy_template_selectors = require("./policy_template_selectors");
var _cnvm_kspm_setup = require("./cnvm_kspm/cnvm_kspm_setup");
var _use_load_fleet_extension = require("./use_load_fleet_extension");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/policy_template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditScreenStepTitle = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h4", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.integrationSettingsTitle",
  defaultMessage: "Integration Settings",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
const DEFAULT_INPUT_TYPE = {
  kspm: _constants2.CLOUDBEAT_VANILLA,
  cspm: _constants2.CLOUDBEAT_AWS,
  vuln_mgmt: _constants2.CLOUDBEAT_VULN_MGMT_AWS
};
const CspPolicyTemplateForm = exports.default = exports.CspPolicyTemplateForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  validationResults,
  isEditPage,
  packageInfo,
  handleSetupTechnologyChange,
  isAgentlessEnabled,
  defaultSetupTechnology,
  integrationToEnable,
  setIntegrationToEnable
}) => {
  const CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AWS = '2.0.0-preview01';
  const CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AZURE = '3.1.0-preview02';
  const CLOUD_CREDENTIALS_PACKAGE_VERSION = '1.11.0-preview13';
  const GCP_MINIMUM_ORGANIZATION_VERSION = '1.6.0';
  const GCP_MINIMUM_PACKAGE_VERSION = '1.5.2';
  const AWS_MINIMUM_ORGANIZATION_VERSION = '1.5.0-preview20';
  const AZURE_MINIMUM_PACKAGE_VERSION = '1.6.0';
  const AZURE_MINIMUM_ORGANIZATION_VERSION = '1.7.0';
  const AZURE_MANUAL_FIELDS_PACKAGE_VERSION = '1.7.0';
  const showCloudTemplates = (0, _gte.default)(packageInfo.version, CLOUD_CREDENTIALS_PACKAGE_VERSION);
  const enableGcpOrganization = (0, _gte.default)(packageInfo.version, GCP_MINIMUM_ORGANIZATION_VERSION);
  const enableAwsOrganization = (0, _gte.default)(packageInfo.version, AWS_MINIMUM_ORGANIZATION_VERSION);
  const enableAzureOrganization = (0, _gte.default)(packageInfo.version, AZURE_MINIMUM_ORGANIZATION_VERSION);
  const enableAzure = (0, _gte.default)(packageInfo.version, AZURE_MINIMUM_PACKAGE_VERSION);
  const enableGcp = (0, _gte.default)(packageInfo.version, GCP_MINIMUM_PACKAGE_VERSION);
  const azureManualFieldsEnabled = (0, _gte.default)(packageInfo.version, AZURE_MANUAL_FIELDS_PACKAGE_VERSION);
  const CLOUD_SETUP_MAPPING = {
    policyTemplate: _constants.CSPM_POLICY_TEMPLATE,
    defaultProvider: 'aws',
    namespaceSupportEnabled: true,
    name: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.nameTitle', {
      defaultMessage: 'Cloud Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'CSPM'
    }),
    overviewPath: `https://ela.st/cspm-overview`,
    getStartedPath: `https://ela.st/cspm-get-started`,
    showCloudTemplates,
    providers: {
      aws: {
        type: _constants2.CLOUDBEAT_AWS,
        enableOrganization: enableAwsOrganization,
        getStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started.html`,
        cloudConnectorEnabledVersion: CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AWS
      },
      gcp: {
        type: _constants2.CLOUDBEAT_GCP,
        enableOrganization: enableGcpOrganization,
        getStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started-gcp.html`,
        enabled: enableGcp
      },
      azure: {
        type: _constants2.CLOUDBEAT_AZURE,
        enabled: enableAzure,
        enableOrganization: enableAzureOrganization,
        getStartedPath: `https://www.elastic.co/guide/en/security/current/cspm-get-started-azure.html`,
        manualFieldsEnabled: azureManualFieldsEnabled,
        cloudConnectorEnabledVersion: CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AZURE
      }
    }
  };
  const integrationParam = (0, _reactRouterDom.useParams)().integration;
  const isParentSecurityPosture = !integrationParam;
  const isDefaultIntegrationSetRef = (0, _react.useRef)(false);
  if (!isDefaultIntegrationSetRef.current && !integrationToEnable && setIntegrationToEnable) {
    isDefaultIntegrationSetRef.current = true;
    setIntegrationToEnable(_constants.CSPM_POLICY_TEMPLATE);
  }
  const {
    cloud,
    input,
    isLoading,
    isSubscriptionValid,
    isValid,
    setEnabledPolicyInput,
    uiSettings,
    updatePolicy
  } = (0, _use_load_fleet_extension.useLoadFleetExtension)({
    newPolicy,
    onChange,
    isEditPage,
    packageInfo,
    integrationToEnable: integrationToEnable,
    validationResults
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": _utils.POLICY_TEMPLATE_FORM_DTS.LOADER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    })));
  }
  if (!isLoading && !isSubscriptionValid) {
    return /*#__PURE__*/_react.default.createElement(_subscription_not_allowed.SubscriptionNotAllowed, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 14
      }
    });
  }
  // If the input type is one of the cloud providers, we need to render the account type selector
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditPage && /*#__PURE__*/_react.default.createElement(EditScreenStepTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 24
    }
  }), isParentSecurityPosture && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateSelector, {
    selectedTemplate: input.policy_template,
    policy: newPolicy,
    setPolicyTemplate: template => {
      setEnabledPolicyInput(DEFAULT_INPUT_TYPE[template]);
      setIntegrationToEnable === null || setIntegrationToEnable === void 0 ? void 0 : setIntegrationToEnable(template);
    },
    disabled: isEditPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  })), isEditPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    title: _i18n.i18n.translate('xpack.csp.fleetIntegration.editWarning.calloutTitle', {
      defaultMessage: 'Modifying Integration Details'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.editWarning.calloutDescription",
    defaultMessage: "In order to change the cloud service provider (CSP) you want to monitor, add more accounts, or change where CSPM is deployed (Organization vs Single Account), please add a new CSPM integration.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  })), input.policy_template === _constants.CSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CloudSetup, {
    configuration: CLOUD_SETUP_MAPPING,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    isEditPage: isEditPage,
    validationResults: validationResults,
    defaultSetupTechnology: defaultSetupTechnology,
    isAgentlessEnabled: isAgentlessEnabled,
    handleSetupTechnologyChange: handleSetupTechnologyChange,
    isValid: isValid,
    cloud: cloud,
    uiSettings: uiSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }), (input.policy_template === _constants.KSPM_POLICY_TEMPLATE || input.policy_template === _constants2.VULN_MGMT_POLICY_TEMPLATE) && /*#__PURE__*/_react.default.createElement(_cnvm_kspm_setup.CnvmKspmSetup, {
    newPolicy: newPolicy,
    packageInfo: packageInfo,
    setEnabledPolicyInput: setEnabledPolicyInput,
    updatePolicy: updatePolicy,
    validationResults: validationResults,
    isEditPage: isEditPage,
    input: input,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }));
});
CspPolicyTemplateForm.displayName = 'CspPolicyTemplateForm';

// eslint-disable-next-line import/no-default-export