"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignments = Assignments;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _assignment = require("../assignment/assignment");
var _color_mapping = require("../../state/color_mapping");
var _selectors = require("../../state/selectors");
var _color_assignment_matcher = require("../../color/color_assignment_matcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/container/assignments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Assignments({
  data,
  palettes,
  isDarkMode,
  specialTokens,
  formatter,
  allowCustomMatch
}) {
  const [showOtherActions, setShowOtherActions] = (0, _react2.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(palettes));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const assignments = (0, _reactRedux.useSelector)(_selectors.selectComputedAssignments);
  const assignmentMatcher = (0, _react2.useMemo)(() => (0, _color_assignment_matcher.getColorAssignmentMatcher)(assignments), [assignments]);
  const unmatchingCategories = (0, _react2.useMemo)(() => {
    return data.type === 'categories' ? data.categories.filter(category => {
      const rawValue = (0, _common.deserializeField)(category);
      return !assignmentMatcher.hasMatch(rawValue);
    }) : [];
  }, [data, assignmentMatcher]);
  const onClickAddNewAssignment = (0, _react2.useCallback)(() => {
    const lastCategorical = assignments.findLast(a => {
      return a.color.type === 'categorical';
    });
    const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
    dispatch((0, _color_mapping.addNewAssignment)({
      rules: [],
      color: colorMode.type === 'categorical' ? {
        type: 'categorical',
        paletteId: palette.id,
        colorIndex: nextCategoricalIndex % palette.colors().length
      } : {
        type: 'gradient'
      },
      touched: false
    }));
  }, [assignments, colorMode.type, dispatch, palette]);
  const onClickAddAllCurrentCategories = (0, _react2.useCallback)(() => {
    if (data.type === 'categories') {
      const lastCategorical = (0, _lodash.findLast)(assignments, d => {
        return d.color.type === 'categorical';
      });
      const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
      const newAssignments = unmatchingCategories.map((category, i) => {
        return {
          rules: [{
            type: 'raw',
            value: category
          }],
          color: colorMode.type === 'categorical' ? {
            type: 'categorical',
            paletteId: palette.id,
            colorIndex: (nextCategoricalIndex + i) % palette.colors().length
          } : {
            type: 'gradient'
          },
          touched: false
        };
      });
      dispatch((0, _color_mapping.addNewAssignments)(newAssignments));
    }
  }, [data.type, assignments, unmatchingCategories, dispatch, colorMode.type, palette]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "m",
    hasShadow: false,
    paddingSize: "none",
    css: (0, _react.css)`
        overflow: hidden;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingSmall};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "lns-colorMapping-assignmentsList",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, assignments.map((assignment, i) => {
    return /*#__PURE__*/_react2.default.createElement(_assignment.Assignment, {
      key: i,
      data: data,
      index: i,
      assignments: assignments,
      colorMode: colorMode,
      palette: palette,
      palettes: palettes,
      isDarkMode: isDarkMode,
      assignment: assignment,
      disableDelete: false,
      specialTokens: specialTokens,
      formatter: formatter,
      allowCustomMatch: allowCustomMatch,
      assignmentMatcher: assignmentMatcher,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 15
      }
    });
  }), assignments.length === 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    paddingSize: "s",
    "data-test-subj": "lns-colorMapping-assignmentsPrompt",
    body: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('coloring.colorMapping.container.mapValuesPromptDescription.mapValuesPromptDetail', {
      defaultMessage: 'Add a new assignment to manually associate terms with specified colors.'
    }))),
    actions: [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "primary",
      size: "s",
      onClick: onClickAddNewAssignment,
      iconType: "plus",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('coloring.colorMapping.container.AddAssignmentButtonLabel', {
      defaultMessage: 'Add assignment'
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lns-colorMapping-assignmentsPromptAddAll",
      size: "xs",
      onClick: onClickAddAllCurrentCategories,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('coloring.colorMapping.container.mapValueButtonLabel', {
      defaultMessage: 'Add all unassigned terms'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }))), assignments.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 34
    }
  }), assignments.length > 0 && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingSmall};
            overflow: hidden;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    onClick: onClickAddNewAssignment,
    iconType: "plus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('coloring.colorMapping.container.AddAssignmentButtonLabel', {
    defaultMessage: 'Add assignment'
  })), data.type === 'categories' && /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      color: "text",
      "aria-label": _i18n.i18n.translate('coloring.colorMapping.container.OpenAdditionalActionsButtonLabel', {
        defaultMessage: 'Open additional assignments actions'
      }),
      onClick: () => setShowOtherActions(true),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 19
      }
    }),
    isOpen: showOtherActions,
    closePopover: () => setShowOtherActions(false),
    panelPaddingSize: "xs",
    anchorPosition: "downRight",
    ownFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "lns-colorMapping-addAllAssignments",
      key: "item-1",
      icon: "listAdd",
      size: "s",
      onClick: () => {
        setShowOtherActions(false);
        requestAnimationFrame(() => {
          onClickAddAllCurrentCategories();
        });
      },
      disabled: unmatchingCategories.length === 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('coloring.colorMapping.container.mapCurrentValuesButtonLabel', {
      defaultMessage: 'Add all unsassigned terms'
    })), unmatchingCategories.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 29
      }
    }, unmatchingCategories.length)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "lns-colorMapping-clearAllAssignments",
      size: "s",
      icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "eraser",
        size: "m",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 29
        }
      }),
      onClick: () => {
        setShowOtherActions(false);
        dispatch((0, _color_mapping.removeAllAssignments)());
      },
      css: (0, _react.css)`
                        color: ${_uiTheme.euiThemeVars.euiColorDanger};
                      `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('coloring.colorMapping.container.clearAllAssignmentsButtonLabel', {
      defaultMessage: 'Clear all assignments'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  })))));
}