"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.DEFAULT_URL = exports.DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_MODEL = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.bedrock';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.bedrock.title', {
  defaultMessage: 'Amazon Bedrock'
});
const DEFAULT_MODEL = exports.DEFAULT_MODEL = 'us.anthropic.claude-sonnet-4-5-20250929-v1:0';
const DEFAULT_URL = exports.DEFAULT_URL = `https://bedrock-runtime.us-east-1.amazonaws.com`;
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 200000;
const DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TOKEN_LIMIT = 8191;
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_AI_RAW"] = "invokeAIRaw";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  SUB_ACTION["BEDROCK_CLIENT_SEND"] = "bedrockClientSend";
  SUB_ACTION["CONVERSE"] = "converse";
  SUB_ACTION["CONVERSE_STREAM"] = "converseStream";
  return SUB_ACTION;
}({});