"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryMetadataSchema = exports.StreamingResponseSchema = exports.SecretsSchema = exports.RunApiResponseSchema = exports.RunActionResponseSchema = exports.RunActionRawResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TelemetryMetadataSchema = exports.TelemetryMetadataSchema = _zod.z.object({
  pluginId: _zod.z.string().optional(),
  aggregateBy: _zod.z.string().optional()
}).strict();
const ConfigSchema = exports.ConfigSchema = _zod.z.object({
  apiUrl: _zod.z.string(),
  defaultModel: _zod.z.string().default(_constants.DEFAULT_MODEL),
  gcpRegion: _zod.z.string(),
  gcpProjectID: _zod.z.string(),
  contextWindowLength: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional()
}).strict();
const SecretsSchema = exports.SecretsSchema = _zod.z.object({
  credentialsJson: _zod.z.string()
}).strict();
const RunActionParamsSchema = exports.RunActionParamsSchema = _zod.z.object({
  body: _zod.z.any(),
  model: _zod.z.string().optional(),
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  raw: _zod.z.boolean().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const RunApiResponseSchema = exports.RunApiResponseSchema = _zod.z.object({
  candidates: _zod.z.any(),
  usageMetadata: _zod.z.object({
    promptTokenCount: _zod.z.coerce.number(),
    candidatesTokenCount: _zod.z.coerce.number(),
    totalTokenCount: _zod.z.coerce.number()
  })
});
const RunActionResponseSchema = exports.RunActionResponseSchema = _zod.z.object({
  completion: _zod.z.string(),
  stop_reason: _zod.z.string().optional(),
  usageMetadata: _zod.z.object({
    promptTokenCount: _zod.z.coerce.number(),
    candidatesTokenCount: _zod.z.coerce.number(),
    totalTokenCount: _zod.z.coerce.number()
  }).optional()
});
const RunActionRawResponseSchema = exports.RunActionRawResponseSchema = _zod.z.any();
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _zod.z.object({
  maxOutputTokens: _zod.z.coerce.number().optional(),
  messages: _zod.z.any(),
  systemInstruction: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  temperature: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  tools: _zod.z.array(_zod.z.any()).optional(),
  toolConfig: _zod.z.object({
    mode: _zod.z.enum(['AUTO', 'ANY', 'NONE']),
    allowedFunctionNames: _zod.z.array(_zod.z.string()).optional()
  }).strict().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const InvokeAIRawActionParamsSchema = exports.InvokeAIRawActionParamsSchema = _zod.z.object({
  maxOutputTokens: _zod.z.coerce.number().optional(),
  messages: _zod.z.any(),
  systemInstruction: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  temperature: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  tools: _zod.z.array(_zod.z.any()).optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _zod.z.object({
  message: _zod.z.string(),
  usageMetadata: _zod.z.object({
    promptTokenCount: _zod.z.coerce.number(),
    candidatesTokenCount: _zod.z.coerce.number(),
    totalTokenCount: _zod.z.coerce.number()
  }).optional()
});
const InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionResponseSchema = _zod.z.any();
const StreamingResponseSchema = exports.StreamingResponseSchema = _zod.z.any();
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _zod.z.object({
  dashboardId: _zod.z.string()
}).strict();
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _zod.z.object({
  available: _zod.z.boolean()
});