"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedChatCompleteResponseSchema = exports.UnifiedChatCompleteParamsSchema = exports.TextEmbeddingResponseSchema = exports.TextEmbeddingParamsSchema = exports.TelemetryMetadataSchema = exports.StreamingResponseSchema = exports.SparseEmbeddingResponseSchema = exports.SparseEmbeddingParamsSchema = exports.SecretsSchema = exports.RerankResponseSchema = exports.RerankParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = exports.ChatCompleteResponseSchema = exports.ChatCompleteParamsSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TelemetryMetadataSchema = exports.TelemetryMetadataSchema = _zod.z.object({
  pluginId: _zod.z.string().optional(),
  aggregateBy: _zod.z.string().optional()
}).strict();
const ConfigSchema = exports.ConfigSchema = _zod.z.object({
  provider: _zod.z.string(),
  taskType: _zod.z.string(),
  inferenceId: _zod.z.string(),
  providerConfig: _zod.z.object({}).passthrough().default({}),
  taskTypeConfig: _zod.z.object({}).passthrough().default({}),
  contextWindowLength: _zod.z.coerce.number().optional(),
  headers: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
  temperature: _zod.z.coerce.number().optional()
}).strict();
const SecretsSchema = exports.SecretsSchema = _zod.z.object({
  providerSecrets: _zod.z.object({}).passthrough().default({})
}).strict();
const ChatCompleteParamsSchema = exports.ChatCompleteParamsSchema = _zod.z.object({
  input: _zod.z.string()
}).strict();

// subset of OpenAI.ChatCompletionMessageParam https://github.com/openai/openai-node/blob/master/src/resources/chat/completions.ts
const AIMessage = _zod.z.object({
  role: _zod.z.string(),
  content: _zod.z.string().nullish(),
  name: _zod.z.string().optional(),
  tool_calls: _zod.z.array(_zod.z.object({
    id: _zod.z.string(),
    function: _zod.z.object({
      arguments: _zod.z.string().optional(),
      name: _zod.z.string().optional()
    }).strict(),
    type: _zod.z.string()
  }).strict()).optional(),
  tool_call_id: _zod.z.string().optional()
}).strict();
const AITool = _zod.z.object({
  type: _zod.z.string(),
  function: _zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string().optional(),
    parameters: _zod.z.record(_zod.z.string(), _zod.z.any()).optional()
  }).strict()
}).strict();

// subset of OpenAI.ChatCompletionCreateParamsBase https://github.com/openai/openai-node/blob/master/src/resources/chat/completions.ts
const UnifiedChatCompleteParamsSchema = exports.UnifiedChatCompleteParamsSchema = _zod.z.object({
  body: _zod.z.object({
    messages: _zod.z.array(AIMessage).default([]),
    model: _zod.z.string().optional(),
    /**
     * The maximum number of [tokens](/tokenizer) that can be generated in the chat
     * completion. This value can be used to control
     * [costs](https://openai.com/api/pricing/) for text generated via API.
     *
     * This value is now deprecated in favor of `max_completion_tokens`, and is not
     * compatible with
     * [o1 series models](https://platform.openai.com/docs/guides/reasoning).
     */
    max_tokens: _zod.z.coerce.number().optional(),
    /**
     * Developer-defined tags and values used for filtering completions in the
     * [dashboard](https://platform.openai.com/chat-completions).
     */
    metadata: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
    /**
     * How many chat completion choices to generate for each input message. Note that
     * you will be charged based on the number of generated tokens across all of the
     * choices. Keep `n` as `1` to minimize costs.
     */
    n: _zod.z.coerce.number().optional(),
    /**
     * Up to 4 sequences where the API will stop generating further tokens.
     */
    stop: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).nullish(),
    /**
    * The maximum number of tokens to generate in the completion. Requests can use
    z.union([z.string(), z.array(z.string)]).optional(),
    /**
    * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will
    * make the output more random, while lower values like 0.2 will make it more
    * focused and deterministic.
    *
    * We generally recommend altering this or `top_p` but not both.
    */
    temperature: _zod.z.coerce.number().optional(),
    /**
     * Controls which (if any) tool is called by the model. `none` means the model will
     * not call any tool and instead generates a message. `auto` means the model can
     * pick between generating a message or calling one or more tools. `required` means
     * the model must call one or more tools. Specifying a particular tool via
     * `{"type": "function", "function": {"name": "my_function"}}` forces the model to
     * call that tool.
     *
     * `none` is the default when no tools are present. `auto` is the default if tools
     * are present.
     */
    tool_choice: _zod.z.union([_zod.z.string(), _zod.z.object({
      type: _zod.z.string(),
      function: _zod.z.object({
        name: _zod.z.string()
      }).strict()
    }).strict()]).optional(),
    /**
     * A list of tools the model may call. Currently, only functions are supported as a
     * tool. Use this to provide a list of functions the model may generate JSON inputs
     * for. A max of 128 functions are supported.
     */
    tools: _zod.z.array(AITool).optional(),
    /**
     * An alternative to sampling with temperature, called nucleus sampling, where the
     * model considers the results of the tokens with top_p probability mass. So 0.1
     * means only the tokens comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or `temperature` but not both.
     */
    top_p: _zod.z.coerce.number().optional(),
    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor
     * and detect abuse.
     * [Learn more](https://platform.openai.com/docs/guides/safety-best-practices/end-user-ids).
     */
    user: _zod.z.string().optional()
  }).strict(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const UnifiedChatCompleteResponseSchema = exports.UnifiedChatCompleteResponseSchema = _zod.z.object({
  id: _zod.z.string(),
  choices: _zod.z.array(_zod.z.object({
    finish_reason: _zod.z.enum(['stop', 'length', 'tool_calls', 'content_filter', 'function_call']).nullish(),
    index: _zod.z.coerce.number().optional(),
    message: _zod.z.object({
      content: _zod.z.string().nullish(),
      refusal: _zod.z.string().nullish(),
      role: _zod.z.string().optional(),
      tool_calls: _zod.z.array(_zod.z.object({
        id: _zod.z.string().optional(),
        index: _zod.z.coerce.number().optional(),
        function: _zod.z.object({
          arguments: _zod.z.string().optional(),
          name: _zod.z.string().optional()
        }).strict().optional(),
        type: _zod.z.string().optional()
      }).strict()).default([]).optional()
    }).strict()
  }).strict()).default([]),
  created: _zod.z.coerce.number().optional(),
  model: _zod.z.string().optional(),
  object: _zod.z.string().optional(),
  usage: _zod.z.object({
    completion_tokens: _zod.z.coerce.number().optional(),
    prompt_tokens: _zod.z.coerce.number().optional(),
    total_tokens: _zod.z.coerce.number().optional()
  }).strict().nullish()
}).strict();
const ChatCompleteResponseSchema = exports.ChatCompleteResponseSchema = _zod.z.array(_zod.z.object({
  result: _zod.z.string()
}).strict()).default([]);
const RerankParamsSchema = exports.RerankParamsSchema = _zod.z.object({
  input: _zod.z.array(_zod.z.string()).default([]),
  query: _zod.z.string()
}).strict();
const RerankResponseSchema = exports.RerankResponseSchema = _zod.z.array(_zod.z.object({
  text: _zod.z.string().optional(),
  index: _zod.z.coerce.number(),
  score: _zod.z.coerce.number()
}).strict()).default([]);
const SparseEmbeddingParamsSchema = exports.SparseEmbeddingParamsSchema = _zod.z.object({
  input: _zod.z.string()
}).strict();
const SparseEmbeddingResponseSchema = exports.SparseEmbeddingResponseSchema = _zod.z.array(_zod.z.object({}).passthrough()).default([]);
const TextEmbeddingParamsSchema = exports.TextEmbeddingParamsSchema = _zod.z.object({
  input: _zod.z.string(),
  inputType: _zod.z.string()
}).strict();
const TextEmbeddingResponseSchema = exports.TextEmbeddingResponseSchema = _zod.z.array(_zod.z.object({
  embedding: _zod.z.array(_zod.z.any()).default([])
}).strict()).default([]);
const StreamingResponseSchema = exports.StreamingResponseSchema = _zod.z.any();

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _zod.z.object({
  dashboardId: _zod.z.string()
}).strict();
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _zod.z.object({
  available: _zod.z.boolean()
}).strict();