"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.MCP_CLIENT_VERSION = exports.MAX_RETRIES = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.mcp';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.mcp.title', {
  defaultMessage: 'MCP'
});

/**
 * MCP client version used by the connector.
 */
const MCP_CLIENT_VERSION = exports.MCP_CLIENT_VERSION = '1.0.0';
const MAX_RETRIES = exports.MAX_RETRIES = 2; // Three total attempts (1 initial + 2 retries)

/**
 * Sub-actions supported by the MCP connector.
 * Values must match the registered sub-action names in the backend.
 */
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["INITIALIZE"] = "test";
  SUB_ACTION["LIST_TOOLS"] = "listTools";
  SUB_ACTION["CALL_TOOL"] = "callTool";
  return SUB_ACTION;
}({});