"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneSecretsSchema = exports.SentinelOneReleaseHostSchema = exports.SentinelOneIsolateHostSchema = exports.SentinelOneIsolateHostResponseSchema = exports.SentinelOneIsolateHostParamsSchema = exports.SentinelOneGetRemoteScriptsResponseSchema = exports.SentinelOneGetRemoteScriptsParamsSchema = exports.SentinelOneGetRemoteScriptStatusResponseSchema = exports.SentinelOneGetRemoteScriptStatusParamsSchema = exports.SentinelOneGetRemoteScriptResultsResponseSchema = exports.SentinelOneGetRemoteScriptResultsParamsSchema = exports.SentinelOneGetAgentsResponseSchema = exports.SentinelOneGetAgentsParamsSchema = exports.SentinelOneGetActivitiesResponseSchema = exports.SentinelOneGetActivitiesResponseNoDataSchema = exports.SentinelOneGetActivitiesResponseDataSchema = exports.SentinelOneGetActivitiesParamsSchema = exports.SentinelOneFetchAgentFilesResponseSchema = exports.SentinelOneFetchAgentFilesParamsSchema = exports.SentinelOneExecuteScriptSchema = exports.SentinelOneExecuteScriptResponseSchema = exports.SentinelOneExecuteScriptParamsSchema = exports.SentinelOneDownloadRemoteScriptResultsResponseSchema = exports.SentinelOneDownloadRemoteScriptResultsParamsSchema = exports.SentinelOneDownloadAgentFileResponseSchema = exports.SentinelOneDownloadAgentFileParamsSchema = exports.SentinelOneConfigSchema = exports.SentinelOneBaseFilterSchema = exports.SentinelOneBaseApiResponseSchema = exports.SentinelOneApiDoNotValidateResponsesSchema = exports.SentinelOneActionParamsSchema = exports.AlertIds = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable @typescript-eslint/naming-convention */

// Connector schema
const SentinelOneConfigSchema = exports.SentinelOneConfigSchema = _zod.z.object({
  url: _zod.z.string()
}).strict();
const SentinelOneSecretsSchema = exports.SentinelOneSecretsSchema = _zod.z.object({
  token: _zod.z.string()
}).strict();
const SentinelOneApiDoNotValidateResponsesSchema = exports.SentinelOneApiDoNotValidateResponsesSchema = _zod.z.any();
const SentinelOneBaseApiResponseSchema = exports.SentinelOneBaseApiResponseSchema = _zod.z.object({}).passthrough().optional();
const SentinelOneGetAgentsResponseSchema = exports.SentinelOneGetAgentsResponseSchema = _zod.z.object({
  pagination: _zod.z.object({
    totalItems: _zod.z.coerce.number(),
    nextCursor: _zod.z.string().nullable().default(null)
  }).strict(),
  errors: _zod.z.array(_zod.z.string()).nullable().default(null),
  data: _zod.z.array(_zod.z.object({
    modelName: _zod.z.string(),
    firewallEnabled: _zod.z.boolean(),
    totalMemory: _zod.z.coerce.number(),
    osName: _zod.z.string(),
    cloudProviders: _zod.z.record(_zod.z.string(), _zod.z.any()),
    siteName: _zod.z.string(),
    cpuId: _zod.z.string(),
    isPendingUninstall: _zod.z.boolean(),
    isUpToDate: _zod.z.boolean(),
    osArch: _zod.z.string(),
    accountId: _zod.z.string(),
    locationEnabled: _zod.z.boolean(),
    consoleMigrationStatus: _zod.z.string(),
    scanFinishedAt: _zod.z.string().nullable().default(null),
    operationalStateExpiration: _zod.z.string().nullable().default(null),
    agentVersion: _zod.z.string(),
    isActive: _zod.z.boolean(),
    locationType: _zod.z.string(),
    activeThreats: _zod.z.coerce.number(),
    inRemoteShellSession: _zod.z.boolean(),
    allowRemoteShell: _zod.z.boolean(),
    serialNumber: _zod.z.string().nullable().default(null),
    updatedAt: _zod.z.string(),
    lastActiveDate: _zod.z.string(),
    firstFullModeTime: _zod.z.string().nullable().default(null),
    operationalState: _zod.z.string(),
    externalId: _zod.z.string(),
    mitigationModeSuspicious: _zod.z.string(),
    licenseKey: _zod.z.string(),
    cpuCount: _zod.z.coerce.number(),
    mitigationMode: _zod.z.string(),
    networkStatus: _zod.z.string(),
    installerType: _zod.z.string(),
    uuid: _zod.z.string(),
    detectionState: _zod.z.string().nullable().default(null),
    infected: _zod.z.boolean(),
    registeredAt: _zod.z.string(),
    lastIpToMgmt: _zod.z.string(),
    storageName: _zod.z.string().nullable().default(null),
    osUsername: _zod.z.string().nullable().default(null),
    groupIp: _zod.z.string(),
    createdAt: _zod.z.string(),
    remoteProfilingState: _zod.z.string(),
    groupUpdatedAt: _zod.z.string().nullable().default(null),
    scanAbortedAt: _zod.z.string().nullable().default(null),
    isUninstalled: _zod.z.boolean(),
    networkQuarantineEnabled: _zod.z.boolean(),
    tags: _zod.z.object({
      sentinelone: _zod.z.array(_zod.z.object({
        assignedBy: _zod.z.string(),
        assignedAt: _zod.z.string(),
        assignedById: _zod.z.string(),
        key: _zod.z.string(),
        value: _zod.z.string(),
        id: _zod.z.string()
      }).strict())
    }).strict(),
    externalIp: _zod.z.string(),
    siteId: _zod.z.string(),
    machineType: _zod.z.string(),
    domain: _zod.z.string(),
    scanStatus: _zod.z.string(),
    osStartTime: _zod.z.string(),
    accountName: _zod.z.string(),
    lastLoggedInUserName: _zod.z.string(),
    showAlertIcon: _zod.z.boolean(),
    rangerStatus: _zod.z.string(),
    groupName: _zod.z.string(),
    threatRebootRequired: _zod.z.boolean(),
    remoteProfilingStateExpiration: _zod.z.string().nullable().default(null),
    policyUpdatedAt: _zod.z.string().nullable().default(null),
    activeDirectory: _zod.z.object({
      userPrincipalName: _zod.z.string().nullable().default(null),
      lastUserDistinguishedName: _zod.z.string().nullable().default(null),
      computerMemberOf: _zod.z.array(_zod.z.object({
        type: _zod.z.string()
      }).passthrough()),
      lastUserMemberOf: _zod.z.array(_zod.z.object({
        type: _zod.z.string()
      }).passthrough()),
      mail: _zod.z.string().nullable().default(null),
      computerDistinguishedName: _zod.z.string().nullable().default(null)
    }).passthrough(),
    isDecommissioned: _zod.z.boolean(),
    rangerVersion: _zod.z.string(),
    userActionsNeeded: _zod.z.array(_zod.z.object({
      type: _zod.z.string(),
      example: _zod.z.string(),
      enum: _zod.z.array(_zod.z.string())
    }).passthrough()),
    locations: _zod.z.array(_zod.z.object({
      name: _zod.z.string(),
      scope: _zod.z.string(),
      id: _zod.z.string()
    }).passthrough()).nullable().default(null),
    id: _zod.z.string(),
    coreCount: _zod.z.coerce.number(),
    osRevision: _zod.z.string(),
    osType: _zod.z.string(),
    groupId: _zod.z.string(),
    computerName: _zod.z.string(),
    scanStartedAt: _zod.z.string(),
    encryptedApplications: _zod.z.boolean(),
    storageType: _zod.z.string().nullable().default(null),
    networkInterfaces: _zod.z.array(_zod.z.object({
      gatewayMacAddress: _zod.z.string().nullable().default(null),
      inet6: _zod.z.array(_zod.z.string()),
      name: _zod.z.string(),
      inet: _zod.z.array(_zod.z.string()),
      physical: _zod.z.string(),
      gatewayIp: _zod.z.string().nullable().default(null),
      id: _zod.z.string()
    }).passthrough()),
    fullDiskScanLastUpdatedAt: _zod.z.string(),
    appsVulnerabilityStatus: _zod.z.string()
  }).passthrough())
}).passthrough();
const SentinelOneIsolateHostResponseSchema = exports.SentinelOneIsolateHostResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.string()).nullable().default(null),
  data: _zod.z.object({
    affected: _zod.z.coerce.number()
  }).passthrough()
}).strict();
const SentinelOneGetRemoteScriptsParamsSchema = exports.SentinelOneGetRemoteScriptsParamsSchema = _zod.z.object({
  query: _zod.z.string().nullable().default(null),
  // Possible values (multiples comma delimiter): `linux` or `macos` or `windows`
  osTypes: _zod.z.string().nullable().default(null),
  // possible values (multiples comma delimiter): `action` or `artifactCollection` or `dataCollection`
  scriptType: _zod.z.string().nullable().default(null),
  // Cursor position returned by the last request. Use to iterate over more than 1000 items. Example: "YWdlbnRfaWQ6NTgwMjkzODE=".
  cursor: _zod.z.string().nullable().default(null),
  // List of group IDs to filter by. Example: "225494730938493804,225494730938493915".
  groupIds: _zod.z.string().nullable().default(null),
  // A list of script IDs. Example: "225494730938493804,225494730938493915".
  ids: _zod.z.string().nullable().default(null),
  // Is the script runnable in Advanced Response Scripts
  isAvailableForArs: _zod.z.boolean().nullable().default(null),
  // Limit number of returned items (1-1000). Example: "10".
  limit: _zod.z.coerce.number().max(1000).min(1).default(10).nullable().default(null),
  // List of Site IDs to filter by. Example: "225494730938493804,225494730938493915".
  siteIds: _zod.z.string().nullable().default(null),
  // Skip first number of items (0-1000). To iterate over more than 1000 items, use "cursor". Example: "150".
  skip: _zod.z.coerce.number().nullable().default(null),
  // If true, total number of items will not be calculated, which speeds up execution time.
  skipCount: _zod.z.boolean().nullable().default(null),
  // The column to sort the results by. Example: "id".
  sortBy: _zod.z.string().nullable().default(null),
  // Sort direction. Example: "asc" or "desc"
  sortOrder: _zod.z.string().nullable().default(null)
}).strict();
const SentinelOneFetchAgentFilesParamsSchema = exports.SentinelOneFetchAgentFilesParamsSchema = _zod.z.object({
  agentId: _zod.z.string().min(1),
  zipPassCode: _zod.z.string().min(10),
  files: _zod.z.array(_zod.z.string().min(1))
}).strict();
const SentinelOneFetchAgentFilesResponseSchema = exports.SentinelOneFetchAgentFilesResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.string()).nullable().default(null),
  data: _zod.z.object({
    success: _zod.z.boolean()
  }).passthrough().optional()
}).passthrough();
const SentinelOneDownloadAgentFileParamsSchema = exports.SentinelOneDownloadAgentFileParamsSchema = _zod.z.object({
  agentId: _zod.z.string().min(1),
  activityId: _zod.z.string().min(1)
}).strict();
const SentinelOneDownloadAgentFileResponseSchema = exports.SentinelOneDownloadAgentFileResponseSchema = _zod.z.any();
const SentinelOneGetActivitiesParamsSchema = exports.SentinelOneGetActivitiesParamsSchema = _zod.z.object({
  accountIds: _zod.z.string().min(1).optional(),
  activityTypes: _zod.z.string().optional(),
  activityUuids: _zod.z.string().min(1).optional(),
  agentIds: _zod.z.string().min(1).optional(),
  alertIds: _zod.z.string().min(1).optional(),
  countOnly: _zod.z.boolean().optional(),
  createdAt__between: _zod.z.string().min(1).optional(),
  createdAt__gt: _zod.z.string().min(1).optional(),
  createdAt__gte: _zod.z.string().min(1).optional(),
  createdAt__lt: _zod.z.string().min(1).optional(),
  createdAt__lte: _zod.z.string().min(1).optional(),
  cursor: _zod.z.string().min(1).optional(),
  groupIds: _zod.z.string().min(1).optional(),
  ids: _zod.z.string().min(1).optional(),
  includeHidden: _zod.z.boolean().optional(),
  limit: _zod.z.coerce.number().optional(),
  ruleIds: _zod.z.string().min(1).optional(),
  siteIds: _zod.z.string().min(1).optional(),
  skip: _zod.z.coerce.number().optional(),
  skipCount: _zod.z.boolean().optional(),
  sortBy: _zod.z.string().min(1).optional(),
  sortOrder: _zod.z.string().min(1).optional(),
  threatIds: _zod.z.string().min(1).optional(),
  userEmails: _zod.z.string().min(1).optional(),
  userIds: _zod.z.string().min(1).optional()
}).strict().optional();
const SentinelOneGetActivitiesResponseDataSchema = exports.SentinelOneGetActivitiesResponseDataSchema = _zod.z.object({
  accountId: _zod.z.string(),
  accountName: _zod.z.string(),
  activityType: _zod.z.coerce.number(),
  activityUuid: _zod.z.string(),
  agentId: _zod.z.string().nullable().default(null),
  agentUpdatedVersion: _zod.z.string().nullable().default(null),
  comments: _zod.z.string().nullable().default(null),
  createdAt: _zod.z.string(),
  data: _zod.z.object({
    // Empty by design.
    // The SentinelOne Activity Log can place any (unknown) data here
  }).passthrough(),
  description: _zod.z.string().nullable().default(null),
  groupId: _zod.z.string().nullable().default(null),
  groupName: _zod.z.string().nullable().default(null),
  hash: _zod.z.string().nullable().default(null),
  id: _zod.z.string(),
  osFamily: _zod.z.string().nullable().default(null),
  primaryDescription: _zod.z.string().nullable().default(null),
  secondaryDescription: _zod.z.string().nullable().default(null),
  siteId: _zod.z.string(),
  siteName: _zod.z.string(),
  threatId: _zod.z.string().nullable().default(null),
  updatedAt: _zod.z.string(),
  userId: _zod.z.string().nullable().default(null)
}).passthrough();
const SentinelOneGetActivitiesResponseNoDataSchema = exports.SentinelOneGetActivitiesResponseNoDataSchema = SentinelOneGetActivitiesResponseDataSchema.omit({
  data: true
});
const SentinelOneGetActivitiesResponseSchema = exports.SentinelOneGetActivitiesResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.string()).optional(),
  pagination: _zod.z.object({
    nextCursor: _zod.z.string().nullable().default(null),
    totalItems: _zod.z.coerce.number()
  }).strict(),
  data: _zod.z.array(SentinelOneGetActivitiesResponseDataSchema)
}).passthrough();
const AlertIds = exports.AlertIds = _zod.z.array(_zod.z.string()).optional();
const SentinelOneGetRemoteScriptsResponseSchema = exports.SentinelOneGetRemoteScriptsResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.string()).nullable().default(null),
  pagination: _zod.z.object({
    nextCursor: _zod.z.string().nullable().default(null),
    totalItems: _zod.z.coerce.number()
  }).strict(),
  data: _zod.z.array(_zod.z.object({
    id: _zod.z.string(),
    updater: _zod.z.string().nullable().default(null),
    isAvailableForLite: _zod.z.boolean(),
    isAvailableForArs: _zod.z.boolean(),
    fileSize: _zod.z.coerce.number(),
    mgmtId: _zod.z.coerce.number(),
    scopeLevel: _zod.z.string(),
    shortFileName: _zod.z.string(),
    scriptName: _zod.z.string(),
    creator: _zod.z.string(),
    package: _zod.z.object({
      id: _zod.z.string(),
      bucketName: _zod.z.string(),
      endpointExpiration: _zod.z.string(),
      fileName: _zod.z.string(),
      endpointExpirationSeconds: _zod.z.coerce.number().nullable().default(null),
      fileSize: _zod.z.coerce.number(),
      signatureType: _zod.z.string(),
      signature: _zod.z.string()
    }).passthrough().nullable().default(null),
    bucketName: _zod.z.string(),
    inputRequired: _zod.z.boolean(),
    fileName: _zod.z.string(),
    supportedDestinations: _zod.z.array(_zod.z.string()).nullable().default(null),
    scopeName: _zod.z.string().nullable().default(null),
    signatureType: _zod.z.string(),
    outputFilePaths: _zod.z.array(_zod.z.string()).nullable().default(null),
    scriptDescription: _zod.z.string().nullable().default(null),
    createdByUserId: _zod.z.string(),
    scopeId: _zod.z.string(),
    updatedAt: _zod.z.string(),
    scriptType: _zod.z.string(),
    scopePath: _zod.z.string(),
    creatorId: _zod.z.string(),
    osTypes: _zod.z.array(_zod.z.string()),
    scriptRuntimeTimeoutSeconds: _zod.z.coerce.number(),
    version: _zod.z.string(),
    updaterId: _zod.z.string().nullable().default(null),
    createdAt: _zod.z.string(),
    inputExample: _zod.z.string().nullable().default(null),
    inputInstructions: _zod.z.string().nullable().default(null),
    signature: _zod.z.string(),
    createdByUser: _zod.z.string(),
    requiresApproval: _zod.z.boolean().optional()
  }).passthrough())
}).passthrough();
const SentinelOneExecuteScriptParamsSchema = exports.SentinelOneExecuteScriptParamsSchema = _zod.z.object({
  // Only a sub-set of filters are defined below. This API, however, support many more filters
  // which can be added in the future if needed.
  filter: _zod.z.object({
    uuids: _zod.z.string().min(1).optional(),
    ids: _zod.z.string().min(1).optional()
  }).strict(),
  script: _zod.z.object({
    apiKey: _zod.z.string().optional(),
    inputParams: _zod.z.string().optional(),
    outputDirectory: _zod.z.string().optional(),
    outputDestination: _zod.z.enum(['Local', 'None', 'SentinelCloud', 'SingularityXDR']).optional(),
    passwordFromScope: _zod.z.object({
      scopeLevel: _zod.z.string().optional(),
      scopeId: _zod.z.string().optional()
    }).strict().optional(),
    password: _zod.z.string().optional(),
    requiresApproval: _zod.z.boolean().optional(),
    scriptId: _zod.z.string(),
    scriptName: _zod.z.string().optional(),
    scriptRuntimeTimeoutSeconds: _zod.z.coerce.number().optional(),
    singularityxdrKeyword: _zod.z.string().optional(),
    singularityxdrUrl: _zod.z.string().optional(),
    taskDescription: _zod.z.string().optional()
  }).strict(),
  alertIds: AlertIds
}).strict();
const SentinelOneExecuteScriptResponseSchema = exports.SentinelOneExecuteScriptResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.object({}).passthrough()).nullable().default(null),
  data: _zod.z.object({
    pendingExecutionId: _zod.z.string().nullable().default(null),
    affected: _zod.z.coerce.number().nullable().default(null),
    parentTaskId: _zod.z.string().nullable().default(null),
    pending: _zod.z.boolean().nullable().default(null)
  }).passthrough().nullable().default(null)
}).passthrough();
const SentinelOneGetRemoteScriptResultsParamsSchema = exports.SentinelOneGetRemoteScriptResultsParamsSchema = _zod.z.object({
  taskIds: _zod.z.array(_zod.z.string())
}).strict();
const SentinelOneGetRemoteScriptResultsResponseSchema = exports.SentinelOneGetRemoteScriptResultsResponseSchema = _zod.z.object({
  errors: _zod.z.array(_zod.z.object({
    type: _zod.z.string()
  }).passthrough()).nullable().default(null),
  data: _zod.z.any()
}).passthrough();
const SentinelOneDownloadRemoteScriptResultsParamsSchema = exports.SentinelOneDownloadRemoteScriptResultsParamsSchema = _zod.z.object({
  taskId: _zod.z.string().min(1)
}).strict();
const SentinelOneDownloadRemoteScriptResultsResponseSchema = exports.SentinelOneDownloadRemoteScriptResultsResponseSchema = _zod.z.any();
const SentinelOneGetRemoteScriptStatusParamsSchema = exports.SentinelOneGetRemoteScriptStatusParamsSchema = _zod.z.object({
  parentTaskId: _zod.z.string()
}).passthrough();
const SentinelOneGetRemoteScriptStatusResponseSchema = exports.SentinelOneGetRemoteScriptStatusResponseSchema = _zod.z.object({
  pagination: _zod.z.object({
    totalItems: _zod.z.coerce.number(),
    nextCursor: _zod.z.string().nullable().default(null)
  }).strict(),
  errors: _zod.z.array(_zod.z.object({
    type: _zod.z.string()
  }).passthrough()).nullable().default(null),
  data: _zod.z.array(_zod.z.map(_zod.z.string(), _zod.z.any()))
}).passthrough();
const SentinelOneBaseFilterSchema = exports.SentinelOneBaseFilterSchema = _zod.z.object({
  K8SNodeName__contains: _zod.z.string().nullable().default(null),
  coreCount__lt: _zod.z.string().nullable().default(null),
  rangerStatuses: _zod.z.string().nullable().default(null),
  adUserQuery__contains: _zod.z.string().nullable().default(null),
  rangerVersionsNin: _zod.z.string().nullable().default(null),
  rangerStatusesNin: _zod.z.string().nullable().default(null),
  coreCount__gte: _zod.z.string().nullable().default(null),
  threatCreatedAt__gte: _zod.z.string().nullable().default(null),
  decommissionedAt__lte: _zod.z.string().nullable().default(null),
  operationalStatesNin: _zod.z.string().nullable().default(null),
  appsVulnerabilityStatusesNin: _zod.z.string().nullable().default(null),
  mitigationMode: _zod.z.string().nullable().default(null),
  createdAt__gte: _zod.z.string().nullable().default(null),
  gatewayIp: _zod.z.string().nullable().default(null),
  cloudImage__contains: _zod.z.string().nullable().default(null),
  registeredAt__between: _zod.z.string().nullable().default(null),
  threatMitigationStatus: _zod.z.string().nullable().default(null),
  installerTypesNin: _zod.z.string().nullable().default(null),
  appsVulnerabilityStatuses: _zod.z.string().nullable().default(null),
  threatResolved: _zod.z.string().nullable().default(null),
  mitigationModeSuspicious: _zod.z.string().nullable().default(null),
  isUpToDate: _zod.z.string().nullable().default(null),
  adComputerQuery__contains: _zod.z.string().nullable().default(null),
  updatedAt__gte: _zod.z.string().nullable().default(null),
  azureResourceGroup__contains: _zod.z.string().nullable().default(null),
  scanStatus: _zod.z.string().nullable().default(null),
  threatContentHash: _zod.z.string().nullable().default(null),
  osTypesNin: _zod.z.string().nullable().default(null),
  threatRebootRequired: _zod.z.string().nullable().default(null),
  totalMemory__between: _zod.z.string().nullable().default(null),
  firewallEnabled: _zod.z.string().nullable().default(null),
  gcpServiceAccount__contains: _zod.z.string().nullable().default(null),
  updatedAt__gt: _zod.z.string().nullable().default(null),
  remoteProfilingStates: _zod.z.string().nullable().default(null),
  filteredGroupIds: _zod.z.string().nullable().default(null),
  agentVersions: _zod.z.string().nullable().default(null),
  activeThreats: _zod.z.string().nullable().default(null),
  machineTypesNin: _zod.z.string().nullable().default(null),
  lastActiveDate__gt: _zod.z.string().nullable().default(null),
  awsSubnetIds__contains: _zod.z.string().nullable().default(null),
  installerTypes: _zod.z.string().nullable().default(null),
  registeredAt__gte: _zod.z.string().nullable().default(null),
  migrationStatus: _zod.z.string().nullable().default(null),
  cloudTags__contains: _zod.z.string().nullable().default(null),
  totalMemory__gte: _zod.z.string().nullable().default(null),
  decommissionedAt__lt: _zod.z.string().nullable().default(null),
  threatCreatedAt__lt: _zod.z.string().nullable().default(null),
  updatedAt__lte: _zod.z.string().nullable().default(null),
  osArch: _zod.z.string().nullable().default(null),
  registeredAt__gt: _zod.z.string().nullable().default(null),
  registeredAt__lt: _zod.z.string().nullable().default(null),
  siteIds: _zod.z.string().nullable().default(null),
  networkInterfaceInet__contains: _zod.z.string().nullable().default(null),
  groupIds: _zod.z.string().nullable().default(null),
  uuids: _zod.z.string().nullable().default(null),
  accountIds: _zod.z.string().nullable().default(null),
  scanStatusesNin: _zod.z.string().nullable().default(null),
  cpuCount__lte: _zod.z.string().nullable().default(null),
  locationIds: _zod.z.string().nullable().default(null),
  awsSecurityGroups__contains: _zod.z.string().nullable().default(null),
  networkStatusesNin: _zod.z.string().nullable().default(null),
  activeThreats__gt: _zod.z.string().nullable().default(null),
  infected: _zod.z.string().nullable().default(null),
  osVersion__contains: _zod.z.string().nullable().default(null),
  machineTypes: _zod.z.string().nullable().default(null),
  agentPodName__contains: _zod.z.string().nullable().default(null),
  computerName__like: _zod.z.string().nullable().default(null),
  threatCreatedAt__gt: _zod.z.string().nullable().default(null),
  consoleMigrationStatusesNin: _zod.z.string().nullable().default(null),
  computerName: _zod.z.string().nullable().default(null),
  decommissionedAt__between: _zod.z.string().nullable().default(null),
  cloudInstanceId__contains: _zod.z.string().nullable().default(null),
  createdAt__lte: _zod.z.string().nullable().default(null),
  coreCount__between: _zod.z.string().nullable().default(null),
  totalMemory__lte: _zod.z.string().nullable().default(null),
  remoteProfilingStatesNin: _zod.z.string().nullable().default(null),
  adComputerMember__contains: _zod.z.string().nullable().default(null),
  threatCreatedAt__between: _zod.z.string().nullable().default(null),
  totalMemory__gt: _zod.z.string().nullable().default(null),
  ids: _zod.z.string().nullable().default(null),
  agentVersionsNin: _zod.z.string().nullable().default(null),
  updatedAt__between: _zod.z.string().nullable().default(null),
  locationEnabled: _zod.z.string().nullable().default(null),
  locationIdsNin: _zod.z.string().nullable().default(null),
  osTypes: _zod.z.string().nullable().default(null),
  encryptedApplications: _zod.z.string().nullable().default(null),
  filterId: _zod.z.string().nullable().default(null),
  decommissionedAt__gt: _zod.z.string().nullable().default(null),
  adUserMember__contains: _zod.z.string().nullable().default(null),
  uuid: _zod.z.string().nullable().default(null),
  coreCount__lte: _zod.z.string().nullable().default(null),
  coreCount__gt: _zod.z.string().nullable().default(null),
  cloudNetwork__contains: _zod.z.string().nullable().default(null),
  clusterName__contains: _zod.z.string().nullable().default(null),
  cpuCount__gte: _zod.z.string().nullable().default(null),
  query: _zod.z.string().nullable().default(null),
  lastActiveDate__between: _zod.z.string().nullable().default(null),
  rangerStatus: _zod.z.string().nullable().default(null),
  domains: _zod.z.string().nullable().default(null),
  cloudProvider: _zod.z.string().nullable().default(null),
  lastActiveDate__lt: _zod.z.string().nullable().default(null),
  scanStatuses: _zod.z.string().nullable().default(null),
  hasLocalConfiguration: _zod.z.string().nullable().default(null),
  networkStatuses: _zod.z.string().nullable().default(null),
  isPendingUninstall: _zod.z.string().nullable().default(null),
  createdAt__gt: _zod.z.string().nullable().default(null),
  cpuCount__lt: _zod.z.string().nullable().default(null),
  consoleMigrationStatuses: _zod.z.string().nullable().default(null),
  adQuery: _zod.z.string().nullable().default(null),
  updatedAt__lt: _zod.z.string().nullable().default(null),
  createdAt__lt: _zod.z.string().nullable().default(null),
  adComputerName__contains: _zod.z.string().nullable().default(null),
  cloudInstanceSize__contains: _zod.z.string().nullable().default(null),
  registeredAt__lte: _zod.z.string().nullable().default(null),
  networkQuarantineEnabled: _zod.z.string().nullable().default(null),
  cloudAccount__contains: _zod.z.string().nullable().default(null),
  cloudLocation__contains: _zod.z.string().nullable().default(null),
  rangerVersions: _zod.z.string().nullable().default(null),
  networkInterfaceGatewayMacAddress__contains: _zod.z.string().nullable().default(null),
  uuid__contains: _zod.z.string().nullable().default(null),
  agentNamespace__contains: _zod.z.string().nullable().default(null),
  K8SNodeLabels__contains: _zod.z.string().nullable().default(null),
  adQuery__contains: _zod.z.string().nullable().default(null),
  K8SType__contains: _zod.z.string().nullable().default(null),
  countsFor: _zod.z.string().nullable().default(null),
  totalMemory__lt: _zod.z.string().nullable().default(null),
  externalId__contains: _zod.z.string().nullable().default(null),
  filteredSiteIds: _zod.z.string().nullable().default(null),
  decommissionedAt__gte: _zod.z.string().nullable().default(null),
  cpuCount__gt: _zod.z.string().nullable().default(null),
  threatHidden: _zod.z.string().nullable().default(null),
  isUninstalled: _zod.z.string().nullable().default(null),
  computerName__contains: _zod.z.string().nullable().default(null),
  lastActiveDate__lte: _zod.z.string().nullable().default(null),
  adUserName__contains: _zod.z.string().nullable().default(null),
  isActive: _zod.z.string().nullable().default(null),
  userActionsNeeded: _zod.z.string().nullable().default(null),
  threatCreatedAt__lte: _zod.z.string().nullable().default(null),
  domainsNin: _zod.z.string().nullable().default(null),
  operationalStates: _zod.z.string().nullable().default(null),
  externalIp__contains: _zod.z.string().nullable().default(null),
  isDecommissioned: _zod.z.string().nullable().default(null),
  networkInterfacePhysical__contains: _zod.z.string().nullable().default(null),
  lastActiveDate__gte: _zod.z.string().nullable().default(null),
  createdAt__between: _zod.z.string().nullable().default(null),
  cpuCount__between: _zod.z.string().nullable().default(null),
  lastLoggedInUserName__contains: _zod.z.string().nullable().default(null),
  awsRole__contains: _zod.z.string().nullable().default(null),
  K8SVersion__contains: _zod.z.string().nullable().default(null),
  alertIds: AlertIds
}).strict();
const SentinelOneIsolateHostParamsSchema = exports.SentinelOneIsolateHostParamsSchema = SentinelOneBaseFilterSchema;
const SentinelOneGetAgentsParamsSchema = exports.SentinelOneGetAgentsParamsSchema = SentinelOneBaseFilterSchema;
const SentinelOneIsolateHostSchema = exports.SentinelOneIsolateHostSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.ISOLATE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
}).strict();
const SentinelOneReleaseHostSchema = exports.SentinelOneReleaseHostSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.RELEASE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
}).strict();
const SentinelOneExecuteScriptSchema = exports.SentinelOneExecuteScriptSchema = _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.EXECUTE_SCRIPT),
  subActionParams: SentinelOneExecuteScriptParamsSchema
}).strict();
const SentinelOneActionParamsSchema = exports.SentinelOneActionParamsSchema = _zod.z.union([SentinelOneIsolateHostSchema, SentinelOneReleaseHostSchema, SentinelOneExecuteScriptSchema]);