"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidChannelIdSubActionParamsSchema = exports.ValidChannelIdParamsSchema = exports.SlackApiSecretsSchema = exports.SlackApiParamsSchema = exports.SlackApiConfigSchema = exports.PostMessageSubActionParamsSchema = exports.PostMessageParamsSchema = exports.PostBlockkitSubActionParamsSchema = exports.PostBlockkitParamsSchema = exports.MAX_ALLOWED_CHANNELS = void 0;
exports.validateBlockkit = validateBlockkit;
exports.validateChannelName = validateChannelName;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_ALLOWED_CHANNELS = exports.MAX_ALLOWED_CHANNELS = 500;
const SlackApiSecretsSchema = exports.SlackApiSecretsSchema = _zod.z.object({
  token: _zod.z.string().min(1)
}).strict();
const SlackApiConfigSchema = exports.SlackApiConfigSchema = _zod.z.object({
  allowedChannels: _zod.z.array(_zod.z.object({
    id: _zod.z.string().min(1).optional(),
    name: _zod.z.string().min(1)
  }).strict()).max(MAX_ALLOWED_CHANNELS).optional()
}).strict();
const ValidChannelIdSubActionParamsSchema = exports.ValidChannelIdSubActionParamsSchema = _zod.z.object({
  channelId: _zod.z.string().optional()
}).strict();
const ValidChannelIdParamsSchema = exports.ValidChannelIdParamsSchema = _zod.z.object({
  subAction: _zod.z.literal('validChannelId'),
  subActionParams: ValidChannelIdSubActionParamsSchema
}).strict();
const PostMessageSubActionParamsSchema = exports.PostMessageSubActionParamsSchema = _zod.z.object({
  /**
   * @deprecated Use `channelNames` or `channelIds` instead
   * `channelNames` takes priority over `channelIds` and `channels`
   */
  channels: _zod.z.array(_zod.z.string()).max(1).optional(),
  channelIds: _zod.z.array(_zod.z.string()).max(1).optional(),
  channelNames: _zod.z
  // min of two characters to account for '#' prefix
  .array(_zod.z.string().min(2).max(200).superRefine(validateChannelName)).max(1).optional(),
  text: _zod.z.string().min(1)
}).strict();
function validateBlockkit(text, ctx) {
  try {
    const parsedText = JSON.parse(text);
    if (!Object.hasOwn(parsedText, 'blocks')) {
      ctx.addIssue({
        code: _zod.z.ZodIssueCode.custom,
        message: 'block kit body must contain field "blocks"'
      });
    }
  } catch (err) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: `block kit body is not valid JSON - ${err.message}`
    });
  }
}
function validateChannelName(value, ctx) {
  if (!value || value.length === 0) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Channel name cannot be empty'
    });
    return;
  }
  if (!value.startsWith('#')) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Channel name must start with #'
    });
  }
}
const PostBlockkitSubActionParamsSchema = exports.PostBlockkitSubActionParamsSchema = _zod.z.object({
  /**
   * @deprecated Use `channelNames` or `channelIds` instead
   * `channelNames` takes priority over `channelIds` and `channels`
   */
  channels: _zod.z.array(_zod.z.string()).max(1).optional(),
  channelIds: _zod.z.array(_zod.z.string()).max(1).optional(),
  channelNames: _zod.z.array(_zod.z.string().superRefine(validateChannelName)).max(1).optional(),
  text: _zod.z.string().superRefine(validateBlockkit)
}).strict();
const PostMessageParamsSchema = exports.PostMessageParamsSchema = _zod.z.object({
  subAction: _zod.z.literal('postMessage'),
  subActionParams: PostMessageSubActionParamsSchema
}).strict();
const PostBlockkitParamsSchema = exports.PostBlockkitParamsSchema = _zod.z.object({
  subAction: _zod.z.literal('postBlockkit'),
  subActionParams: PostBlockkitSubActionParamsSchema
}).strict();
const SlackApiParamsSchema = exports.SlackApiParamsSchema = _zod.z.union([ValidChannelIdParamsSchema, PostMessageParamsSchema, PostBlockkitParamsSchema]);