"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretsSchema = exports.ParamsSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchemaProps = {
  configUrl: _zod.z.string().nullable().default(null),
  usesBasic: _zod.z.boolean().default(true)
};
const ConfigSchema = exports.ConfigSchema = _zod.z.object(configSchemaProps).strict();
const secretSchemaProps = {
  user: _zod.z.string().nullable().default(null),
  password: _zod.z.string().nullable().default(null),
  secretsUrl: _zod.z.string().nullable().default(null)
};
const SecretsSchema = exports.SecretsSchema = _zod.z.object(secretSchemaProps).strict();
const ParamsSchema = exports.ParamsSchema = _zod.z.object({
  alertActionGroupName: _zod.z.string().optional(),
  signalId: _zod.z.string().optional(),
  ruleName: _zod.z.string().optional(),
  date: _zod.z.string().optional(),
  severity: _zod.z.string(),
  spaceId: _zod.z.string().optional(),
  tags: _zod.z.string().optional()
}).strict();