"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XSOARRunActionResponseSchema = exports.XSOARRunActionParamsSchema = exports.XSOARPlaybooksObjectSchema = exports.XSOARPlaybooksActionResponseSchema = exports.XSOARPlaybooksActionParamsSchema = exports.SecretsSchema = exports.ExecutorParamsSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConfigSchema = exports.ConfigSchema = _zod.z.object({
  url: _zod.z.string()
}).strict();
const SecretsSchema = exports.SecretsSchema = _zod.z.object({
  apiKey: _zod.z.string(),
  apiKeyID: _zod.z.string().nullable().default(null)
}).strict();
const XSOARPlaybooksActionParamsSchema = exports.XSOARPlaybooksActionParamsSchema = null;
const XSOARPlaybooksObjectSchema = exports.XSOARPlaybooksObjectSchema = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string()
});
const XSOARPlaybooksActionResponseSchema = exports.XSOARPlaybooksActionResponseSchema = _zod.z.object({
  playbooks: _zod.z.array(XSOARPlaybooksObjectSchema)
});
const XSOARRunActionParamsSchema = exports.XSOARRunActionParamsSchema = _zod.z.object({
  name: _zod.z.string(),
  playbookId: _zod.z.string().nullable().default(null),
  createInvestigation: _zod.z.boolean(),
  severity: _zod.z.coerce.number(),
  isRuleSeverity: _zod.z.boolean().default(false).nullable(),
  body: _zod.z.string().nullable().default(null)
}).strict();
const XSOARRunActionResponseSchema = exports.XSOARRunActionResponseSchema = _zod.z.object({});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _zod.z.union([_zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.PLAYBOOKS),
  subActionParams: _zod.z.literal(null) // this subaction not required any value as params
}).strict(), _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.RUN),
  subActionParams: XSOARRunActionParamsSchema
}).strict()]);