"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyHeaderAuth = void 0;
var _v = require("@kbn/zod/v4");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HEADER_FIELD_DEFAULT = 'Api-Key';
const authSchema = _v.z.object({
  headerField: _v.z.string().min(1, {
    message: i18n.HEADER_AUTH_REQUIRED_MESSAGE
  }).default(HEADER_FIELD_DEFAULT).meta({
    label: i18n.HEADER_AUTH_LABEL,
    sensitive: true
  }),
  apiKey: _v.z.string().min(1, {
    message: i18n.API_KEY_AUTH_REQUIRED_MESSAGE
  }).meta({
    label: i18n.API_KEY_AUTH_LABEL,
    sensitive: true
  })
}).meta({
  label: i18n.API_KEY_HEADER_AUTHENTICATION_LABEL
});
/**
 * Header-based authentication (generic)
 * Use for: API keys, custom headers (X-API-Key, etc.)
 */
const ApiKeyHeaderAuth = exports.ApiKeyHeaderAuth = {
  id: 'api_key_header',
  schema: authSchema,
  normalizeSchema: defaults => {
    var _authSchema$meta;
    const existingMeta = (_authSchema$meta = authSchema.meta()) !== null && _authSchema$meta !== void 0 ? _authSchema$meta : {};
    const schemaToUse = _v.z.object({
      ...authSchema.shape
    });
    if (defaults) {
      // get the default values for the headerField
      const headerField = defaults.headerField && (0, _lodash.isString)(defaults.headerField) ? defaults.headerField : HEADER_FIELD_DEFAULT;
      return _v.z.object({
        [headerField]: schemaToUse.shape.apiKey
      });
    }
    return schemaToUse.meta(existingMeta);
  },
  configure: async (_, axiosInstance, secret) => {
    // set global defaults
    Object.keys(secret).filter(key => key !== 'authType').forEach(key => {
      axiosInstance.defaults.headers.common[key] = secret[key];
    });
    return axiosInstance;
  }
};