"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CRT = void 0;
var _v = require("@kbn/zod/v4");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _lib = require("../lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const authSchema = _v.z.object({
  crt: _v.z.string().meta({
    label: i18n.CRT_AUTH_CERT_LABEL
  }),
  key: _v.z.string().meta({
    label: i18n.CRT_AUTH_KEY_LABEL,
    sensitive: true
  }),
  passphrase: _v.z.string().meta({
    label: i18n.CRT_AUTH_PASSPHRASE_LABEL,
    sensitive: true
  }).optional(),
  ca: _v.z.string().meta({
    label: i18n.CRT_AUTH_CA_LABEL
  }).optional(),
  verificationMode: _v.z.enum(['none', 'certificate', 'full']).meta({
    label: i18n.CRT_AUTH_VERIFICATION_MODE_LABEL
  }).optional()
}).meta({
  label: i18n.CRT_AUTH_LABEL
});
/**
 * Authenticate with CRT certificate and key
 */
const CRT = exports.CRT = {
  id: 'crt_certificate',
  schema: authSchema,
  configure: async (ctx, axiosInstance, secret) => {
    const sslOverrides = {
      cert: Buffer.from(secret.crt, 'base64'),
      key: Buffer.from(secret.key, 'base64'),
      ...((0, _lodash.isString)(secret.passphrase) ? {
        passphrase: secret.passphrase
      } : {}),
      ...((0, _lodash.isString)(secret.verificationMode) ? {
        verificationMode: secret.verificationMode
      } : {}),
      ...((0, _lodash.isString)(secret.ca) ? {
        ca: Buffer.from(secret.ca, 'base64')
      } : {})
    };
    return (0, _lib.configureAxiosInstanceWithSsl)(ctx, axiosInstance, sslOverrides);
  }
};