"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageKeys = exports.Storage = void 0;
exports.createStorage = createStorage;
exports.setStorage = exports.getStorage = void 0;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let StorageKeys = exports.StorageKeys = /*#__PURE__*/function (StorageKeys) {
  StorageKeys["SIZE"] = "panelSize";
  StorageKeys["FOLDS"] = "folds";
  StorageKeys["VARIABLES"] = "variables";
  StorageKeys["DEFAULT_LANGUAGE"] = "defaultLanguage";
  return StorageKeys;
}({});
class Storage {
  constructor(engine, prefix) {
    this.engine = engine;
    this.prefix = prefix;
  }
  encode(val) {
    return JSON.stringify(val);
  }
  decode(val) {
    if (typeof val === 'string') {
      return JSON.parse(val);
    }
  }
  encodeKey(key) {
    return `${this.prefix}${key}`;
  }
  decodeKey(key) {
    if ((0, _lodash.startsWith)(key, this.prefix)) {
      return `${key.slice(this.prefix.length)}`;
    }
  }
  set(key, val) {
    this.engine.setItem(this.encodeKey(key), this.encode(val));
    return val;
  }
  has(key) {
    return this.engine.getItem(this.encodeKey(key)) != null;
  }
  get(key, _default) {
    if (this.has(key)) {
      return this.decode(this.engine.getItem(this.encodeKey(key)));
    } else {
      return _default;
    }
  }
  delete(key) {
    return this.engine.removeItem(this.encodeKey(key));
  }
  keys() {
    return (0, _lodash.transform)((0, _lodash.keys)(this.engine), (ours, key) => {
      const ourKey = this.decodeKey(key);
      if (ourKey != null) ours.push(ourKey);
    });
  }
}
exports.Storage = Storage;
function createStorage(deps) {
  return new Storage(deps.engine, deps.prefix);
}
const [getStorage, setStorage] = (0, _public.createGetterSetter)('storage');
exports.setStorage = setStorage;
exports.getStorage = getStorage;