"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDetailOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
var _routes = require("../routes");
var _sync_jobs = require("../search_index/sync_jobs/sync_jobs");
var _connector_detail = require("./connector_detail");
var _connector_stats = require("./connector_stats");
var _connector_view_logic = require("./connector_view_logic");
var _encode_path_params = require("../shared/encode_path_params");
var _index_view_logic = require("../search_index/index_view_logic");
var _react_router_helpers = require("../shared/react_router_helpers");
var _convert_connector_logic = require("../search_index/connector/native_connector_configuration/convert_connector_logic");
var _convert_connector_modal = require("../shared/convert_connector_modal/convert_connector_modal");
var _doc_links = require("../shared/doc_links");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectorDetailOverview = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const isCloud = (0, _app_context.useAppContext)();
  const {
    indexData
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    connector,
    error,
    isWaitingOnAgentlessDeployment,
    connectorAgentlessPolicy
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    showModal
  } = (0, _kea.useActions)((0, _convert_connector_logic.ConvertConnectorLogic)({
    http
  }));
  const {
    isModalVisible
  } = (0, _kea.useValues)((0, _convert_connector_logic.ConvertConnectorLogic)({
    http
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isWaitingOnAgentlessDeployment && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "warning",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.agentlessDeploymentNotReadyCallOut.title', {
      defaultMessage: 'Provisioning infrastructure'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.agentlessDeploymentNotReadyCallOut.description', {
    defaultMessage: 'Setting up the agentless infrastructure to run the connector.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  })), error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "warning",
    color: "danger",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.connectorErrorCallOut.title', {
      defaultMessage: 'Your connector has reported an error'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  })), !!connector && !connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    color: "warning",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.connectorNoIndexCallOut.title', {
      defaultMessage: 'Connector has no attached index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.connectorNoIndexCallOut.description', {
    defaultMessage: "You won't be able to start syncing content until your connector is attached to an index."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    color: "warning",
    fill: true,
    to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId: connector.id,
      tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
    })}#attachIndexBox`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.connectorNoIndexCallOut.buttonLabel', {
    defaultMessage: 'Attach index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  })), !!(connector !== null && connector !== void 0 && connector.index_name) && !indexData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.overview.connectorIndexDoesntExistCallOut.title', {
      defaultMessage: "Attached index doesn't exist"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors.content.connectors.overview.connectorIndexDoesntExistCallOut.description",
    defaultMessage: "The connector will create the index on its next sync, or you can manually create the index {indexName} with your desired settings and mappings.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 30
        }
      }, connector.index_name)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })), (connector === null || connector === void 0 ? void 0 : connector.is_native) && !isCloud && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_convert_connector_modal.ConvertConnectorModal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 30
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.title', {
      defaultMessage: 'Elastic managed connectors (formerly native connectors) are no longer supported outside Elastic Cloud'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.content",
    defaultMessage: "Convert it to a {link}, to be self-hosted on your own infrastructure. Elastic managed connectors are available only in your Elastic Cloud deployment.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-connectorDetailOverview-nativeCloudCallout-connectorClientLink",
        "data-telemetry-id": "entSearchContent-connectorDetailOverview-nativeCloudCallout-connectorClientLink",
        href: _doc_links.docLinks.buildConnector,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.connectorClient', {
        defaultMessage: 'self-managed connector'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connectorDetailOverview-nativeCloudCallout-convertToSelfManagedClientButton",
    color: "warning",
    fill: true,
    onClick: () => showModal(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectors.overview.convertConnector.buttonLabel', {
    defaultMessage: 'Convert connector'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  })), connector && connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE && /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    connector: connector,
    indexData: indexData || undefined,
    agentlessOverview: connectorAgentlessPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }), connector && connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sync_jobs.SyncJobs, {
    connector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })));
};
exports.ConnectorDetailOverview = ConnectorDetailOverview;