"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _searchConnectors = require("@kbn/search-connectors");
var _update_connector_configuration_api_logic = require("../../../api/connector/update_connector_configuration_api_logic");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _new_connector_logic = require("../../new_index/method_connector/new_connector_logic");
var _api = require("../../../../common/types/api");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/configuration_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfigurationStep = ({
  title,
  setCurrentStep,
  connectorId
}) => {
  const {
    overlays,
    http,
    application
  } = (0, _public.useKibana)().services;
  const {
    connector,
    isWaitingOnAgentlessDeployment
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    updateConnectorConfiguration
  } = (0, _kea.useActions)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    setFormDirty
  } = (0, _kea.useActions)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const [isFormEditing, setIsFormEditing] = (0, _react.useState)(false);
  const {
    status
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const isSyncing = false;
  const isConnectorConfigured = (connector === null || connector === void 0 ? void 0 : connector.status) === _searchConnectors.ConnectorStatus.CONNECTED || (connector === null || connector === void 0 ? void 0 : connector.status) === _searchConnectors.ConnectorStatus.CONFIGURED;
  const isNextStepEnabled = !isWaitingOnAgentlessDeployment && isConnectorConfigured;
  const {
    fetchConnectorApiReset,
    startConnectorPoll,
    stopConnectorPoll
  } = (0, _kea.useActions)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  (0, _react.useEffect)(() => {
    stopConnectorPoll();
    fetchConnectorApiReset();
    startConnectorPoll(connectorId);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectorId]);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      window.scrollTo({
        behavior: 'smooth',
        top: 0
      });
    }, 100);
  }, []);
  if (!connector) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, isWaitingOnAgentlessDeployment && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.agentlessDeploymentNotReadyCallOut.title', {
      defaultMessage: 'Provisioning infrastructure'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.agentlessDeploymentNotReadyCallOut.description', {
    defaultMessage: 'Setting up the agentless infrastructure to run the connector. This process may take up to one minute.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    css: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
    connector: connector,
    hasPlatinumLicense: true,
    isLoading: status === _api.Status.LOADING,
    saveConfig: config => {
      updateConnectorConfiguration({
        configuration: config,
        connectorId: connector.id,
        http
      });
    },
    onEditStateChange: setIsFormEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }), isSyncing && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    position: "absolute",
    css: {
      top: 'calc(100% - 2px)'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.h4.finishUpLabel', {
    defaultMessage: 'Finish up'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isNextStepEnabled ? 'default' : 'subdued',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.p.description', {
    defaultMessage: 'You can manually sync your data, schedule a recurring sync or manage your domains.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !isNextStepEnabled,
    "data-test-subj": "enterpriseSearchStartStepGenerateConfigurationButton",
    onClick: async () => {
      if (isFormEditing) {
        const confirmResponse = await (overlays === null || overlays === void 0 ? void 0 : overlays.openConfirm(_i18n.i18n.translate('xpack.contentConnectors.configureConnector.unsavedPrompt.body', {
          defaultMessage: 'You are still editing connector configuration, are you sure you want to continue without saving? You can complete the setup later in the connector configuration page, but this guided flow offers more help.'
        }), {
          title: _i18n.i18n.translate('xpack.contentConnectors.configureConnector.unsavedPrompt.title', {
            defaultMessage: 'Connector configuration is not saved'
          }),
          cancelButtonText: _i18n.i18n.translate('xpack.contentConnectors.configureConnector.unsavedPrompt.cancel', {
            defaultMessage: 'Continue setup'
          }),
          confirmButtonText: _i18n.i18n.translate('xpack.contentConnectors.configureConnector.unsavedPrompt.confirm', {
            defaultMessage: 'Leave the page'
          })
        }));
        if (!confirmResponse) {
          return;
        }
      }
      setFormDirty(false);
      setCurrentStep('finish');
    },
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, _translations.NEXT_BUTTON_LABEL)))));
};
exports.ConfigurationStep = ConfigurationStep;