"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchConnectorsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _doc_links = require("@kbn/search-connectors/constants/doc_links");
var _connector_types = require("../common/lib/connector_types");
var _constants = require("../common/constants");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchConnectorsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.config = initializerContext.config.get();
  }
  setup(core, dependencies) {
    const {
      management
    } = dependencies;
    const connectorTypes = (0, _connector_types.getConnectorTypes)(core.http.staticAssets);
    const kibanaVersion = this.kibanaVersion;
    core.getStartServices().then(([coreStart, pluginsStartDeps, pluginStart]) => {
      const hasAnyContentConnectorsSolutions = pluginsStartDeps.home.featureCatalogue.getSolutions().some(({
        id
      }) => ['securitySolution', 'observability'].includes(id));
      if (this.config.ui.enabled && hasAnyContentConnectorsSolutions) {
        management.sections.section.data.registerApp({
          id: _constants.PLUGIN_ID,
          title: _translations.PLUGIN_NAME,
          order: 8,
          keywords: ['content connectors', 'search'],
          async mount(params) {
            const {
              renderApp
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app')));
            const connectorsDefinitions = (0, _connector_types.getConnectorFullTypes)(core.http.staticAssets);
            return renderApp(coreStart, pluginsStartDeps, pluginStart, params, connectorsDefinitions, kibanaVersion);
          }
        });
      }
    });
    return {
      getConnectorTypes: () => connectorTypes
    };
  }
  start(core, services) {
    const {
      http
    } = core;
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    const connectorTypes = (0, _connector_types.getConnectorFullTypes)(http.staticAssets);
    return {
      getConnectorTypes: () => connectorTypes
    };
  }
  stop() {}
}
exports.SearchConnectorsPlugin = SearchConnectorsPlugin;