"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListControl = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _is_compressed = require("../../../../control_group/utils/is_compressed");
var _constants = require("../../../constants");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_popover = require("./options_list_popover");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const optionListControlStyles = {
  selectionWrapper: (0, _react2.css)({
    overflow: 'hidden !important'
  }),
  excludeSelected: ({
    euiTheme
  }) => (0, _react2.css)({
    fontSize: euiTheme.size.m,
    fontWeight: euiTheme.font.weight.bold,
    color: euiTheme.colors.danger
  }),
  validOption: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.text,
    fontWeight: euiTheme.font.weight.medium
  }),
  invalidOption: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.warningText,
    fontWeight: euiTheme.font.weight.medium
  }),
  optionsListExistsFilter: ({
    euiTheme
  }) => (0, _react2.css)`
    font-style: italic;
    font-weight: ${euiTheme.font.weight.medium};
  `,
  invalidSelectionsToken: (0, _react2.css)({
    verticalAlign: 'text-bottom'
  }),
  // temp. override until alignment is fixed on EUI side
  filterButton: (0, _react2.css)`
    .euiButtonEmpty__content {
      justify-content: flex-end;
    }
  `,
  inputButtonOverride: (0, _react2.css)({
    maxInlineSize: '100% !important',
    borderRadius: 'inherit'
  }),
  filterGroup: (0, _react2.css)`
    padding: 0 !important;
  `
};
const OptionsListControl = ({
  controlPanelClassName,
  disableMultiValueEmptySelection = false
}) => {
  var _componentApi$default, _displaySettings$plac;
  const popoverId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const {
    componentApi,
    displaySettings,
    customStrings
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [excludeSelected, existsSelected, selectedOptions, invalidSelections, field, loading, panelTitle, fieldFormatter, defaultPanelTitle] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.exclude$, componentApi.existsSelected$, componentApi.selectedOptions$, componentApi.invalidSelections$, componentApi.field$, componentApi.dataLoading$, componentApi.title$, componentApi.fieldFormatter, (_componentApi$default = componentApi.defaultTitle$) !== null && _componentApi$default !== void 0 ? _componentApi$default : new _rxjs.BehaviorSubject(undefined));
  const delimiter = (0, _react.useMemo)(() => _options_list_strings.OptionsListStrings.control.getSeparator(field === null || field === void 0 ? void 0 : field.type), [field]);
  const styles = (0, _use_memo_css.useMemoCss)(optionListControlStyles);
  const {
    hasSelections,
    selectionDisplayNode,
    selectedOptionsCount
  } = (0, _react.useMemo)(() => {
    var _customStrings$invali, _customStrings$invali2;
    return {
      hasSelections: !(0, _lodash.isEmpty)(selectedOptions),
      selectedOptionsCount: selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length,
      selectionDisplayNode: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false,
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: styles.selectionWrapper,
        "data-test-subj": "optionsListSelections",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      }, excludeSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        css: styles.excludeSelected,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      }, existsSelected ? _options_list_strings.OptionsListStrings.control.getExcludeExists() : _options_list_strings.OptionsListStrings.control.getNegate()), ' '), existsSelected ? /*#__PURE__*/_react.default.createElement("span", {
        css: styles.optionsListExistsFilter,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 17
        }
      }, _options_list_strings.OptionsListStrings.controlAndPopover.getExists(+Boolean(excludeSelected))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedOptions !== null && selectedOptions !== void 0 && selectedOptions.length ? selectedOptions.map((value, i, {
        length
      }) => {
        const text = `${fieldFormatter(value)}${i + 1 === length ? '' : delimiter}`;
        const isInvalid = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.has(value);
        return /*#__PURE__*/_react.default.createElement("span", {
          key: value,
          css: isInvalid ? styles.invalidOption : styles.validOption,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 27
          }
        }, text);
      }) : null))), invalidSelections && invalidSelections.size > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: (_customStrings$invali = customStrings === null || customStrings === void 0 ? void 0 : customStrings.invalidSelectionsLabel) !== null && _customStrings$invali !== void 0 ? _customStrings$invali : _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.size),
        delay: "long",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        tabIndex: 0,
        iconType: "alert",
        size: "s",
        color: "euiColorVis9",
        shape: "square",
        fill: "dark",
        title: (_customStrings$invali2 = customStrings === null || customStrings === void 0 ? void 0 : customStrings.invalidSelectionsLabel) !== null && _customStrings$invali2 !== void 0 ? _customStrings$invali2 : _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.size),
        "data-test-subj": `optionsList__invalidSelectionsToken-${componentApi.uuid}`,
        css: styles.invalidSelectionsToken // Align with the notification badge
        ,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 17
        }
      }))))
    };
  }, [selectedOptions, excludeSelected, existsSelected, fieldFormatter, delimiter, invalidSelections, componentApi.uuid, styles, customStrings]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlButton, {
    role: "combobox",
    compressed: (0, _is_compressed.isCompressed)(componentApi),
    iconType: loading ? 'empty' : 'arrowDown',
    iconSide: "right",
    value: hasSelections || existsSelected ? selectionDisplayNode : '',
    placeholder: (_displaySettings$plac = displaySettings.placeholder) !== null && _displaySettings$plac !== void 0 ? _displaySettings$plac : _options_list_strings.OptionsListStrings.control.getPlaceholder(),
    css: styles.filterButton,
    onClick: () => setPopoverOpen(!isPopoverOpen),
    "aria-label": panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
    "aria-expanded": isPopoverOpen,
    "aria-controls": popoverId,
    "data-test-subj": `optionsList-control-${componentApi.uuid}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 5
    }
  }, Boolean(selectedOptionsCount) && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }, selectedOptionsCount));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true,
    compressed: (0, _is_compressed.isCompressed)(componentApi),
    className: controlPanelClassName,
    css: optionListControlStyles.filterGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    id: popoverId,
    ownFocus: true,
    input: button,
    hasArrow: false,
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    panelMinWidth: _constants.MIN_POPOVER_WIDTH,
    className: "optionsList__inputButtonOverride",
    css: styles.inputButtonOverride,
    initialFocus: '[data-test-subj=optionsList-control-search-input]',
    closePopover: () => setPopoverOpen(false),
    panelClassName: "optionsList__popoverOverride",
    panelProps: {
      title: panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
      'aria-label': _options_list_strings.OptionsListStrings.popover.getAriaLabel(panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover.OptionsListPopover, {
    disableMultiValueEmptySelection: disableMultiValueEmptySelection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  })));
};
exports.OptionsListControl = OptionsListControl;