"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeRangeMeta = getTimeRangeMeta;
exports.getTimezone = getTimezone;
var _kibana_services = require("../../services/kibana_services");
var _time_utils = require("./time_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getTimeRangeMeta(timeRange) {
  const nextBounds = timeRangeToBounds(timeRange !== null && timeRange !== void 0 ? timeRange : getDefaultTimeRange());
  const ticks = (0, _time_utils.getTicks)(nextBounds[_time_utils.FROM_INDEX], nextBounds[_time_utils.TO_INDEX], getTimezone());
  const {
    format,
    stepSize
  } = (0, _time_utils.getStepSize)(ticks);
  return {
    format,
    stepSize,
    ticks,
    timeRange: nextBounds[_time_utils.TO_INDEX] - nextBounds[_time_utils.FROM_INDEX],
    timeRangeBounds: nextBounds,
    timeRangeMax: (0, _time_utils.roundUpToNextStepSizeFactor)(nextBounds[_time_utils.TO_INDEX], stepSize),
    timeRangeMin: (0, _time_utils.roundDownToNextStepSizeFactor)(nextBounds[_time_utils.FROM_INDEX], stepSize)
  };
}
function getTimezone() {
  return _kibana_services.coreServices.uiSettings.get('dateFormat:tz', 'Browser');
}
function getDefaultTimeRange() {
  const defaultTimeRange = _kibana_services.coreServices.uiSettings.get('timepicker:timeDefaults');
  return defaultTimeRange ? defaultTimeRange : {
    from: 'now-15m',
    to: 'now'
  };
}
function timeRangeToBounds(timeRange) {
  const timeRangeBounds = _kibana_services.dataService.query.timefilter.timefilter.calculateBounds(timeRange);
  return timeRangeBounds.min === undefined || timeRangeBounds.max === undefined ? [Date.now() - 1000 * 60 * 15, Date.now()] : [timeRangeBounds.min.valueOf(), timeRangeBounds.max.valueOf()];
}