"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.coreConfig = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const coreConfigSchema = _configSchema.schema.object({
  lifecycle: _configSchema.schema.object({
    disablePreboot: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  /**
   * If the config validation fails, this setting allows retrying it with `stripUnknownKeys: true`, which removes any
   * unknown config keys from the resulting validated config object.
   *
   * This is an escape hatch that should be used only
   * if necessary. The setting is expected to be false in the classic offering and during dev and CI times.
   * However, on Serverless, we'd like to set it to true to avoid bootlooping in case of any temporary misalignment
   * between our kibana-controller and the Kibana versions.
   */
  enableStripUnknownConfigWorkaround: _configSchema.schema.boolean({
    defaultValue: false
  })
});
const coreConfig = exports.coreConfig = {
  path: 'core',
  schema: coreConfigSchema
};