"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performDeleteByNamespace = void 0;
var esKuery = _interopRequireWildcard(require("@kbn/es-query"));
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _search = require("../search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const performDeleteByNamespace = async ({
  namespace,
  options
}, {
  registry,
  helpers,
  client,
  mappings,
  extensions = {}
}) => {
  const {
    common: commonHelper
  } = helpers;
  // This is not exposed on the SOC; authorization and audit logging is handled by the Spaces plugin
  if (!namespace || typeof namespace !== 'string' || namespace === '*') {
    throw new TypeError(`namespace is required, and must be a string that is not equal to '*'`);
  }
  const allTypes = Object.keys((0, _coreSavedObjectsBaseServerInternal.getRootPropertiesObjects)(mappings));
  const typesToUpdate = [...allTypes.filter(type => !registry.isNamespaceAgnostic(type)), _coreSavedObjectsBaseServerInternal.LEGACY_URL_ALIAS_TYPE];

  // Construct kueryNode to filter legacy URL aliases (these space-agnostic objects do not use root-level "namespace/s" fields)
  const {
    buildNode
  } = esKuery.nodeTypes.function;
  const match1 = buildNode('is', `${_coreSavedObjectsBaseServerInternal.LEGACY_URL_ALIAS_TYPE}.targetNamespace`, namespace);
  const match2 = buildNode('not', buildNode('is', 'type', _coreSavedObjectsBaseServerInternal.LEGACY_URL_ALIAS_TYPE));
  const kueryNode = buildNode('or', [match1, match2]);
  const {
    body,
    statusCode,
    headers
  } = await client.updateByQuery({
    index: commonHelper.getIndicesForTypes(typesToUpdate),
    refresh: options.refresh,
    script: {
      source: `
          if (!ctx._source.containsKey('namespaces')) {
            ctx.op = "delete";
          } else {
            ctx._source['namespaces'].removeAll(Collections.singleton(params['namespace']));
            if (ctx._source['namespaces'].empty) {
              ctx.op = "delete";
            }
          }
        `,
      lang: 'painless',
      params: {
        namespace
      }
    },
    conflicts: 'proceed',
    ...(0, _search.getSearchDsl)(mappings, registry, {
      namespaces: [namespace],
      type: typesToUpdate,
      kueryNode
    }) // Sort types don't match and we're not sorting anyways
  }, {
    ignore: [404],
    meta: true
  });
  // throw if we can't verify a 404 response is from Elasticsearch
  if ((0, _coreElasticsearchServerInternal.isNotFoundFromUnsupportedServer)({
    statusCode,
    headers
  })) {
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundEsUnavailableError();
  }
  return body;
};
exports.performDeleteByNamespace = performDeleteByNamespace;