"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVirtualVersionsFromMappings = exports.getVirtualVersionsFromMappingMeta = void 0;
var _semver = require("semver");
var _conversion = require("./conversion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Build the version map from the specified source of the provided mappings.
 */
const getVirtualVersionsFromMappings = ({
  mappings,
  source,
  knownTypes,
  minimumVirtualVersion
}) => {
  if (!mappings._meta) {
    return undefined;
  }
  return getVirtualVersionsFromMappingMeta({
    meta: mappings._meta,
    source,
    knownTypes,
    minimumVirtualVersion
  });
};
exports.getVirtualVersionsFromMappings = getVirtualVersionsFromMappings;
/**
 * Build the version map from the specified source of the provided mappings meta.
 */
const getVirtualVersionsFromMappingMeta = ({
  meta,
  source,
  knownTypes,
  minimumVirtualVersion
}) => {
  const indexVersions = source === 'mappingVersions' ? meta.mappingVersions : meta.docVersions;
  if (!indexVersions) {
    return undefined;
  }
  const minVersion = minimumVirtualVersion ? new _semver.SemVer(minimumVirtualVersion) : undefined;
  const typeSet = knownTypes ? new Set(knownTypes) : undefined;
  return Object.entries(indexVersions).reduce((map, [type, rawVersion]) => {
    if (!typeSet || typeSet.has(type)) {
      const validatedVersion = (0, _conversion.assertValidVirtualVersion)(rawVersion);
      map[type] = minimumVirtualVersion && minVersion.compare(validatedVersion) === 1 ? minimumVirtualVersion : validatedVersion;
    }
    return map;
  }, {});
};
exports.getVirtualVersionsFromMappingMeta = getVirtualVersionsFromMappingMeta;