"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderedLevels = exports.groupByLevel = exports.getLevelSortValue = exports.getHighestStatus = void 0;
var _load_status = require("./load_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const orderedLevels = exports.orderedLevels = ['critical', 'unavailable', 'degraded', 'available'];
const groupByLevel = statuses => {
  return statuses.reduce((map, status) => {
    var _map$get;
    const existing = (_map$get = map.get(status.state.id)) !== null && _map$get !== void 0 ? _map$get : [];
    map.set(status.state.id, [...existing, status]);
    return map;
  }, new Map());
};
exports.groupByLevel = groupByLevel;
const getHighestStatus = statuses => {
  const grouped = groupByLevel(statuses);
  for (const level of orderedLevels) {
    if (grouped.has(level) && grouped.get(level).length) {
      const {
        message,
        ...status
      } = grouped.get(level)[0].state;
      return status;
    }
  }
  return {
    id: 'available',
    title: _load_status.STATUS_LEVEL_UI_ATTRS.available.title,
    uiColor: _load_status.STATUS_LEVEL_UI_ATTRS.available.uiColor
  };
};
exports.getHighestStatus = getHighestStatus;
const getLevelSortValue = status => {
  return orderedLevels.indexOf(status.state.id);
};
exports.getLevelSortValue = getLevelSortValue;