"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleEuiDevProviderWarning = handleEuiDevProviderWarning;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/browser-internal/src/handle_eui_dev_provider_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Ensure developers are notified if working in a context that lacks the EUI Provider.
 * @internal
 */
function handleEuiDevProviderWarning({
  notifications
}) {
  (0, _eui.setEuiDevProviderWarning)(providerError => {
    var _errorObject$stack;
    const errorObject = new Error(providerError.toString());
    // 1. show a stack trace in the console
    // eslint-disable-next-line no-console
    console.error(errorObject);

    // 2. store error in sessionStorage so it can be detected in testing
    const storedError = {
      message: providerError.toString(),
      stack: (_errorObject$stack = errorObject.stack) !== null && _errorObject$stack !== void 0 ? _errorObject$stack : 'undefined',
      pageHref: window.location.href,
      pageTitle: document.title
    };
    sessionStorage.setItem('dev.euiProviderWarning', JSON.stringify(storedError));

    // 3. error toast / popup
    notifications.toasts.addDanger({
      title: '`EuiProvider` is missing',
      text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.chrome.euiDevProviderWarning",
        defaultMessage: "Kibana components must be wrapped in a React Context provider for full functionality and proper theming support. See {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement("a", {
            href: "https://docs.elastic.dev/kibana-dev-docs/react-context",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 50,
              columnNumber: 17
            }
          }, "https://docs.elastic.dev/kibana-dev-docs/react-context")
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 11
        }
      }))),
      'data-test-subj': 'core-chrome-euiDevProviderWarning-toast',
      toastLifeTimeMs: 60 * 60 * 1000 // keep message visible for up to an hour
    });
  });
}