"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styles = void 0;
var _react = require("@emotion/react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const root = ({
  euiTheme
}) => (0, _react.css)`
    grid-area: application;
    height: 100%;
    position: relative;
    width: 100%;
    z-index: ${_coreChromeLayoutConstants.layoutLevels.content};

    display: flex;
    flex-direction: column;

    &:focus-visible {
      border: 2px solid ${euiTheme.colors.textParagraph};
    }
  `;
const content = () => (0, _react.css)`
  display: flex;
  flex-direction: column;
  flex-grow: 1;
`;
const topBar = ({
  euiTheme
}) => (0, _react.css)`
  position: sticky;
  top: 0;
  z-index: ${_coreChromeLayoutConstants.layoutLevels.applicationTopBar};
  height: ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height')};
  flex-shrink: 0;
`;
const bottomBar = ({
  euiTheme
}) => (0, _react.css)`
  position: sticky;
  bottom: 0;
  z-index: ${_coreChromeLayoutConstants.layoutLevels.applicationBottomBar};
  height: ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.height')};
  flex-shrink: 0;
`;
const styles = exports.styles = {
  root,
  content,
  topBar,
  bottomBar
};