"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focusAdjacentTrigger = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function to focus the adjacent trigger element.
 *
 * @param direction - the direction to focus the adjacent trigger element.
 */
const focusAdjacentTrigger = (ref, direction) => {
  var _triggers$nextIdx;
  if (typeof window === 'undefined' || !ref.current) return;
  const container = document.querySelector(`#${_constants.NAVIGATION_ROOT_SELECTOR}`);
  const triggers = container ? Array.from(container.querySelectorAll('[data-menu-item]')).filter(el => {
    var _window$getComputedSt, _window;
    if (el.hasAttribute('disabled')) return false;
    if (el.getAttribute('aria-hidden') === 'true') return false;
    const style = (_window$getComputedSt = (_window = window).getComputedStyle) === null || _window$getComputedSt === void 0 ? void 0 : _window$getComputedSt.call(_window, el);
    if (style) return style.display !== 'none' && style.visibility !== 'hidden';
    return true;
  }) : [];
  const currentIdx = triggers.indexOf(ref.current);
  if (currentIdx === -1) return;
  const nextIdx = Math.max(0, Math.min(triggers.length - 1, currentIdx + direction));
  (_triggers$nextIdx = triggers[nextIdx]) === null || _triggers$nextIdx === void 0 ? void 0 : _triggers$nextIdx.focus();
};
exports.focusAdjacentTrigger = focusAdjacentTrigger;