"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationsService = void 0;
var _deprecations_client = require("./deprecations_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DeprecationsService {
  setup() {}
  start({
    http
  }) {
    const deprecationsClient = new _deprecations_client.DeprecationsClient({
      http
    });
    return {
      getAllDeprecations: deprecationsClient.getAllDeprecations,
      getDeprecations: deprecationsClient.getDeprecations,
      isDeprecationResolvable: deprecationsClient.isDeprecationResolvable,
      resolveDeprecation: deprecationsClient.resolveDeprecation
    };
  }
  stop() {}
}
exports.DeprecationsService = DeprecationsService;