"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Should be exported from elastic/apm-rum

/** @internal */
class ExecutionContextService {
  constructor() {
    (0, _defineProperty2.default)(this, "context$", new _rxjs.BehaviorSubject({}));
    (0, _defineProperty2.default)(this, "appId", void 0);
    (0, _defineProperty2.default)(this, "subscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "contract", void 0);
  }
  setup({
    analytics
  }) {
    this.enrichAnalyticsContext(analytics);
    this.contract = {
      context$: this.context$.asObservable(),
      clear: () => {
        this.context$.next(this.getDefaultContext());
      },
      set: c => {
        const newVal = this.mergeContext(c);
        if (!(0, _lodash.isEqual)(newVal, this.context$.value)) {
          this.context$.next(newVal);
        }
      },
      get: () => {
        return this.mergeContext();
      },
      getAsLabels: () => {
        var _this$context$$value, _this$context$$value2;
        return this.removeUndefined({
          name: this.appId,
          id: (_this$context$$value = this.context$.value) === null || _this$context$$value === void 0 ? void 0 : _this$context$$value.id,
          page: (_this$context$$value2 = this.context$.value) === null || _this$context$$value2 === void 0 ? void 0 : _this$context$$value2.page
        });
      },
      withGlobalContext: context => {
        return this.mergeContext(context);
      }
    };
    return this.contract;
  }
  start({
    curApp$
  }) {
    const start = this.contract;

    // Track app id changes and clear context on app change
    this.subscription.add(curApp$.subscribe(appId => {
      this.appId = appId;
      start.clear();
    }));
    return start;
  }
  stop() {
    this.subscription.unsubscribe();
  }
  removeUndefined(context = {}) {
    return (0, _lodash.omitBy)(context, _lodash.isUndefined);
  }
  getDefaultContext() {
    return {
      type: 'application',
      name: this.appId,
      url: window.location.pathname
    };
  }
  mergeContext(context = {}) {
    return {
      ...this.getDefaultContext(),
      ...this.context$.value,
      ...context
    };
  }

  /**
   * Sets the analytics context provider based on the execution context details.
   * @param analytics The analytics service
   * @internal
   */
  enrichAnalyticsContext(analytics) {
    analytics.registerContextProvider({
      name: 'execution_context',
      context$: this.context$.pipe((0, _rxjs.map)(({
        type,
        name,
        page,
        id
      }) => {
        var _ref;
        return {
          pageName: `${(0, _lodash.compact)([type, name, page]).join(':')}`,
          applicationId: (_ref = name !== null && name !== void 0 ? name : type) !== null && _ref !== void 0 ? _ref : 'unknown',
          page,
          entityId: id
        };
      })),
      schema: {
        pageName: {
          type: 'keyword',
          _meta: {
            description: 'The name of the current page'
          }
        },
        page: {
          type: 'keyword',
          _meta: {
            description: 'The current page',
            optional: true
          }
        },
        applicationId: {
          type: 'keyword',
          _meta: {
            description: 'The id of the current application'
          }
        },
        entityId: {
          type: 'keyword',
          _meta: {
            description: 'The id of the current entity (dashboard, visualization, canvas, lens, etc)',
            optional: true
          }
        }
      }
    });
  }
}
exports.ExecutionContextService = ExecutionContextService;