"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRetryAfter = getRetryAfter;
exports.isRateLimiterError = isRateLimiterError;
var _coreHttpBrowser = require("@kbn/core-http-browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RATE_LIMITER_POLICY = 'elu';
function isRateLimiterError(error) {
  var _error$response, _error$response$heade;
  return !!((0, _coreHttpBrowser.isHttpFetchError)(error) && ((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 429 && (_error$response$heade = error.response.headers.get('RateLimit')) !== null && _error$response$heade !== void 0 && _error$response$heade.split(';').map(chunk => chunk.replace(/^['"]?(.*?)['"]?$/, '$1')).includes(RATE_LIMITER_POLICY));
}
function getRetryAfter(error) {
  var _error$response2;
  const retryAfter = (_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.headers.get('Retry-After');
  return retryAfter ? parseInt(retryAfter, 10) : 0;
}