"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _global_toast_list = require("./global_toast_list");
var _toasts_api = require("./toasts_api");
var _telemetry = require("./telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/src/core/packages/notifications/browser-internal/src/toasts/toasts_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class ToastsService {
  constructor() {
    (0, _defineProperty2.default)(this, "api", void 0);
    (0, _defineProperty2.default)(this, "targetDomElement", void 0);
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.ToastsTelemetry());
  }
  setup({
    uiSettings,
    analytics
  }) {
    this.api = new _toasts_api.ToastsApi({
      uiSettings
    });
    this.telemetry.setup({
      analytics
    });
    return this.api;
  }
  start({
    overlays,
    targetDomElement,
    rendering,
    analytics,
    notificationCoordinator
  }) {
    this.api.start({
      overlays,
      rendering
    });
    this.targetDomElement = targetDomElement;
    const reportEvent = this.telemetry.start({
      analytics
    });
    const coordinator = notificationCoordinator(ToastsService.name);
    const toasts$ = coordinator.optInToCoordination(this.api.get$(), ({
      locked,
      controller
    }) => {
      // new toasts will only be emitted when there are no locks, or when the current lock is owned by the toast service
      return !locked || controller === ToastsService.name;
    });
    (0, _reactDom.render)(rendering.addContext(/*#__PURE__*/_react.default.createElement(_global_toast_list.GlobalToastList, {
      dismissToast: toastId => this.api.remove(toastId),
      toasts$: toasts$,
      reportEvent: reportEvent,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    })), targetDomElement);
    return this.api;
  }
  stop() {
    if (this.targetDomElement) {
      (0, _reactDom.unmountComponentAtNode)(this.targetDomElement);
      this.targetDomElement.textContent = '';
    }
  }
}
exports.ToastsService = ToastsService;