// IWYU pragma: private, include "nvim/option_defs.h"

typedef enum {
  kOptInvalid = -1,
  kOptAleph = 0,
  kOptAllowrevins = 1,
  kOptAmbiwidth = 2,
  kOptArabic = 3,
  kOptArabicshape = 4,
  kOptAutochdir = 5,
  kOptAutocomplete = 6,
  kOptAutocompletedelay = 7,
  kOptAutocompletetimeout = 8,
  kOptAutoindent = 9,
  kOptAutoread = 10,
  kOptAutowrite = 11,
  kOptAutowriteall = 12,
  kOptBackground = 13,
  kOptBackspace = 14,
  kOptBackup = 15,
  kOptBackupcopy = 16,
  kOptBackupdir = 17,
  kOptBackupext = 18,
  kOptBackupskip = 19,
  kOptBelloff = 20,
  kOptBinary = 21,
  kOptBomb = 22,
  kOptBreakat = 23,
  kOptBreakindent = 24,
  kOptBreakindentopt = 25,
  kOptBrowsedir = 26,
  kOptBufhidden = 27,
  kOptBuflisted = 28,
  kOptBuftype = 29,
  kOptBusy = 30,
  kOptCasemap = 31,
  kOptCdhome = 32,
  kOptCdpath = 33,
  kOptCedit = 34,
  kOptChannel = 35,
  kOptCharconvert = 36,
  kOptChistory = 37,
  kOptCindent = 38,
  kOptCinkeys = 39,
  kOptCinoptions = 40,
  kOptCinscopedecls = 41,
  kOptCinwords = 42,
  kOptClipboard = 43,
  kOptCmdheight = 44,
  kOptCmdwinheight = 45,
  kOptColorcolumn = 46,
  kOptColumns = 47,
  kOptComments = 48,
  kOptCommentstring = 49,
  kOptCompatible = 50,
  kOptComplete = 51,
  kOptCompletefunc = 52,
  kOptCompletefuzzycollect = 53,
  kOptCompleteitemalign = 54,
  kOptCompleteopt = 55,
  kOptCompleteslash = 56,
  kOptCompletetimeout = 57,
  kOptConcealcursor = 58,
  kOptConceallevel = 59,
  kOptConfirm = 60,
  kOptCopyindent = 61,
  kOptCpoptions = 62,
  kOptCursorbind = 63,
  kOptCursorcolumn = 64,
  kOptCursorline = 65,
  kOptCursorlineopt = 66,
  kOptDebug = 67,
  kOptDefine = 68,
  kOptDelcombine = 69,
  kOptDictionary = 70,
  kOptDiff = 71,
  kOptDiffanchors = 72,
  kOptDiffexpr = 73,
  kOptDiffopt = 74,
  kOptDigraph = 75,
  kOptDirectory = 76,
  kOptDisplay = 77,
  kOptEadirection = 78,
  kOptEdcompatible = 79,
  kOptEmoji = 80,
  kOptEncoding = 81,
  kOptEndoffile = 82,
  kOptEndofline = 83,
  kOptEqualalways = 84,
  kOptEqualprg = 85,
  kOptErrorbells = 86,
  kOptErrorfile = 87,
  kOptErrorformat = 88,
  kOptEventignore = 89,
  kOptEventignorewin = 90,
  kOptExpandtab = 91,
  kOptExrc = 92,
  kOptFileencoding = 93,
  kOptFileencodings = 94,
  kOptFileformat = 95,
  kOptFileformats = 96,
  kOptFileignorecase = 97,
  kOptFiletype = 98,
  kOptFillchars = 99,
  kOptFindfunc = 100,
  kOptFixendofline = 101,
  kOptFoldclose = 102,
  kOptFoldcolumn = 103,
  kOptFoldenable = 104,
  kOptFoldexpr = 105,
  kOptFoldignore = 106,
  kOptFoldlevel = 107,
  kOptFoldlevelstart = 108,
  kOptFoldmarker = 109,
  kOptFoldmethod = 110,
  kOptFoldminlines = 111,
  kOptFoldnestmax = 112,
  kOptFoldopen = 113,
  kOptFoldtext = 114,
  kOptFormatexpr = 115,
  kOptFormatlistpat = 116,
  kOptFormatoptions = 117,
  kOptFormatprg = 118,
  kOptFsync = 119,
  kOptGdefault = 120,
  kOptGrepformat = 121,
  kOptGrepprg = 122,
  kOptGuicursor = 123,
  kOptGuifont = 124,
  kOptGuifontwide = 125,
  kOptGuioptions = 126,
  kOptGuitablabel = 127,
  kOptGuitabtooltip = 128,
  kOptHelpfile = 129,
  kOptHelpheight = 130,
  kOptHelplang = 131,
  kOptHidden = 132,
  kOptHighlight = 133,
  kOptHistory = 134,
  kOptHkmap = 135,
  kOptHkmapp = 136,
  kOptHlsearch = 137,
  kOptIcon = 138,
  kOptIconstring = 139,
  kOptIgnorecase = 140,
  kOptImcmdline = 141,
  kOptImdisable = 142,
  kOptIminsert = 143,
  kOptImsearch = 144,
  kOptInccommand = 145,
  kOptInclude = 146,
  kOptIncludeexpr = 147,
  kOptIncsearch = 148,
  kOptIndentexpr = 149,
  kOptIndentkeys = 150,
  kOptInfercase = 151,
  kOptInsertmode = 152,
  kOptIsexpand = 153,
  kOptIsfname = 154,
  kOptIsident = 155,
  kOptIskeyword = 156,
  kOptIsprint = 157,
  kOptJoinspaces = 158,
  kOptJumpoptions = 159,
  kOptKeymap = 160,
  kOptKeymodel = 161,
  kOptKeywordprg = 162,
  kOptLangmap = 163,
  kOptLangmenu = 164,
  kOptLangnoremap = 165,
  kOptLangremap = 166,
  kOptLaststatus = 167,
  kOptLazyredraw = 168,
  kOptLhistory = 169,
  kOptLinebreak = 170,
  kOptLines = 171,
  kOptLinespace = 172,
  kOptLisp = 173,
  kOptLispoptions = 174,
  kOptLispwords = 175,
  kOptList = 176,
  kOptListchars = 177,
  kOptLoadplugins = 178,
  kOptMagic = 179,
  kOptMakeef = 180,
  kOptMakeencoding = 181,
  kOptMakeprg = 182,
  kOptMatchpairs = 183,
  kOptMatchtime = 184,
  kOptMaxcombine = 185,
  kOptMaxfuncdepth = 186,
  kOptMaxmapdepth = 187,
  kOptMaxmempattern = 188,
  kOptMaxsearchcount = 189,
  kOptMenuitems = 190,
  kOptMessagesopt = 191,
  kOptMkspellmem = 192,
  kOptModeline = 193,
  kOptModelineexpr = 194,
  kOptModelines = 195,
  kOptModifiable = 196,
  kOptModified = 197,
  kOptMore = 198,
  kOptMouse = 199,
  kOptMousefocus = 200,
  kOptMousehide = 201,
  kOptMousemodel = 202,
  kOptMousemoveevent = 203,
  kOptMousescroll = 204,
  kOptMouseshape = 205,
  kOptMousetime = 206,
  kOptNrformats = 207,
  kOptNumber = 208,
  kOptNumberwidth = 209,
  kOptOmnifunc = 210,
  kOptOpendevice = 211,
  kOptOperatorfunc = 212,
  kOptPackpath = 213,
  kOptParagraphs = 214,
  kOptPaste = 215,
  kOptPastetoggle = 216,
  kOptPatchexpr = 217,
  kOptPatchmode = 218,
  kOptPath = 219,
  kOptPreserveindent = 220,
  kOptPreviewheight = 221,
  kOptPreviewwindow = 222,
  kOptPrompt = 223,
  kOptPumblend = 224,
  kOptPumborder = 225,
  kOptPumheight = 226,
  kOptPummaxwidth = 227,
  kOptPumwidth = 228,
  kOptPyxversion = 229,
  kOptQuickfixtextfunc = 230,
  kOptQuoteescape = 231,
  kOptReadonly = 232,
  kOptRedrawdebug = 233,
  kOptRedrawtime = 234,
  kOptRegexpengine = 235,
  kOptRelativenumber = 236,
  kOptRemap = 237,
  kOptReport = 238,
  kOptRevins = 239,
  kOptRightleft = 240,
  kOptRightleftcmd = 241,
  kOptRuler = 242,
  kOptRulerformat = 243,
  kOptRuntimepath = 244,
  kOptScroll = 245,
  kOptScrollback = 246,
  kOptScrollbind = 247,
  kOptScrolljump = 248,
  kOptScrolloff = 249,
  kOptScrollopt = 250,
  kOptSections = 251,
  kOptSecure = 252,
  kOptSelection = 253,
  kOptSelectmode = 254,
  kOptSessionoptions = 255,
  kOptShada = 256,
  kOptShadafile = 257,
  kOptShell = 258,
  kOptShellcmdflag = 259,
  kOptShellpipe = 260,
  kOptShellquote = 261,
  kOptShellredir = 262,
  kOptShellslash = 263,
  kOptShelltemp = 264,
  kOptShellxescape = 265,
  kOptShellxquote = 266,
  kOptShiftround = 267,
  kOptShiftwidth = 268,
  kOptShortmess = 269,
  kOptShowbreak = 270,
  kOptShowcmd = 271,
  kOptShowcmdloc = 272,
  kOptShowfulltag = 273,
  kOptShowmatch = 274,
  kOptShowmode = 275,
  kOptShowtabline = 276,
  kOptSidescroll = 277,
  kOptSidescrolloff = 278,
  kOptSigncolumn = 279,
  kOptSmartcase = 280,
  kOptSmartindent = 281,
  kOptSmarttab = 282,
  kOptSmoothscroll = 283,
  kOptSofttabstop = 284,
  kOptSpell = 285,
  kOptSpellcapcheck = 286,
  kOptSpellfile = 287,
  kOptSpelllang = 288,
  kOptSpelloptions = 289,
  kOptSpellsuggest = 290,
  kOptSplitbelow = 291,
  kOptSplitkeep = 292,
  kOptSplitright = 293,
  kOptStartofline = 294,
  kOptStatuscolumn = 295,
  kOptStatusline = 296,
  kOptSuffixes = 297,
  kOptSuffixesadd = 298,
  kOptSwapfile = 299,
  kOptSwitchbuf = 300,
  kOptSynmaxcol = 301,
  kOptSyntax = 302,
  kOptTabclose = 303,
  kOptTabline = 304,
  kOptTabpagemax = 305,
  kOptTabstop = 306,
  kOptTagbsearch = 307,
  kOptTagcase = 308,
  kOptTagfunc = 309,
  kOptTaglength = 310,
  kOptTagrelative = 311,
  kOptTags = 312,
  kOptTagstack = 313,
  kOptTermbidi = 314,
  kOptTermencoding = 315,
  kOptTermguicolors = 316,
  kOptTermpastefilter = 317,
  kOptTermsync = 318,
  kOptTerse = 319,
  kOptTextwidth = 320,
  kOptThesaurus = 321,
  kOptThesaurusfunc = 322,
  kOptTildeop = 323,
  kOptTimeout = 324,
  kOptTimeoutlen = 325,
  kOptTitle = 326,
  kOptTitlelen = 327,
  kOptTitleold = 328,
  kOptTitlestring = 329,
  kOptTtimeout = 330,
  kOptTtimeoutlen = 331,
  kOptTtyfast = 332,
  kOptUndodir = 333,
  kOptUndofile = 334,
  kOptUndolevels = 335,
  kOptUndoreload = 336,
  kOptUpdatecount = 337,
  kOptUpdatetime = 338,
  kOptVarsofttabstop = 339,
  kOptVartabstop = 340,
  kOptVerbose = 341,
  kOptVerbosefile = 342,
  kOptViewdir = 343,
  kOptViewoptions = 344,
  kOptVirtualedit = 345,
  kOptVisualbell = 346,
  kOptWarn = 347,
  kOptWhichwrap = 348,
  kOptWildchar = 349,
  kOptWildcharm = 350,
  kOptWildignore = 351,
  kOptWildignorecase = 352,
  kOptWildmenu = 353,
  kOptWildmode = 354,
  kOptWildoptions = 355,
  kOptWinaltkeys = 356,
  kOptWinbar = 357,
  kOptWinblend = 358,
  kOptWinborder = 359,
  kOptWindow = 360,
  kOptWinfixbuf = 361,
  kOptWinfixheight = 362,
  kOptWinfixwidth = 363,
  kOptWinheight = 364,
  kOptWinhighlight = 365,
  kOptWinminheight = 366,
  kOptWinminwidth = 367,
  kOptWinwidth = 368,
  kOptWrap = 369,
  kOptWrapmargin = 370,
  kOptWrapscan = 371,
  kOptWrite = 372,
  kOptWriteany = 373,
  kOptWritebackup = 374,
  kOptWritedelay = 375,
  // Option count
#define kOptCount 376
} OptIndex;

typedef enum {
  kGlobalOptInvalid = -1,
  kGlobalOptAleph = 0,
  kGlobalOptAllowrevins = 1,
  kGlobalOptAmbiwidth = 2,
  kGlobalOptArabicshape = 3,
  kGlobalOptAutochdir = 4,
  kGlobalOptAutocomplete = 5,
  kGlobalOptAutocompletedelay = 6,
  kGlobalOptAutocompletetimeout = 7,
  kGlobalOptAutoread = 8,
  kGlobalOptAutowrite = 9,
  kGlobalOptAutowriteall = 10,
  kGlobalOptBackground = 11,
  kGlobalOptBackspace = 12,
  kGlobalOptBackup = 13,
  kGlobalOptBackupcopy = 14,
  kGlobalOptBackupdir = 15,
  kGlobalOptBackupext = 16,
  kGlobalOptBackupskip = 17,
  kGlobalOptBelloff = 18,
  kGlobalOptBreakat = 19,
  kGlobalOptBrowsedir = 20,
  kGlobalOptCasemap = 21,
  kGlobalOptCdhome = 22,
  kGlobalOptCdpath = 23,
  kGlobalOptCedit = 24,
  kGlobalOptCharconvert = 25,
  kGlobalOptChistory = 26,
  kGlobalOptClipboard = 27,
  kGlobalOptCmdheight = 28,
  kGlobalOptCmdwinheight = 29,
  kGlobalOptColumns = 30,
  kGlobalOptCompatible = 31,
  kGlobalOptCompletefuzzycollect = 32,
  kGlobalOptCompleteitemalign = 33,
  kGlobalOptCompleteopt = 34,
  kGlobalOptCompletetimeout = 35,
  kGlobalOptConfirm = 36,
  kGlobalOptCpoptions = 37,
  kGlobalOptDebug = 38,
  kGlobalOptDefine = 39,
  kGlobalOptDelcombine = 40,
  kGlobalOptDictionary = 41,
  kGlobalOptDiffanchors = 42,
  kGlobalOptDiffexpr = 43,
  kGlobalOptDiffopt = 44,
  kGlobalOptDigraph = 45,
  kGlobalOptDirectory = 46,
  kGlobalOptDisplay = 47,
  kGlobalOptEadirection = 48,
  kGlobalOptEdcompatible = 49,
  kGlobalOptEmoji = 50,
  kGlobalOptEncoding = 51,
  kGlobalOptEqualalways = 52,
  kGlobalOptEqualprg = 53,
  kGlobalOptErrorbells = 54,
  kGlobalOptErrorfile = 55,
  kGlobalOptErrorformat = 56,
  kGlobalOptEventignore = 57,
  kGlobalOptExrc = 58,
  kGlobalOptFileencodings = 59,
  kGlobalOptFileformats = 60,
  kGlobalOptFileignorecase = 61,
  kGlobalOptFillchars = 62,
  kGlobalOptFindfunc = 63,
  kGlobalOptFoldclose = 64,
  kGlobalOptFoldlevelstart = 65,
  kGlobalOptFoldopen = 66,
  kGlobalOptFormatprg = 67,
  kGlobalOptFsync = 68,
  kGlobalOptGdefault = 69,
  kGlobalOptGrepformat = 70,
  kGlobalOptGrepprg = 71,
  kGlobalOptGuicursor = 72,
  kGlobalOptGuifont = 73,
  kGlobalOptGuifontwide = 74,
  kGlobalOptGuioptions = 75,
  kGlobalOptGuitablabel = 76,
  kGlobalOptGuitabtooltip = 77,
  kGlobalOptHelpfile = 78,
  kGlobalOptHelpheight = 79,
  kGlobalOptHelplang = 80,
  kGlobalOptHidden = 81,
  kGlobalOptHighlight = 82,
  kGlobalOptHistory = 83,
  kGlobalOptHkmap = 84,
  kGlobalOptHkmapp = 85,
  kGlobalOptHlsearch = 86,
  kGlobalOptIcon = 87,
  kGlobalOptIconstring = 88,
  kGlobalOptIgnorecase = 89,
  kGlobalOptImcmdline = 90,
  kGlobalOptImdisable = 91,
  kGlobalOptInccommand = 92,
  kGlobalOptInclude = 93,
  kGlobalOptIncsearch = 94,
  kGlobalOptInsertmode = 95,
  kGlobalOptIsexpand = 96,
  kGlobalOptIsfname = 97,
  kGlobalOptIsident = 98,
  kGlobalOptIsprint = 99,
  kGlobalOptJoinspaces = 100,
  kGlobalOptJumpoptions = 101,
  kGlobalOptKeymodel = 102,
  kGlobalOptKeywordprg = 103,
  kGlobalOptLangmap = 104,
  kGlobalOptLangmenu = 105,
  kGlobalOptLangnoremap = 106,
  kGlobalOptLangremap = 107,
  kGlobalOptLaststatus = 108,
  kGlobalOptLazyredraw = 109,
  kGlobalOptLines = 110,
  kGlobalOptLinespace = 111,
  kGlobalOptLispwords = 112,
  kGlobalOptListchars = 113,
  kGlobalOptLoadplugins = 114,
  kGlobalOptMagic = 115,
  kGlobalOptMakeef = 116,
  kGlobalOptMakeencoding = 117,
  kGlobalOptMakeprg = 118,
  kGlobalOptMatchtime = 119,
  kGlobalOptMaxcombine = 120,
  kGlobalOptMaxfuncdepth = 121,
  kGlobalOptMaxmapdepth = 122,
  kGlobalOptMaxmempattern = 123,
  kGlobalOptMaxsearchcount = 124,
  kGlobalOptMenuitems = 125,
  kGlobalOptMessagesopt = 126,
  kGlobalOptMkspellmem = 127,
  kGlobalOptModelineexpr = 128,
  kGlobalOptModelines = 129,
  kGlobalOptMore = 130,
  kGlobalOptMouse = 131,
  kGlobalOptMousefocus = 132,
  kGlobalOptMousehide = 133,
  kGlobalOptMousemodel = 134,
  kGlobalOptMousemoveevent = 135,
  kGlobalOptMousescroll = 136,
  kGlobalOptMouseshape = 137,
  kGlobalOptMousetime = 138,
  kGlobalOptOpendevice = 139,
  kGlobalOptOperatorfunc = 140,
  kGlobalOptPackpath = 141,
  kGlobalOptParagraphs = 142,
  kGlobalOptPaste = 143,
  kGlobalOptPastetoggle = 144,
  kGlobalOptPatchexpr = 145,
  kGlobalOptPatchmode = 146,
  kGlobalOptPath = 147,
  kGlobalOptPreviewheight = 148,
  kGlobalOptPrompt = 149,
  kGlobalOptPumblend = 150,
  kGlobalOptPumborder = 151,
  kGlobalOptPumheight = 152,
  kGlobalOptPummaxwidth = 153,
  kGlobalOptPumwidth = 154,
  kGlobalOptPyxversion = 155,
  kGlobalOptQuickfixtextfunc = 156,
  kGlobalOptRedrawdebug = 157,
  kGlobalOptRedrawtime = 158,
  kGlobalOptRegexpengine = 159,
  kGlobalOptRemap = 160,
  kGlobalOptReport = 161,
  kGlobalOptRevins = 162,
  kGlobalOptRuler = 163,
  kGlobalOptRulerformat = 164,
  kGlobalOptRuntimepath = 165,
  kGlobalOptScrolljump = 166,
  kGlobalOptScrolloff = 167,
  kGlobalOptScrollopt = 168,
  kGlobalOptSections = 169,
  kGlobalOptSecure = 170,
  kGlobalOptSelection = 171,
  kGlobalOptSelectmode = 172,
  kGlobalOptSessionoptions = 173,
  kGlobalOptShada = 174,
  kGlobalOptShadafile = 175,
  kGlobalOptShell = 176,
  kGlobalOptShellcmdflag = 177,
  kGlobalOptShellpipe = 178,
  kGlobalOptShellquote = 179,
  kGlobalOptShellredir = 180,
  kGlobalOptShellslash = 181,
  kGlobalOptShelltemp = 182,
  kGlobalOptShellxescape = 183,
  kGlobalOptShellxquote = 184,
  kGlobalOptShiftround = 185,
  kGlobalOptShortmess = 186,
  kGlobalOptShowbreak = 187,
  kGlobalOptShowcmd = 188,
  kGlobalOptShowcmdloc = 189,
  kGlobalOptShowfulltag = 190,
  kGlobalOptShowmatch = 191,
  kGlobalOptShowmode = 192,
  kGlobalOptShowtabline = 193,
  kGlobalOptSidescroll = 194,
  kGlobalOptSidescrolloff = 195,
  kGlobalOptSmartcase = 196,
  kGlobalOptSmarttab = 197,
  kGlobalOptSpellsuggest = 198,
  kGlobalOptSplitbelow = 199,
  kGlobalOptSplitkeep = 200,
  kGlobalOptSplitright = 201,
  kGlobalOptStartofline = 202,
  kGlobalOptStatusline = 203,
  kGlobalOptSuffixes = 204,
  kGlobalOptSwitchbuf = 205,
  kGlobalOptTabclose = 206,
  kGlobalOptTabline = 207,
  kGlobalOptTabpagemax = 208,
  kGlobalOptTagbsearch = 209,
  kGlobalOptTagcase = 210,
  kGlobalOptTaglength = 211,
  kGlobalOptTagrelative = 212,
  kGlobalOptTags = 213,
  kGlobalOptTagstack = 214,
  kGlobalOptTermbidi = 215,
  kGlobalOptTermencoding = 216,
  kGlobalOptTermguicolors = 217,
  kGlobalOptTermpastefilter = 218,
  kGlobalOptTermsync = 219,
  kGlobalOptTerse = 220,
  kGlobalOptThesaurus = 221,
  kGlobalOptThesaurusfunc = 222,
  kGlobalOptTildeop = 223,
  kGlobalOptTimeout = 224,
  kGlobalOptTimeoutlen = 225,
  kGlobalOptTitle = 226,
  kGlobalOptTitlelen = 227,
  kGlobalOptTitleold = 228,
  kGlobalOptTitlestring = 229,
  kGlobalOptTtimeout = 230,
  kGlobalOptTtimeoutlen = 231,
  kGlobalOptTtyfast = 232,
  kGlobalOptUndodir = 233,
  kGlobalOptUndolevels = 234,
  kGlobalOptUndoreload = 235,
  kGlobalOptUpdatecount = 236,
  kGlobalOptUpdatetime = 237,
  kGlobalOptVerbose = 238,
  kGlobalOptVerbosefile = 239,
  kGlobalOptViewdir = 240,
  kGlobalOptViewoptions = 241,
  kGlobalOptVirtualedit = 242,
  kGlobalOptVisualbell = 243,
  kGlobalOptWarn = 244,
  kGlobalOptWhichwrap = 245,
  kGlobalOptWildchar = 246,
  kGlobalOptWildcharm = 247,
  kGlobalOptWildignore = 248,
  kGlobalOptWildignorecase = 249,
  kGlobalOptWildmenu = 250,
  kGlobalOptWildmode = 251,
  kGlobalOptWildoptions = 252,
  kGlobalOptWinaltkeys = 253,
  kGlobalOptWinbar = 254,
  kGlobalOptWinborder = 255,
  kGlobalOptWindow = 256,
  kGlobalOptWinheight = 257,
  kGlobalOptWinminheight = 258,
  kGlobalOptWinminwidth = 259,
  kGlobalOptWinwidth = 260,
  kGlobalOptWrapscan = 261,
  kGlobalOptWrite = 262,
  kGlobalOptWriteany = 263,
  kGlobalOptWritebackup = 264,
  kGlobalOptWritedelay = 265,
  // Global option count
#define kGlobalOptCount 266
} GlobalOptIndex;

typedef enum {
  kBufOptInvalid = -1,
  kBufOptAutocomplete = 0,
  kBufOptAutoindent = 1,
  kBufOptAutoread = 2,
  kBufOptBackupcopy = 3,
  kBufOptBinary = 4,
  kBufOptBomb = 5,
  kBufOptBufhidden = 6,
  kBufOptBuflisted = 7,
  kBufOptBuftype = 8,
  kBufOptBusy = 9,
  kBufOptChannel = 10,
  kBufOptCindent = 11,
  kBufOptCinkeys = 12,
  kBufOptCinoptions = 13,
  kBufOptCinscopedecls = 14,
  kBufOptCinwords = 15,
  kBufOptComments = 16,
  kBufOptCommentstring = 17,
  kBufOptComplete = 18,
  kBufOptCompletefunc = 19,
  kBufOptCompleteopt = 20,
  kBufOptCompleteslash = 21,
  kBufOptCopyindent = 22,
  kBufOptDefine = 23,
  kBufOptDictionary = 24,
  kBufOptDiffanchors = 25,
  kBufOptEndoffile = 26,
  kBufOptEndofline = 27,
  kBufOptEqualprg = 28,
  kBufOptErrorformat = 29,
  kBufOptExpandtab = 30,
  kBufOptFileencoding = 31,
  kBufOptFileformat = 32,
  kBufOptFiletype = 33,
  kBufOptFindfunc = 34,
  kBufOptFixendofline = 35,
  kBufOptFormatexpr = 36,
  kBufOptFormatlistpat = 37,
  kBufOptFormatoptions = 38,
  kBufOptFormatprg = 39,
  kBufOptGrepformat = 40,
  kBufOptGrepprg = 41,
  kBufOptIminsert = 42,
  kBufOptImsearch = 43,
  kBufOptInclude = 44,
  kBufOptIncludeexpr = 45,
  kBufOptIndentexpr = 46,
  kBufOptIndentkeys = 47,
  kBufOptInfercase = 48,
  kBufOptIsexpand = 49,
  kBufOptIskeyword = 50,
  kBufOptKeymap = 51,
  kBufOptKeywordprg = 52,
  kBufOptLisp = 53,
  kBufOptLispoptions = 54,
  kBufOptLispwords = 55,
  kBufOptMakeencoding = 56,
  kBufOptMakeprg = 57,
  kBufOptMatchpairs = 58,
  kBufOptModeline = 59,
  kBufOptModifiable = 60,
  kBufOptModified = 61,
  kBufOptNrformats = 62,
  kBufOptOmnifunc = 63,
  kBufOptPath = 64,
  kBufOptPreserveindent = 65,
  kBufOptQuoteescape = 66,
  kBufOptReadonly = 67,
  kBufOptScrollback = 68,
  kBufOptShiftwidth = 69,
  kBufOptSmartindent = 70,
  kBufOptSofttabstop = 71,
  kBufOptSpellcapcheck = 72,
  kBufOptSpellfile = 73,
  kBufOptSpelllang = 74,
  kBufOptSpelloptions = 75,
  kBufOptSuffixesadd = 76,
  kBufOptSwapfile = 77,
  kBufOptSynmaxcol = 78,
  kBufOptSyntax = 79,
  kBufOptTabstop = 80,
  kBufOptTagcase = 81,
  kBufOptTagfunc = 82,
  kBufOptTags = 83,
  kBufOptTextwidth = 84,
  kBufOptThesaurus = 85,
  kBufOptThesaurusfunc = 86,
  kBufOptUndofile = 87,
  kBufOptUndolevels = 88,
  kBufOptVarsofttabstop = 89,
  kBufOptVartabstop = 90,
  kBufOptWrapmargin = 91,
  // Buf option count
#define kBufOptCount 92
} BufOptIndex;

typedef enum {
  kWinOptInvalid = -1,
  kWinOptArabic = 0,
  kWinOptBreakindent = 1,
  kWinOptBreakindentopt = 2,
  kWinOptColorcolumn = 3,
  kWinOptConcealcursor = 4,
  kWinOptConceallevel = 5,
  kWinOptCursorbind = 6,
  kWinOptCursorcolumn = 7,
  kWinOptCursorline = 8,
  kWinOptCursorlineopt = 9,
  kWinOptDiff = 10,
  kWinOptEventignorewin = 11,
  kWinOptFillchars = 12,
  kWinOptFoldcolumn = 13,
  kWinOptFoldenable = 14,
  kWinOptFoldexpr = 15,
  kWinOptFoldignore = 16,
  kWinOptFoldlevel = 17,
  kWinOptFoldmarker = 18,
  kWinOptFoldmethod = 19,
  kWinOptFoldminlines = 20,
  kWinOptFoldnestmax = 21,
  kWinOptFoldtext = 22,
  kWinOptLhistory = 23,
  kWinOptLinebreak = 24,
  kWinOptList = 25,
  kWinOptListchars = 26,
  kWinOptNumber = 27,
  kWinOptNumberwidth = 28,
  kWinOptPreviewwindow = 29,
  kWinOptRelativenumber = 30,
  kWinOptRightleft = 31,
  kWinOptRightleftcmd = 32,
  kWinOptScroll = 33,
  kWinOptScrollbind = 34,
  kWinOptScrolloff = 35,
  kWinOptShowbreak = 36,
  kWinOptSidescrolloff = 37,
  kWinOptSigncolumn = 38,
  kWinOptSmoothscroll = 39,
  kWinOptSpell = 40,
  kWinOptStatuscolumn = 41,
  kWinOptStatusline = 42,
  kWinOptVirtualedit = 43,
  kWinOptWinbar = 44,
  kWinOptWinblend = 45,
  kWinOptWinfixbuf = 46,
  kWinOptWinfixheight = 47,
  kWinOptWinfixwidth = 48,
  kWinOptWinhighlight = 49,
  kWinOptWrap = 50,
  // Win option count
#define kWinOptCount 51
} WinOptIndex;

EXTERN const OptIndex global_opt_idx[] INIT( = {
  [kGlobalOptAleph] = kOptAleph,
  [kGlobalOptAllowrevins] = kOptAllowrevins,
  [kGlobalOptAmbiwidth] = kOptAmbiwidth,
  [kGlobalOptArabicshape] = kOptArabicshape,
  [kGlobalOptAutochdir] = kOptAutochdir,
  [kGlobalOptAutocomplete] = kOptAutocomplete,
  [kGlobalOptAutocompletedelay] = kOptAutocompletedelay,
  [kGlobalOptAutocompletetimeout] = kOptAutocompletetimeout,
  [kGlobalOptAutoread] = kOptAutoread,
  [kGlobalOptAutowrite] = kOptAutowrite,
  [kGlobalOptAutowriteall] = kOptAutowriteall,
  [kGlobalOptBackground] = kOptBackground,
  [kGlobalOptBackspace] = kOptBackspace,
  [kGlobalOptBackup] = kOptBackup,
  [kGlobalOptBackupcopy] = kOptBackupcopy,
  [kGlobalOptBackupdir] = kOptBackupdir,
  [kGlobalOptBackupext] = kOptBackupext,
  [kGlobalOptBackupskip] = kOptBackupskip,
  [kGlobalOptBelloff] = kOptBelloff,
  [kGlobalOptBreakat] = kOptBreakat,
  [kGlobalOptBrowsedir] = kOptBrowsedir,
  [kGlobalOptCasemap] = kOptCasemap,
  [kGlobalOptCdhome] = kOptCdhome,
  [kGlobalOptCdpath] = kOptCdpath,
  [kGlobalOptCedit] = kOptCedit,
  [kGlobalOptCharconvert] = kOptCharconvert,
  [kGlobalOptChistory] = kOptChistory,
  [kGlobalOptClipboard] = kOptClipboard,
  [kGlobalOptCmdheight] = kOptCmdheight,
  [kGlobalOptCmdwinheight] = kOptCmdwinheight,
  [kGlobalOptColumns] = kOptColumns,
  [kGlobalOptCompatible] = kOptCompatible,
  [kGlobalOptCompletefuzzycollect] = kOptCompletefuzzycollect,
  [kGlobalOptCompleteitemalign] = kOptCompleteitemalign,
  [kGlobalOptCompleteopt] = kOptCompleteopt,
  [kGlobalOptCompletetimeout] = kOptCompletetimeout,
  [kGlobalOptConfirm] = kOptConfirm,
  [kGlobalOptCpoptions] = kOptCpoptions,
  [kGlobalOptDebug] = kOptDebug,
  [kGlobalOptDefine] = kOptDefine,
  [kGlobalOptDelcombine] = kOptDelcombine,
  [kGlobalOptDictionary] = kOptDictionary,
  [kGlobalOptDiffanchors] = kOptDiffanchors,
  [kGlobalOptDiffexpr] = kOptDiffexpr,
  [kGlobalOptDiffopt] = kOptDiffopt,
  [kGlobalOptDigraph] = kOptDigraph,
  [kGlobalOptDirectory] = kOptDirectory,
  [kGlobalOptDisplay] = kOptDisplay,
  [kGlobalOptEadirection] = kOptEadirection,
  [kGlobalOptEdcompatible] = kOptEdcompatible,
  [kGlobalOptEmoji] = kOptEmoji,
  [kGlobalOptEncoding] = kOptEncoding,
  [kGlobalOptEqualalways] = kOptEqualalways,
  [kGlobalOptEqualprg] = kOptEqualprg,
  [kGlobalOptErrorbells] = kOptErrorbells,
  [kGlobalOptErrorfile] = kOptErrorfile,
  [kGlobalOptErrorformat] = kOptErrorformat,
  [kGlobalOptEventignore] = kOptEventignore,
  [kGlobalOptExrc] = kOptExrc,
  [kGlobalOptFileencodings] = kOptFileencodings,
  [kGlobalOptFileformats] = kOptFileformats,
  [kGlobalOptFileignorecase] = kOptFileignorecase,
  [kGlobalOptFillchars] = kOptFillchars,
  [kGlobalOptFindfunc] = kOptFindfunc,
  [kGlobalOptFoldclose] = kOptFoldclose,
  [kGlobalOptFoldlevelstart] = kOptFoldlevelstart,
  [kGlobalOptFoldopen] = kOptFoldopen,
  [kGlobalOptFormatprg] = kOptFormatprg,
  [kGlobalOptFsync] = kOptFsync,
  [kGlobalOptGdefault] = kOptGdefault,
  [kGlobalOptGrepformat] = kOptGrepformat,
  [kGlobalOptGrepprg] = kOptGrepprg,
  [kGlobalOptGuicursor] = kOptGuicursor,
  [kGlobalOptGuifont] = kOptGuifont,
  [kGlobalOptGuifontwide] = kOptGuifontwide,
  [kGlobalOptGuioptions] = kOptGuioptions,
  [kGlobalOptGuitablabel] = kOptGuitablabel,
  [kGlobalOptGuitabtooltip] = kOptGuitabtooltip,
  [kGlobalOptHelpfile] = kOptHelpfile,
  [kGlobalOptHelpheight] = kOptHelpheight,
  [kGlobalOptHelplang] = kOptHelplang,
  [kGlobalOptHidden] = kOptHidden,
  [kGlobalOptHighlight] = kOptHighlight,
  [kGlobalOptHistory] = kOptHistory,
  [kGlobalOptHkmap] = kOptHkmap,
  [kGlobalOptHkmapp] = kOptHkmapp,
  [kGlobalOptHlsearch] = kOptHlsearch,
  [kGlobalOptIcon] = kOptIcon,
  [kGlobalOptIconstring] = kOptIconstring,
  [kGlobalOptIgnorecase] = kOptIgnorecase,
  [kGlobalOptImcmdline] = kOptImcmdline,
  [kGlobalOptImdisable] = kOptImdisable,
  [kGlobalOptInccommand] = kOptInccommand,
  [kGlobalOptInclude] = kOptInclude,
  [kGlobalOptIncsearch] = kOptIncsearch,
  [kGlobalOptInsertmode] = kOptInsertmode,
  [kGlobalOptIsexpand] = kOptIsexpand,
  [kGlobalOptIsfname] = kOptIsfname,
  [kGlobalOptIsident] = kOptIsident,
  [kGlobalOptIsprint] = kOptIsprint,
  [kGlobalOptJoinspaces] = kOptJoinspaces,
  [kGlobalOptJumpoptions] = kOptJumpoptions,
  [kGlobalOptKeymodel] = kOptKeymodel,
  [kGlobalOptKeywordprg] = kOptKeywordprg,
  [kGlobalOptLangmap] = kOptLangmap,
  [kGlobalOptLangmenu] = kOptLangmenu,
  [kGlobalOptLangnoremap] = kOptLangnoremap,
  [kGlobalOptLangremap] = kOptLangremap,
  [kGlobalOptLaststatus] = kOptLaststatus,
  [kGlobalOptLazyredraw] = kOptLazyredraw,
  [kGlobalOptLines] = kOptLines,
  [kGlobalOptLinespace] = kOptLinespace,
  [kGlobalOptLispwords] = kOptLispwords,
  [kGlobalOptListchars] = kOptListchars,
  [kGlobalOptLoadplugins] = kOptLoadplugins,
  [kGlobalOptMagic] = kOptMagic,
  [kGlobalOptMakeef] = kOptMakeef,
  [kGlobalOptMakeencoding] = kOptMakeencoding,
  [kGlobalOptMakeprg] = kOptMakeprg,
  [kGlobalOptMatchtime] = kOptMatchtime,
  [kGlobalOptMaxcombine] = kOptMaxcombine,
  [kGlobalOptMaxfuncdepth] = kOptMaxfuncdepth,
  [kGlobalOptMaxmapdepth] = kOptMaxmapdepth,
  [kGlobalOptMaxmempattern] = kOptMaxmempattern,
  [kGlobalOptMaxsearchcount] = kOptMaxsearchcount,
  [kGlobalOptMenuitems] = kOptMenuitems,
  [kGlobalOptMessagesopt] = kOptMessagesopt,
  [kGlobalOptMkspellmem] = kOptMkspellmem,
  [kGlobalOptModelineexpr] = kOptModelineexpr,
  [kGlobalOptModelines] = kOptModelines,
  [kGlobalOptMore] = kOptMore,
  [kGlobalOptMouse] = kOptMouse,
  [kGlobalOptMousefocus] = kOptMousefocus,
  [kGlobalOptMousehide] = kOptMousehide,
  [kGlobalOptMousemodel] = kOptMousemodel,
  [kGlobalOptMousemoveevent] = kOptMousemoveevent,
  [kGlobalOptMousescroll] = kOptMousescroll,
  [kGlobalOptMouseshape] = kOptMouseshape,
  [kGlobalOptMousetime] = kOptMousetime,
  [kGlobalOptOpendevice] = kOptOpendevice,
  [kGlobalOptOperatorfunc] = kOptOperatorfunc,
  [kGlobalOptPackpath] = kOptPackpath,
  [kGlobalOptParagraphs] = kOptParagraphs,
  [kGlobalOptPaste] = kOptPaste,
  [kGlobalOptPastetoggle] = kOptPastetoggle,
  [kGlobalOptPatchexpr] = kOptPatchexpr,
  [kGlobalOptPatchmode] = kOptPatchmode,
  [kGlobalOptPath] = kOptPath,
  [kGlobalOptPreviewheight] = kOptPreviewheight,
  [kGlobalOptPrompt] = kOptPrompt,
  [kGlobalOptPumblend] = kOptPumblend,
  [kGlobalOptPumborder] = kOptPumborder,
  [kGlobalOptPumheight] = kOptPumheight,
  [kGlobalOptPummaxwidth] = kOptPummaxwidth,
  [kGlobalOptPumwidth] = kOptPumwidth,
  [kGlobalOptPyxversion] = kOptPyxversion,
  [kGlobalOptQuickfixtextfunc] = kOptQuickfixtextfunc,
  [kGlobalOptRedrawdebug] = kOptRedrawdebug,
  [kGlobalOptRedrawtime] = kOptRedrawtime,
  [kGlobalOptRegexpengine] = kOptRegexpengine,
  [kGlobalOptRemap] = kOptRemap,
  [kGlobalOptReport] = kOptReport,
  [kGlobalOptRevins] = kOptRevins,
  [kGlobalOptRuler] = kOptRuler,
  [kGlobalOptRulerformat] = kOptRulerformat,
  [kGlobalOptRuntimepath] = kOptRuntimepath,
  [kGlobalOptScrolljump] = kOptScrolljump,
  [kGlobalOptScrolloff] = kOptScrolloff,
  [kGlobalOptScrollopt] = kOptScrollopt,
  [kGlobalOptSections] = kOptSections,
  [kGlobalOptSecure] = kOptSecure,
  [kGlobalOptSelection] = kOptSelection,
  [kGlobalOptSelectmode] = kOptSelectmode,
  [kGlobalOptSessionoptions] = kOptSessionoptions,
  [kGlobalOptShada] = kOptShada,
  [kGlobalOptShadafile] = kOptShadafile,
  [kGlobalOptShell] = kOptShell,
  [kGlobalOptShellcmdflag] = kOptShellcmdflag,
  [kGlobalOptShellpipe] = kOptShellpipe,
  [kGlobalOptShellquote] = kOptShellquote,
  [kGlobalOptShellredir] = kOptShellredir,
  [kGlobalOptShellslash] = kOptShellslash,
  [kGlobalOptShelltemp] = kOptShelltemp,
  [kGlobalOptShellxescape] = kOptShellxescape,
  [kGlobalOptShellxquote] = kOptShellxquote,
  [kGlobalOptShiftround] = kOptShiftround,
  [kGlobalOptShortmess] = kOptShortmess,
  [kGlobalOptShowbreak] = kOptShowbreak,
  [kGlobalOptShowcmd] = kOptShowcmd,
  [kGlobalOptShowcmdloc] = kOptShowcmdloc,
  [kGlobalOptShowfulltag] = kOptShowfulltag,
  [kGlobalOptShowmatch] = kOptShowmatch,
  [kGlobalOptShowmode] = kOptShowmode,
  [kGlobalOptShowtabline] = kOptShowtabline,
  [kGlobalOptSidescroll] = kOptSidescroll,
  [kGlobalOptSidescrolloff] = kOptSidescrolloff,
  [kGlobalOptSmartcase] = kOptSmartcase,
  [kGlobalOptSmarttab] = kOptSmarttab,
  [kGlobalOptSpellsuggest] = kOptSpellsuggest,
  [kGlobalOptSplitbelow] = kOptSplitbelow,
  [kGlobalOptSplitkeep] = kOptSplitkeep,
  [kGlobalOptSplitright] = kOptSplitright,
  [kGlobalOptStartofline] = kOptStartofline,
  [kGlobalOptStatusline] = kOptStatusline,
  [kGlobalOptSuffixes] = kOptSuffixes,
  [kGlobalOptSwitchbuf] = kOptSwitchbuf,
  [kGlobalOptTabclose] = kOptTabclose,
  [kGlobalOptTabline] = kOptTabline,
  [kGlobalOptTabpagemax] = kOptTabpagemax,
  [kGlobalOptTagbsearch] = kOptTagbsearch,
  [kGlobalOptTagcase] = kOptTagcase,
  [kGlobalOptTaglength] = kOptTaglength,
  [kGlobalOptTagrelative] = kOptTagrelative,
  [kGlobalOptTags] = kOptTags,
  [kGlobalOptTagstack] = kOptTagstack,
  [kGlobalOptTermbidi] = kOptTermbidi,
  [kGlobalOptTermencoding] = kOptTermencoding,
  [kGlobalOptTermguicolors] = kOptTermguicolors,
  [kGlobalOptTermpastefilter] = kOptTermpastefilter,
  [kGlobalOptTermsync] = kOptTermsync,
  [kGlobalOptTerse] = kOptTerse,
  [kGlobalOptThesaurus] = kOptThesaurus,
  [kGlobalOptThesaurusfunc] = kOptThesaurusfunc,
  [kGlobalOptTildeop] = kOptTildeop,
  [kGlobalOptTimeout] = kOptTimeout,
  [kGlobalOptTimeoutlen] = kOptTimeoutlen,
  [kGlobalOptTitle] = kOptTitle,
  [kGlobalOptTitlelen] = kOptTitlelen,
  [kGlobalOptTitleold] = kOptTitleold,
  [kGlobalOptTitlestring] = kOptTitlestring,
  [kGlobalOptTtimeout] = kOptTtimeout,
  [kGlobalOptTtimeoutlen] = kOptTtimeoutlen,
  [kGlobalOptTtyfast] = kOptTtyfast,
  [kGlobalOptUndodir] = kOptUndodir,
  [kGlobalOptUndolevels] = kOptUndolevels,
  [kGlobalOptUndoreload] = kOptUndoreload,
  [kGlobalOptUpdatecount] = kOptUpdatecount,
  [kGlobalOptUpdatetime] = kOptUpdatetime,
  [kGlobalOptVerbose] = kOptVerbose,
  [kGlobalOptVerbosefile] = kOptVerbosefile,
  [kGlobalOptViewdir] = kOptViewdir,
  [kGlobalOptViewoptions] = kOptViewoptions,
  [kGlobalOptVirtualedit] = kOptVirtualedit,
  [kGlobalOptVisualbell] = kOptVisualbell,
  [kGlobalOptWarn] = kOptWarn,
  [kGlobalOptWhichwrap] = kOptWhichwrap,
  [kGlobalOptWildchar] = kOptWildchar,
  [kGlobalOptWildcharm] = kOptWildcharm,
  [kGlobalOptWildignore] = kOptWildignore,
  [kGlobalOptWildignorecase] = kOptWildignorecase,
  [kGlobalOptWildmenu] = kOptWildmenu,
  [kGlobalOptWildmode] = kOptWildmode,
  [kGlobalOptWildoptions] = kOptWildoptions,
  [kGlobalOptWinaltkeys] = kOptWinaltkeys,
  [kGlobalOptWinbar] = kOptWinbar,
  [kGlobalOptWinborder] = kOptWinborder,
  [kGlobalOptWindow] = kOptWindow,
  [kGlobalOptWinheight] = kOptWinheight,
  [kGlobalOptWinminheight] = kOptWinminheight,
  [kGlobalOptWinminwidth] = kOptWinminwidth,
  [kGlobalOptWinwidth] = kOptWinwidth,
  [kGlobalOptWrapscan] = kOptWrapscan,
  [kGlobalOptWrite] = kOptWrite,
  [kGlobalOptWriteany] = kOptWriteany,
  [kGlobalOptWritebackup] = kOptWritebackup,
  [kGlobalOptWritedelay] = kOptWritedelay,
});

EXTERN const OptIndex buf_opt_idx[] INIT( = {
  [kBufOptAutocomplete] = kOptAutocomplete,
  [kBufOptAutoindent] = kOptAutoindent,
  [kBufOptAutoread] = kOptAutoread,
  [kBufOptBackupcopy] = kOptBackupcopy,
  [kBufOptBinary] = kOptBinary,
  [kBufOptBomb] = kOptBomb,
  [kBufOptBufhidden] = kOptBufhidden,
  [kBufOptBuflisted] = kOptBuflisted,
  [kBufOptBuftype] = kOptBuftype,
  [kBufOptBusy] = kOptBusy,
  [kBufOptChannel] = kOptChannel,
  [kBufOptCindent] = kOptCindent,
  [kBufOptCinkeys] = kOptCinkeys,
  [kBufOptCinoptions] = kOptCinoptions,
  [kBufOptCinscopedecls] = kOptCinscopedecls,
  [kBufOptCinwords] = kOptCinwords,
  [kBufOptComments] = kOptComments,
  [kBufOptCommentstring] = kOptCommentstring,
  [kBufOptComplete] = kOptComplete,
  [kBufOptCompletefunc] = kOptCompletefunc,
  [kBufOptCompleteopt] = kOptCompleteopt,
  [kBufOptCompleteslash] = kOptCompleteslash,
  [kBufOptCopyindent] = kOptCopyindent,
  [kBufOptDefine] = kOptDefine,
  [kBufOptDictionary] = kOptDictionary,
  [kBufOptDiffanchors] = kOptDiffanchors,
  [kBufOptEndoffile] = kOptEndoffile,
  [kBufOptEndofline] = kOptEndofline,
  [kBufOptEqualprg] = kOptEqualprg,
  [kBufOptErrorformat] = kOptErrorformat,
  [kBufOptExpandtab] = kOptExpandtab,
  [kBufOptFileencoding] = kOptFileencoding,
  [kBufOptFileformat] = kOptFileformat,
  [kBufOptFiletype] = kOptFiletype,
  [kBufOptFindfunc] = kOptFindfunc,
  [kBufOptFixendofline] = kOptFixendofline,
  [kBufOptFormatexpr] = kOptFormatexpr,
  [kBufOptFormatlistpat] = kOptFormatlistpat,
  [kBufOptFormatoptions] = kOptFormatoptions,
  [kBufOptFormatprg] = kOptFormatprg,
  [kBufOptGrepformat] = kOptGrepformat,
  [kBufOptGrepprg] = kOptGrepprg,
  [kBufOptIminsert] = kOptIminsert,
  [kBufOptImsearch] = kOptImsearch,
  [kBufOptInclude] = kOptInclude,
  [kBufOptIncludeexpr] = kOptIncludeexpr,
  [kBufOptIndentexpr] = kOptIndentexpr,
  [kBufOptIndentkeys] = kOptIndentkeys,
  [kBufOptInfercase] = kOptInfercase,
  [kBufOptIsexpand] = kOptIsexpand,
  [kBufOptIskeyword] = kOptIskeyword,
  [kBufOptKeymap] = kOptKeymap,
  [kBufOptKeywordprg] = kOptKeywordprg,
  [kBufOptLisp] = kOptLisp,
  [kBufOptLispoptions] = kOptLispoptions,
  [kBufOptLispwords] = kOptLispwords,
  [kBufOptMakeencoding] = kOptMakeencoding,
  [kBufOptMakeprg] = kOptMakeprg,
  [kBufOptMatchpairs] = kOptMatchpairs,
  [kBufOptModeline] = kOptModeline,
  [kBufOptModifiable] = kOptModifiable,
  [kBufOptModified] = kOptModified,
  [kBufOptNrformats] = kOptNrformats,
  [kBufOptOmnifunc] = kOptOmnifunc,
  [kBufOptPath] = kOptPath,
  [kBufOptPreserveindent] = kOptPreserveindent,
  [kBufOptQuoteescape] = kOptQuoteescape,
  [kBufOptReadonly] = kOptReadonly,
  [kBufOptScrollback] = kOptScrollback,
  [kBufOptShiftwidth] = kOptShiftwidth,
  [kBufOptSmartindent] = kOptSmartindent,
  [kBufOptSofttabstop] = kOptSofttabstop,
  [kBufOptSpellcapcheck] = kOptSpellcapcheck,
  [kBufOptSpellfile] = kOptSpellfile,
  [kBufOptSpelllang] = kOptSpelllang,
  [kBufOptSpelloptions] = kOptSpelloptions,
  [kBufOptSuffixesadd] = kOptSuffixesadd,
  [kBufOptSwapfile] = kOptSwapfile,
  [kBufOptSynmaxcol] = kOptSynmaxcol,
  [kBufOptSyntax] = kOptSyntax,
  [kBufOptTabstop] = kOptTabstop,
  [kBufOptTagcase] = kOptTagcase,
  [kBufOptTagfunc] = kOptTagfunc,
  [kBufOptTags] = kOptTags,
  [kBufOptTextwidth] = kOptTextwidth,
  [kBufOptThesaurus] = kOptThesaurus,
  [kBufOptThesaurusfunc] = kOptThesaurusfunc,
  [kBufOptUndofile] = kOptUndofile,
  [kBufOptUndolevels] = kOptUndolevels,
  [kBufOptVarsofttabstop] = kOptVarsofttabstop,
  [kBufOptVartabstop] = kOptVartabstop,
  [kBufOptWrapmargin] = kOptWrapmargin,
});

EXTERN const OptIndex win_opt_idx[] INIT( = {
  [kWinOptArabic] = kOptArabic,
  [kWinOptBreakindent] = kOptBreakindent,
  [kWinOptBreakindentopt] = kOptBreakindentopt,
  [kWinOptColorcolumn] = kOptColorcolumn,
  [kWinOptConcealcursor] = kOptConcealcursor,
  [kWinOptConceallevel] = kOptConceallevel,
  [kWinOptCursorbind] = kOptCursorbind,
  [kWinOptCursorcolumn] = kOptCursorcolumn,
  [kWinOptCursorline] = kOptCursorline,
  [kWinOptCursorlineopt] = kOptCursorlineopt,
  [kWinOptDiff] = kOptDiff,
  [kWinOptEventignorewin] = kOptEventignorewin,
  [kWinOptFillchars] = kOptFillchars,
  [kWinOptFoldcolumn] = kOptFoldcolumn,
  [kWinOptFoldenable] = kOptFoldenable,
  [kWinOptFoldexpr] = kOptFoldexpr,
  [kWinOptFoldignore] = kOptFoldignore,
  [kWinOptFoldlevel] = kOptFoldlevel,
  [kWinOptFoldmarker] = kOptFoldmarker,
  [kWinOptFoldmethod] = kOptFoldmethod,
  [kWinOptFoldminlines] = kOptFoldminlines,
  [kWinOptFoldnestmax] = kOptFoldnestmax,
  [kWinOptFoldtext] = kOptFoldtext,
  [kWinOptLhistory] = kOptLhistory,
  [kWinOptLinebreak] = kOptLinebreak,
  [kWinOptList] = kOptList,
  [kWinOptListchars] = kOptListchars,
  [kWinOptNumber] = kOptNumber,
  [kWinOptNumberwidth] = kOptNumberwidth,
  [kWinOptPreviewwindow] = kOptPreviewwindow,
  [kWinOptRelativenumber] = kOptRelativenumber,
  [kWinOptRightleft] = kOptRightleft,
  [kWinOptRightleftcmd] = kOptRightleftcmd,
  [kWinOptScroll] = kOptScroll,
  [kWinOptScrollbind] = kOptScrollbind,
  [kWinOptScrolloff] = kOptScrolloff,
  [kWinOptShowbreak] = kOptShowbreak,
  [kWinOptSidescrolloff] = kOptSidescrolloff,
  [kWinOptSigncolumn] = kOptSigncolumn,
  [kWinOptSmoothscroll] = kOptSmoothscroll,
  [kWinOptSpell] = kOptSpell,
  [kWinOptStatuscolumn] = kOptStatuscolumn,
  [kWinOptStatusline] = kOptStatusline,
  [kWinOptVirtualedit] = kOptVirtualedit,
  [kWinOptWinbar] = kOptWinbar,
  [kWinOptWinblend] = kOptWinblend,
  [kWinOptWinfixbuf] = kOptWinfixbuf,
  [kWinOptWinfixheight] = kOptWinfixheight,
  [kWinOptWinfixwidth] = kOptWinfixwidth,
  [kWinOptWinhighlight] = kOptWinhighlight,
  [kWinOptWrap] = kOptWrap,
});
