static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "ac", .opt_idx = kOptAutocomplete },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "dia", .opt_idx = kOptDiffanchors },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "msc", .opt_idx = kOptMaxsearchcount },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "cfc", .opt_idx = kOptCompletefuzzycollect },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "ise", .opt_idx = kOptIsexpand },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "lhi", .opt_idx = kOptLhistory },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "chi", .opt_idx = kOptChistory },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "acl", .opt_idx = kOptAutocompletedelay },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "cto", .opt_idx = kOptCompletetimeout },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "act", .opt_idx = kOptAutocompletetimeout },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "pmw", .opt_idx = kOptPummaxwidth },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "list", .opt_idx = kOptList },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "busy", .opt_idx = kOptBusy },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "chistory", .opt_idx = kOptChistory },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "isexpand", .opt_idx = kOptIsexpand },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "lhistory", .opt_idx = kOptLhistory },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "pumborder", .opt_idx = kOptPumborder },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "diffanchors", .opt_idx = kOptDiffanchors },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "pummaxwidth", .opt_idx = kOptPummaxwidth },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "autocomplete", .opt_idx = kOptAutocomplete },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "maxsearchcount", .opt_idx = kOptMaxsearchcount },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "completetimeout", .opt_idx = kOptCompletetimeout },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "autocompletedelay", .opt_idx = kOptAutocompletedelay },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
  { .name = "autocompletetimeout", .opt_idx = kOptAutocompletetimeout },
  { .name = "completefuzzycollect", .opt_idx = kOptCompletefuzzycollect },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 17; break;
      case 'd': low = 17; high = 22; break;
      case 'e': low = 22; high = 25; break;
      case 'f': low = 25; high = 31; break;
      case 'g': low = 31; high = 33; break;
      case 'h': low = 33; high = 40; break;
      case 'i': low = 40; high = 49; break;
      case 'j': low = 49; high = 50; break;
      case 'k': low = 50; high = 52; break;
      case 'l': low = 52; high = 59; break;
      case 'm': low = 59; high = 66; break;
      case 'o': low = 66; high = 73; break;
      case 'p': low = 73; high = 81; break;
      case 'r': low = 81; high = 85; break;
      case 's': low = 85; high = 93; break;
      case 't': low = 93; high = 98; break;
      case 'u': low = 98; high = 101; break;
      case 'w': low = 101; high = 107; break;
      case 'x': low = 107; high = 108; break;
      case 'y': low = 108; high = 109; break;
      case 'z': low = 109; high = 110; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 110; high = 115; break;
      case 'b': low = 115; high = 120; break;
      case 'c': low = 120; high = 135; break;
      case 'd': low = 135; high = 143; break;
      case 'e': low = 143; high = 147; break;
      case 'f': low = 147; high = 159; break;
      case 'g': low = 159; high = 162; break;
      case 'h': low = 162; high = 167; break;
      case 'i': low = 167; high = 174; break;
      case 'k': low = 174; high = 179; break;
      case 'l': low = 179; high = 196; break;
      case 'm': low = 196; high = 209; break;
      case 'n': low = 209; high = 215; break;
      case 'o': low = 215; high = 222; break;
      case 'p': low = 222; high = 236; break;
      case 'q': low = 236; high = 238; break;
      case 'r': low = 238; high = 249; break;
      case 's': low = 249; high = 265; break;
      case 't': low = 265; high = 273; break;
      case 'u': low = 273; high = 278; break;
      case 'v': low = 278; high = 279; break;
      case 'w': low = 279; high = 287; break;
      case 'x': low = 287; high = 292; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 292; high = 293; break;
      case 'b': low = 293; high = 295; break;
      case 'c': low = 295; high = 300; break;
      case 'e': low = 300; high = 303; break;
      case 'f': low = 303; high = 306; break;
      case 'h': low = 306; high = 307; break;
      case 'k': low = 307; high = 310; break;
      case 'l': low = 310; high = 311; break;
      case 'n': low = 311; high = 313; break;
      case 'o': low = 313; high = 316; break;
      case 'p': low = 316; high = 321; break;
      case 'r': low = 321; high = 324; break;
      case 's': low = 324; high = 327; break;
      case 't': low = 327; high = 332; break;
      case 'u': low = 332; high = 334; break;
      case 'v': low = 334; high = 335; break;
      case 'w': low = 335; high = 337; break;
      case 'x': low = 337; high = 338; break;
      case 'y': low = 338; high = 339; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 339; high = 340; break;
      case 'b': low = 340; high = 341; break;
      case 'c': low = 341; high = 343; break;
      case 'd': low = 343; high = 344; break;
      case 'e': low = 344; high = 345; break;
      case 'f': low = 345; high = 347; break;
      case 'h': low = 347; high = 348; break;
      case 'l': low = 348; high = 349; break;
      case 'm': low = 349; high = 351; break;
      case 'p': low = 351; high = 352; break;
      case 'r': low = 352; high = 354; break;
      case 's': low = 354; high = 357; break;
      case 't': low = 357; high = 361; break;
      case 'v': low = 361; high = 362; break;
      case 'w': low = 362; high = 365; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 365; high = 366; break;
      case 'c': low = 366; high = 368; break;
      case 'd': low = 368; high = 369; break;
      case 'f': low = 369; high = 371; break;
      case 'h': low = 371; high = 372; break;
      case 'i': low = 372; high = 373; break;
      case 'k': low = 373; high = 374; break;
      case 'l': low = 374; high = 375; break;
      case 'm': low = 375; high = 377; break;
      case 'n': low = 377; high = 381; break;
      case 'o': low = 381; high = 382; break;
      case 'p': low = 382; high = 384; break;
      case 'r': low = 384; high = 385; break;
      case 'u': low = 385; high = 389; break;
      case 'v': low = 389; high = 390; break;
      case 'x': low = 390; high = 391; break;
      case 'y': low = 391; high = 392; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 392; high = 393; break;
      case 'b': low = 393; high = 395; break;
      case 'c': low = 395; high = 396; break;
      case 'd': low = 396; high = 397; break;
      case 'e': low = 397; high = 400; break;
      case 'f': low = 400; high = 403; break;
      case 'g': low = 403; high = 406; break;
      case 'i': low = 406; high = 408; break;
      case 'k': low = 408; high = 409; break;
      case 'l': low = 409; high = 412; break;
      case 'm': low = 412; high = 414; break;
      case 'n': low = 414; high = 418; break;
      case 'o': low = 418; high = 419; break;
      case 'p': low = 419; high = 420; break;
      case 'r': low = 420; high = 421; break;
      case 's': low = 421; high = 425; break;
      case 'y': low = 425; high = 426; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 426; high = 427; break;
      case 'c': low = 427; high = 431; break;
      case 'd': low = 431; high = 432; break;
      case 'e': low = 432; high = 434; break;
      case 'f': low = 434; high = 439; break;
      case 'g': low = 439; high = 440; break;
      case 'h': low = 440; high = 443; break;
      case 'i': low = 443; high = 446; break;
      case 'k': low = 446; high = 447; break;
      case 'l': low = 447; high = 449; break;
      case 'm': low = 449; high = 452; break;
      case 'o': low = 452; high = 453; break;
      case 'p': low = 453; high = 456; break;
      case 'r': low = 456; high = 457; break;
      case 's': low = 457; high = 462; break;
      case 't': low = 462; high = 469; break;
      case 'u': low = 469; high = 470; break;
      case 'w': low = 470; high = 477; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 477; high = 482; break;
      case 'c': low = 482; high = 486; break;
      case 'd': low = 486; high = 489; break;
      case 'e': low = 489; high = 496; break;
      case 'f': low = 496; high = 498; break;
      case 'h': low = 498; high = 502; break;
      case 'i': low = 502; high = 505; break;
      case 'l': low = 505; high = 510; break;
      case 'm': low = 510; high = 514; break;
      case 'n': low = 514; high = 518; break;
      case 'o': low = 518; high = 521; break;
      case 'p': low = 521; high = 524; break;
      case 'r': low = 524; high = 531; break;
      case 's': low = 531; high = 535; break;
      case 't': low = 535; high = 540; break;
      case 'u': low = 540; high = 543; break;
      case 'x': low = 543; high = 544; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 544; high = 551; break;
      case 'b': low = 551; high = 557; break;
      case 'c': low = 557; high = 559; break;
      case 'd': low = 559; high = 564; break;
      case 'e': low = 564; high = 571; break;
      case 'h': low = 571; high = 572; break;
      case 'i': low = 572; high = 578; break;
      case 'j': low = 578; high = 579; break;
      case 'k': low = 579; high = 581; break;
      case 'l': low = 581; high = 588; break;
      case 'm': low = 588; high = 591; break;
      case 'n': low = 591; high = 594; break;
      case 'o': low = 594; high = 598; break;
      case 'r': low = 598; high = 604; break;
      case 's': low = 604; high = 607; break;
      case 't': low = 607; high = 611; break;
      case 'u': low = 611; high = 612; break;
      case 'v': low = 612; high = 614; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 614; high = 618; break;
      case 'b': low = 618; high = 620; break;
      case 'c': low = 620; high = 622; break;
      case 'd': low = 622; high = 623; break;
      case 'e': low = 623; high = 628; break;
      case 'f': low = 628; high = 631; break;
      case 'g': low = 631; high = 632; break;
      case 'i': low = 632; high = 635; break;
      case 'l': low = 635; high = 637; break;
      case 'm': low = 637; high = 638; break;
      case 'n': low = 638; high = 641; break;
      case 'o': low = 641; high = 646; break;
      case 'p': low = 646; high = 651; break;
      case 'r': low = 651; high = 653; break;
      case 's': low = 653; high = 656; break;
      case 't': low = 656; high = 657; break;
      case 'u': low = 657; high = 658; break;
      case 'w': low = 658; high = 659; break;
      case 'x': low = 659; high = 663; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 663; high = 664; break;
      case 'c': low = 664; high = 665; break;
      case 'd': low = 665; high = 667; break;
      case 'e': low = 667; high = 672; break;
      case 'g': low = 672; high = 674; break;
      case 'k': low = 674; high = 675; break;
      case 'l': low = 675; high = 677; break;
      case 'm': low = 677; high = 678; break;
      case 'n': low = 678; high = 682; break;
      case 'o': low = 682; high = 683; break;
      case 'r': low = 683; high = 685; break;
      case 't': low = 685; high = 687; break;
      case 'x': low = 687; high = 689; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 689; high = 690; break;
      case 'b': low = 690; high = 691; break;
      case 'c': low = 691; high = 693; break;
      case 'e': low = 693; high = 696; break;
      case 'm': low = 696; high = 697; break;
      case 'n': low = 697; high = 699; break;
      case 'o': low = 699; high = 700; break;
      case 'r': low = 700; high = 701; break;
      case 't': low = 701; high = 703; break;
      case 'u': low = 703; high = 705; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 705; high = 706; break;
      case 'e': low = 706; high = 707; break;
      case 'f': low = 707; high = 709; break;
      case 'm': low = 709; high = 711; break;
      case 'p': low = 711; high = 712; break;
      case 'r': low = 712; high = 713; break;
      case 's': low = 713; high = 714; break;
      case 'v': low = 714; high = 715; break;
      case 'w': low = 715; high = 716; break;
      default: break;
    }
    break;
    case 15: switch (str[0]) {
      case 'c': low = 716; high = 717; break;
      case 't': low = 717; high = 718; break;
      default: break;
    }
    break;
    case 16: low = 718; high = 719; break;
    case 17: switch (str[0]) {
      case 'a': low = 719; high = 720; break;
      case 'c': low = 720; high = 721; break;
      default: break;
    }
    break;
    case 19: low = 721; high = 722; break;
    case 20: low = 722; high = 723; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


