/* alpm_config.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alpm_config.vala, do not modify */

/*
 *  alpm_config
 *
 *  Copyright (C) 2014-2019 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "alpm.h"
#include "alpm_list.h"
#include <sys/utsname.h>
#include <stdio.h>
#include <gio/gio.h>
#include "alpm_octopi_utils.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _AlpmRepo AlpmRepo;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AlpmConfig AlpmConfig;
#define _alpm_list_free0(var) ((var == NULL) ? NULL : (var = (alpm_list_free (var), NULL)))
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alpm_repo_free0(var) ((var == NULL) ? NULL : (var = (alpm_repo_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AlpmRepo {
	gchar* name;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_db_usage_t usage;
	GList* urls;
};

struct _AlpmConfig {
	gchar* conf_path;
	gchar* rootdir;
	gchar* dbpath;
	gchar* logfile;
	gchar* gpgdir;
	alpm_list_t* architectures;
	gint usesyslog;
	gint checkspace;
	alpm_list_t* cachedirs;
	alpm_list_t* hookdirs;
	alpm_list_t* ignoregroups;
	alpm_list_t* ignorepkgs;
	alpm_list_t* noextracts;
	alpm_list_t* noupgrades;
	alpm_list_t* holdpkgs;
	alpm_list_t* syncfirsts;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t localfilesiglevel;
	alpm_siglevel_t remotefilesiglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_siglevel_t localfilesiglevel_mask;
	alpm_siglevel_t remotefilesiglevel_mask;
	GList* repo_order;
};

VALA_EXTERN void alpm_repo_free (AlpmRepo * self);
static void alpm_repo_instance_init (AlpmRepo * self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN AlpmRepo* alpm_repo_new (const gchar* name);
VALA_EXTERN gint alpm_repo_compare_name (AlpmRepo* a,
                             AlpmRepo* b);
VALA_EXTERN gint alpm_repo_search_name (AlpmRepo* a,
                            const gchar* name);
VALA_EXTERN void alpm_config_free (AlpmConfig * self);
static void alpm_config_instance_init (AlpmConfig * self);
static void _alpm_repo_free0_ (gpointer var);
static inline void _g_list_free__alpm_repo_free0_ (GList* self);
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
static void _g_free_alpm_list_fn_free (gconstpointer a);
VALA_EXTERN void alpm_config_parse_file (AlpmConfig* self,
                             const gchar* path,
                             const gchar* section);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self);
VALA_EXTERN alpm_siglevel_t alpm_config_merge_siglevel (AlpmConfig* self,
                                            alpm_siglevel_t sigbase,
                                            alpm_siglevel_t sigover,
                                            alpm_siglevel_t sigmask);
static gint _alpm_repo_compare_name_gcompare_func (gconstpointer a,
                                            gconstpointer b);
VALA_EXTERN void alpm_config_process_siglevel (AlpmConfig* self,
                                   const gchar* conf_string,
                                   alpm_siglevel_t* siglevel,
                                   alpm_siglevel_t* siglevel_mask);
VALA_EXTERN alpm_db_usage_t alpm_config_define_usage (AlpmConfig* self,
                                          const gchar* conf_string);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_free0_ (gpointer var)
{
#line 26 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	var = (g_free (var), NULL);
#line 132 "alpm_config.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 26 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 140 "alpm_config.c"
}

AlpmRepo*
alpm_repo_new (const gchar* name)
{
	AlpmRepo* self;
	gchar* _tmp0_;
#line 28 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 28 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self = g_slice_new0 (AlpmRepo);
#line 28 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_repo_instance_init (self);
#line 29 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = g_strdup (name);
#line 29 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->name);
#line 29 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->name = _tmp0_;
#line 30 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->siglevel = ALPM_SIG_USE_DEFAULT;
#line 31 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->usage = 0;
#line 32 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	(self->urls == NULL) ? NULL : (self->urls = (_g_list_free__g_free0_ (self->urls), NULL));
#line 32 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->urls = NULL;
#line 28 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return self;
#line 170 "alpm_config.c"
}

gint
alpm_repo_compare_name (AlpmRepo* a,
                        AlpmRepo* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
#line 35 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 35 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 36 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = ((GCompareFunc) g_strcmp0);
#line 36 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = a->name;
#line 36 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp2_ = b->name;
#line 36 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	result = _tmp0_ (_tmp1_, _tmp2_);
#line 36 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 195 "alpm_config.c"
}

gint
alpm_repo_search_name (AlpmRepo* a,
                       const gchar* name)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint result;
#line 39 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 39 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 40 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = ((GCompareFunc) g_strcmp0);
#line 40 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = a->name;
#line 40 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	result = _tmp0_ (_tmp1_, name);
#line 40 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 217 "alpm_config.c"
}

static void
alpm_repo_instance_init (AlpmRepo * self)
{
}

void
alpm_repo_free (AlpmRepo * self)
{
#line 22 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->name);
#line 26 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	(self->urls == NULL) ? NULL : (self->urls = (_g_list_free__g_free0_ (self->urls), NULL));
#line 21 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_slice_free (AlpmRepo, self);
#line 234 "alpm_config.c"
}

static void
_alpm_repo_free0_ (gpointer var)
{
#line 69 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	(var == NULL) ? NULL : (var = (alpm_repo_free (var), NULL));
#line 242 "alpm_config.c"
}

static inline void
_g_list_free__alpm_repo_free0_ (GList* self)
{
#line 69 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_list_free_full (self, (GDestroyNotify) _alpm_repo_free0_);
#line 250 "alpm_config.c"
}

AlpmConfig*
alpm_config_new (const gchar* path)
{
	AlpmConfig* self;
	gchar* _tmp0_;
#line 71 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 71 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self = g_slice_new0 (AlpmConfig);
#line 71 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_config_instance_init (self);
#line 72 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = g_strdup (path);
#line 72 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->conf_path);
#line 72 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->conf_path = _tmp0_;
#line 73 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_config_reload (self);
#line 71 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return self;
#line 274 "alpm_config.c"
}

static void
_g_free_alpm_list_fn_free (gconstpointer a)
{
#line 78 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_free (a);
#line 282 "alpm_config.c"
}

void
alpm_config_reload (AlpmConfig* self)
{
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_list_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* _tmp5_;
	alpm_list_t* _tmp6_;
	alpm_list_t* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	alpm_list_t* _tmp21_;
	alpm_list_t* _tmp22_;
	const gchar* _tmp23_;
	alpm_list_t* _tmp25_;
#line 76 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_if_fail (self != NULL);
#line 78 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = self->cachedirs;
#line 78 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp0_, _g_free_alpm_list_fn_free);
#line 79 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = self->hookdirs;
#line 79 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp1_, _g_free_alpm_list_fn_free);
#line 80 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp2_ = self->ignoregroups;
#line 80 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp2_, _g_free_alpm_list_fn_free);
#line 81 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp3_ = self->ignorepkgs;
#line 81 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp3_, _g_free_alpm_list_fn_free);
#line 82 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp4_ = self->noextracts;
#line 82 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp4_, _g_free_alpm_list_fn_free);
#line 83 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp5_ = self->noupgrades;
#line 83 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp5_, _g_free_alpm_list_fn_free);
#line 84 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp6_ = self->holdpkgs;
#line 84 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp6_, _g_free_alpm_list_fn_free);
#line 85 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp7_ = self->syncfirsts;
#line 85 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_list_free_inner (_tmp7_, _g_free_alpm_list_fn_free);
#line 86 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->usesyslog = 0;
#line 87 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->checkspace = 0;
#line 88 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->siglevel = ((ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL) | ALPM_SIG_DATABASE) | ALPM_SIG_DATABASE_OPTIONAL;
#line 89 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->localfilesiglevel = ALPM_SIG_USE_DEFAULT;
#line 90 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->remotefilesiglevel = ALPM_SIG_USE_DEFAULT;
#line 91 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	(self->repo_order == NULL) ? NULL : (self->repo_order = (_g_list_free__alpm_repo_free0_ (self->repo_order), NULL));
#line 91 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->repo_order = NULL;
#line 93 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp8_ = self->conf_path;
#line 93 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_config_parse_file (self, _tmp8_, NULL);
#line 96 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp9_ = self->rootdir;
#line 96 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (_tmp9_ != NULL) {
#line 358 "alpm_config.c"
		const gchar* _tmp10_;
		const gchar* _tmp13_;
#line 97 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp10_ = self->dbpath;
#line 97 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (_tmp10_ == NULL) {
#line 365 "alpm_config.c"
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 98 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp11_ = self->rootdir;
#line 98 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp12_ = g_build_path ("/", _tmp11_, "var/lib/pacman/", NULL);
#line 98 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (self->dbpath);
#line 98 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			self->dbpath = _tmp12_;
#line 376 "alpm_config.c"
		}
#line 100 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp13_ = self->logfile;
#line 100 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (_tmp13_ == NULL) {
#line 382 "alpm_config.c"
			const gchar* _tmp14_;
			gchar* _tmp15_;
#line 101 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp14_ = self->rootdir;
#line 101 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp15_ = g_build_path ("/", _tmp14_, "var/log/pacman.log", NULL);
#line 101 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (self->logfile);
#line 101 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			self->logfile = _tmp15_;
#line 393 "alpm_config.c"
		}
	} else {
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp19_;
#line 104 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp16_ = g_strdup ("/");
#line 104 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_g_free0 (self->rootdir);
#line 104 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		self->rootdir = _tmp16_;
#line 105 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp17_ = self->dbpath;
#line 105 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (_tmp17_ == NULL) {
#line 409 "alpm_config.c"
			gchar* _tmp18_;
#line 106 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp18_ = g_strdup ("/var/lib/pacman/");
#line 106 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (self->dbpath);
#line 106 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			self->dbpath = _tmp18_;
#line 417 "alpm_config.c"
		}
#line 108 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp19_ = self->logfile;
#line 108 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (_tmp19_ == NULL) {
#line 423 "alpm_config.c"
			gchar* _tmp20_;
#line 109 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp20_ = g_strdup ("/var/log/pacman.log");
#line 109 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (self->logfile);
#line 109 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			self->logfile = _tmp20_;
#line 431 "alpm_config.c"
		}
	}
#line 112 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp21_ = self->cachedirs;
#line 112 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (alpm_list_count (_tmp21_) == ((gsize) 0)) {
#line 113 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		self->cachedirs = alpm_list_add (self->cachedirs, "/var/cache/pacman/pkg/");
#line 440 "alpm_config.c"
	}
#line 115 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp22_ = self->hookdirs;
#line 115 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (alpm_list_count (_tmp22_) == ((gsize) 0)) {
#line 116 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		self->hookdirs = alpm_list_add (self->hookdirs, "/etc/pacman.d/hooks/");
#line 448 "alpm_config.c"
	}
#line 118 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp23_ = self->gpgdir;
#line 118 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (_tmp23_ == NULL) {
#line 454 "alpm_config.c"
		gchar* _tmp24_;
#line 121 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp24_ = g_strdup ("/etc/pacman.d/gnupg/");
#line 121 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_g_free0 (self->gpgdir);
#line 121 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		self->gpgdir = _tmp24_;
#line 462 "alpm_config.c"
	}
#line 123 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp25_ = self->architectures;
#line 123 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (alpm_list_count (_tmp25_) == ((gsize) 0)) {
#line 468 "alpm_config.c"
		struct utsname _tmp26_ = {0};
		const gchar* _tmp27_;
#line 124 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		uname (&_tmp26_);
#line 124 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp27_ = _tmp26_.machine;
#line 124 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		self->architectures = alpm_list_add (self->architectures, _tmp27_);
#line 477 "alpm_config.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 500 "alpm_config.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 504 "alpm_config.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 510 "alpm_config.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 514 "alpm_config.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 518 "alpm_config.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 526 "alpm_config.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 554 "alpm_config.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 563 "alpm_config.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 577 "alpm_config.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 586 "alpm_config.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 600 "alpm_config.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 609 "alpm_config.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 618 "alpm_config.c"
}

alpm_handle_t*
alpm_config_get_handle (AlpmConfig* self)
{
	alpm_errno_t _error_ = 0;
	alpm_handle_t* handle = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	alpm_errno_t _tmp2_ = 0;
	alpm_handle_t* _tmp3_;
	alpm_handle_t* _tmp4_;
	alpm_handle_t* _tmp11_;
	const gchar* _tmp12_;
	alpm_handle_t* _tmp13_;
	const gchar* _tmp14_;
	alpm_handle_t* _tmp15_;
	alpm_list_t* _tmp16_;
	alpm_handle_t* _tmp17_;
	alpm_handle_t* _tmp18_;
	alpm_handle_t* _tmp19_;
	alpm_handle_t* _tmp20_;
	alpm_handle_t* _tmp21_;
	alpm_handle_t* _tmp22_;
	alpm_list_t* _tmp23_;
	alpm_list_t* list = NULL;
	alpm_list_t* _tmp24_;
	alpm_handle_t* _tmp32_;
	alpm_list_t* _tmp33_;
	alpm_handle_t* _tmp34_;
	alpm_list_t* _tmp35_;
	alpm_handle_t* _tmp36_;
	alpm_list_t* _tmp37_;
	alpm_handle_t* _tmp38_;
	alpm_list_t* _tmp39_;
	GList* _tmp40_;
	alpm_handle_t* result;
#line 128 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = self->rootdir;
#line 130 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = self->dbpath;
#line 130 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp3_ = alpm_initialize (_tmp0_, _tmp1_, &_tmp2_);
#line 130 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_error_ = _tmp2_;
#line 130 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	handle = _tmp3_;
#line 131 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp4_ = handle;
#line 131 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (_tmp4_ == NULL) {
#line 672 "alpm_config.c"
		FILE* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp5_ = stderr;
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp6_ = alpm_strerror (_error_);
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp7_ = g_strdup_printf (" (%s)\n", _tmp6_);
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp8_ = _tmp7_;
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp9_ = g_strconcat ("Failed to initialize alpm library", _tmp8_, NULL);
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp10_ = _tmp9_;
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		fprintf (_tmp5_, "%s", _tmp10_);
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_g_free0 (_tmp10_);
#line 132 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_g_free0 (_tmp8_);
#line 133 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		result = NULL;
#line 133 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_alpm_release0 (handle);
#line 133 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		return result;
#line 703 "alpm_config.c"
	}
#line 136 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp11_ = handle;
#line 136 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp12_ = self->logfile;
#line 136 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_logfile (_tmp11_, _tmp12_);
#line 137 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp13_ = handle;
#line 137 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp14_ = self->gpgdir;
#line 137 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_gpgdir (_tmp13_, _tmp14_);
#line 138 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp15_ = handle;
#line 138 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp16_ = self->architectures;
#line 138 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_architectures (_tmp15_, _tmp16_);
#line 139 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp17_ = handle;
#line 139 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_usesyslog (_tmp17_, self->usesyslog);
#line 140 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp18_ = handle;
#line 140 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_checkspace (_tmp18_, self->checkspace);
#line 141 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp19_ = handle;
#line 141 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_default_siglevel (_tmp19_, self->siglevel);
#line 142 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->localfilesiglevel = alpm_config_merge_siglevel (self, self->siglevel, self->localfilesiglevel, self->localfilesiglevel_mask);
#line 143 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	self->remotefilesiglevel = alpm_config_merge_siglevel (self, self->siglevel, self->remotefilesiglevel, self->remotefilesiglevel_mask);
#line 144 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp20_ = handle;
#line 144 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_local_file_siglevel (_tmp20_, self->localfilesiglevel);
#line 145 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp21_ = handle;
#line 145 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_remote_file_siglevel (_tmp21_, self->remotefilesiglevel);
#line 146 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp22_ = handle;
#line 146 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp23_ = self->cachedirs;
#line 146 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_cachedirs (_tmp22_, _tmp23_);
#line 148 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp24_ = self->hookdirs;
#line 148 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	list = _tmp24_;
#line 149 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	while (TRUE) {
#line 759 "alpm_config.c"
		alpm_list_t* _tmp25_;
		const gchar* hookdir = NULL;
		alpm_list_t* _tmp26_;
		gconstpointer _tmp27_;
		alpm_handle_t* _tmp28_;
		const gchar* _tmp29_;
		alpm_list_t* _tmp30_;
		alpm_list_t* _tmp31_;
#line 149 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp25_ = list;
#line 149 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (!(_tmp25_ != NULL)) {
#line 149 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			break;
#line 774 "alpm_config.c"
		}
#line 150 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp26_ = list;
#line 150 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp27_ = _tmp26_->data;
#line 150 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		hookdir = (const gchar*) _tmp27_;
#line 151 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp28_ = handle;
#line 151 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp29_ = hookdir;
#line 151 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		alpm_option_add_hookdir (_tmp28_, _tmp29_);
#line 152 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp30_ = list;
#line 152 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp31_ = _tmp30_->next;
#line 152 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		list = _tmp31_;
#line 794 "alpm_config.c"
	}
#line 154 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp32_ = handle;
#line 154 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp33_ = self->ignoregroups;
#line 154 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_ignoregroups (_tmp32_, _tmp33_);
#line 155 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp34_ = handle;
#line 155 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp35_ = self->ignorepkgs;
#line 155 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_ignorepkgs (_tmp34_, _tmp35_);
#line 156 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp36_ = handle;
#line 156 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp37_ = self->noextracts;
#line 156 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_noextracts (_tmp36_, _tmp37_);
#line 157 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp38_ = handle;
#line 157 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp39_ = self->noupgrades;
#line 157 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	alpm_option_set_noupgrades (_tmp38_, _tmp39_);
#line 159 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp40_ = self->repo_order;
#line 822 "alpm_config.c"
	{
		GList* repo_collection = NULL;
		GList* repo_it = NULL;
#line 159 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		repo_collection = _tmp40_;
#line 159 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		for (repo_it = repo_collection; repo_it != NULL; repo_it = repo_it->next) {
#line 830 "alpm_config.c"
			AlpmRepo* repo = NULL;
#line 159 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			repo = (AlpmRepo*) repo_it->data;
#line 834 "alpm_config.c"
			{
				AlpmRepo* _tmp41_;
				AlpmRepo* _tmp42_;
				AlpmRepo* _tmp43_;
				alpm_db_t* db = NULL;
				alpm_handle_t* _tmp44_;
				AlpmRepo* _tmp45_;
				const gchar* _tmp46_;
				AlpmRepo* _tmp47_;
				alpm_db_t* _tmp48_;
				AlpmRepo* _tmp49_;
				GList* _tmp50_;
				AlpmRepo* _tmp64_;
#line 160 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp41_ = repo;
#line 160 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp42_ = repo;
#line 160 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp43_ = repo;
#line 160 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp41_->siglevel = alpm_config_merge_siglevel (self, self->siglevel, _tmp42_->siglevel, _tmp43_->siglevel_mask);
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp44_ = handle;
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp45_ = repo;
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp46_ = _tmp45_->name;
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp47_ = repo;
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp48_ = alpm_register_syncdb (_tmp44_, _tmp46_, _tmp47_->siglevel);
#line 161 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				db = _tmp48_;
#line 162 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp49_ = repo;
#line 162 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp50_ = _tmp49_->urls;
#line 872 "alpm_config.c"
				{
					GList* url_collection = NULL;
					GList* url_it = NULL;
#line 162 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					url_collection = _tmp50_;
#line 162 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
#line 880 "alpm_config.c"
						const gchar* url = NULL;
#line 162 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						url = (const gchar*) url_it->data;
#line 884 "alpm_config.c"
						{
							alpm_db_t* _tmp51_;
							const gchar* _tmp52_;
							AlpmRepo* _tmp53_;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							alpm_handle_t* _tmp57_;
							alpm_list_t* _tmp58_;
							alpm_list_t* _tmp59_;
							alpm_list_t* _tmp60_;
							gconstpointer _tmp61_;
							gchar* _tmp62_;
							gchar* _tmp63_;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp51_ = db;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp52_ = url;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp53_ = repo;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp54_ = _tmp53_->name;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp55_ = string_replace (_tmp52_, "$repo", _tmp54_);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp56_ = _tmp55_;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp57_ = handle;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp58_ = alpm_option_get_architectures (_tmp57_);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp59_ = _tmp58_;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp60_ = alpm_list_nth (_tmp59_, (gsize) 0);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp61_ = _tmp60_->data;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp62_ = string_replace (_tmp56_, "$arch", (const gchar*) _tmp61_);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp63_ = _tmp62_;
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							alpm_db_add_server (_tmp51_, _tmp63_);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_g_free0 (_tmp63_);
#line 163 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_g_free0 (_tmp56_);
#line 931 "alpm_config.c"
						}
					}
				}
#line 165 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp64_ = repo;
#line 165 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (_tmp64_->usage == 0) {
#line 939 "alpm_config.c"
					alpm_db_t* _tmp65_;
#line 166 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp65_ = db;
#line 166 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					alpm_db_set_usage (_tmp65_, ALPM_DB_USAGE_ALL);
#line 945 "alpm_config.c"
				} else {
					alpm_db_t* _tmp66_;
					AlpmRepo* _tmp67_;
#line 168 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp66_ = db;
#line 168 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp67_ = repo;
#line 168 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					alpm_db_set_usage (_tmp66_, _tmp67_->usage);
#line 955 "alpm_config.c"
				}
			}
		}
	}
#line 171 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	result = handle;
#line 171 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 964 "alpm_config.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 985 "alpm_config.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1002 "alpm_config.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1029 "alpm_config.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1035 "alpm_config.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1041 "alpm_config.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1045 "alpm_config.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1053 "alpm_config.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1057 "alpm_config.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1069 "alpm_config.c"
}

static gint
_alpm_repo_compare_name_gcompare_func (gconstpointer a,
                                       gconstpointer b)
{
	gint result;
	result = alpm_repo_compare_name ((AlpmRepo*) a, (AlpmRepo*) b);
#line 198 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 1080 "alpm_config.c"
}

void
alpm_config_parse_file (AlpmConfig* self,
                        const gchar* path,
                        const gchar* section)
{
	gchar* current_section = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 174 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_if_fail (self != NULL);
#line 174 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_if_fail (path != NULL);
#line 175 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp0_ = g_strdup (section);
#line 175 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	current_section = _tmp0_;
#line 176 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = g_file_new_for_path (path);
#line 176 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	file = _tmp1_;
#line 177 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp2_ = file;
#line 177 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (g_file_query_exists (_tmp2_, NULL)) {
#line 1110 "alpm_config.c"
		{
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp6_;
			gchar* line = NULL;
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp4_ = file;
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp3_ = _tmp5_;
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1126 "alpm_config.c"
				goto __catch0_g_error;
			}
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
#line 181 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			dis = _tmp6_;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			while (TRUE) {
#line 1135 "alpm_config.c"
				gchar* _tmp7_ = NULL;
				GDataInputStream* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** splitted = NULL;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				const gchar* _tmp39_;
				gchar** _tmp40_;
				gchar** _tmp41_;
				const gchar* key = NULL;
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				const gchar* val = NULL;
				gchar** _tmp45_;
				gint _tmp45__length1;
				const gchar* _tmp49_;
				const gchar* _tmp52_;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp8_ = dis;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error0_);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp7_ = _tmp9_;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (line);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_object_unref0 (dis);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_object_unref0 (_tmp3_);
#line 1186 "alpm_config.c"
					goto __catch0_g_error;
				}
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp10_ = _tmp7_;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp7_ = NULL;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_g_free0 (line);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				line = _tmp10_;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp11_ = line;
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (!(_tmp11_ != NULL)) {
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (_tmp7_);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					break;
#line 1205 "alpm_config.c"
				}
#line 185 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp12_ = line;
#line 185 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp13_ = strlen (_tmp12_);
#line 185 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp14_ = _tmp13_;
#line 185 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (_tmp14_ == 0) {
#line 186 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (_tmp7_);
#line 186 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					continue;
#line 1219 "alpm_config.c"
				}
#line 189 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp15_ = line;
#line 189 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "#", 2);
#line 189 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted = _tmp17_;
#line 189 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted_length1 = _vala_array_length (_tmp16_);
#line 189 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_splitted_size_ = splitted_length1;
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp18_ = splitted;
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp18__length1 = splitted_length1;
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp19_ = _tmp18_[0];
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp20_ = string_strip (_tmp19_);
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_g_free0 (line);
#line 190 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				line = _tmp20_;
#line 191 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp21_ = line;
#line 191 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp22_ = strlen (_tmp21_);
#line 191 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp23_ = _tmp22_;
#line 191 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (_tmp23_ == 0) {
#line 192 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
#line 192 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (_tmp7_);
#line 192 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					continue;
#line 1257 "alpm_config.c"
				}
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp25_ = line;
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (string_get (_tmp25_, (glong) 0) == '[') {
#line 1263 "alpm_config.c"
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp26_ = line;
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp27_ = line;
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp28_ = strlen (_tmp27_);
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp29_ = _tmp28_;
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp24_ = string_get (_tmp26_, (glong) (_tmp29_ - 1)) == ']';
#line 1278 "alpm_config.c"
				} else {
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp24_ = FALSE;
#line 1282 "alpm_config.c"
				}
#line 194 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (_tmp24_) {
#line 1286 "alpm_config.c"
					const gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
#line 195 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp30_ = line;
#line 195 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp31_ = string_slice (_tmp30_, (glong) 1, (glong) -1);
#line 195 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (current_section);
#line 195 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					current_section = _tmp31_;
#line 196 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp32_ = current_section;
#line 196 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (g_strcmp0 (_tmp32_, "options") != 0) {
#line 1302 "alpm_config.c"
						AlpmRepo* repo = NULL;
						const gchar* _tmp33_;
						AlpmRepo* _tmp34_;
						GList* _tmp35_;
						AlpmRepo* _tmp36_;
						GList* _tmp37_;
#line 197 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp33_ = current_section;
#line 197 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp34_ = alpm_repo_new (_tmp33_);
#line 197 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						repo = _tmp34_;
#line 198 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp35_ = self->repo_order;
#line 198 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp36_ = repo;
#line 198 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp37_ = g_list_find_custom (_tmp35_, _tmp36_, _alpm_repo_compare_name_gcompare_func);
#line 198 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (_tmp37_ == NULL) {
#line 1323 "alpm_config.c"
							AlpmRepo* _tmp38_;
#line 199 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp38_ = repo;
#line 199 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							repo = NULL;
#line 199 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							self->repo_order = g_list_append (self->repo_order, _tmp38_);
#line 1331 "alpm_config.c"
						}
#line 196 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_alpm_repo_free0 (repo);
#line 1335 "alpm_config.c"
					}
#line 202 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
#line 202 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_g_free0 (_tmp7_);
#line 202 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					continue;
#line 1343 "alpm_config.c"
				}
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp39_ = line;
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, "=", 2);
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted = _tmp41_;
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted_length1 = _vala_array_length (_tmp40_);
#line 204 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_splitted_size_ = splitted_length1;
#line 205 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp42_ = splitted;
#line 205 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp42__length1 = splitted_length1;
#line 205 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp43_ = _tmp42_[0];
#line 205 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp44_ = g_strstrip (_tmp43_);
#line 205 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				key = _tmp44_;
#line 206 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				val = NULL;
#line 207 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp45_ = splitted;
#line 207 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp45__length1 = splitted_length1;
#line 207 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (_tmp45__length1 == 2) {
#line 1375 "alpm_config.c"
					gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
#line 208 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp46_ = splitted;
#line 208 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp46__length1 = splitted_length1;
#line 208 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp47_ = _tmp46_[1];
#line 208 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp48_ = g_strstrip (_tmp47_);
#line 208 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					val = _tmp48_;
#line 1390 "alpm_config.c"
				}
#line 210 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp49_ = key;
#line 210 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (g_strcmp0 (_tmp49_, "Include") == 0) {
#line 1396 "alpm_config.c"
					const gchar* _tmp50_;
					const gchar* _tmp51_;
#line 211 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp50_ = val;
#line 211 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp51_ = current_section;
#line 211 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					alpm_config_parse_file (self, _tmp50_, _tmp51_);
#line 1405 "alpm_config.c"
				}
#line 213 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp52_ = current_section;
#line 213 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (g_strcmp0 (_tmp52_, "options") == 0) {
#line 1411 "alpm_config.c"
					const gchar* _tmp53_;
#line 214 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp53_ = key;
#line 214 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (g_strcmp0 (_tmp53_, "RootDir") == 0) {
#line 1417 "alpm_config.c"
						const gchar* _tmp54_;
						gchar* _tmp55_;
#line 215 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp54_ = val;
#line 215 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp55_ = g_strdup (_tmp54_);
#line 215 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_g_free0 (self->rootdir);
#line 215 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						self->rootdir = _tmp55_;
#line 1428 "alpm_config.c"
					} else {
						const gchar* _tmp56_;
#line 216 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp56_ = key;
#line 216 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (g_strcmp0 (_tmp56_, "DBPath") == 0) {
#line 1435 "alpm_config.c"
							const gchar* _tmp57_;
							gchar* _tmp58_;
#line 217 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp57_ = val;
#line 217 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp58_ = g_strdup (_tmp57_);
#line 217 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_g_free0 (self->dbpath);
#line 217 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							self->dbpath = _tmp58_;
#line 1446 "alpm_config.c"
						} else {
							const gchar* _tmp59_;
#line 218 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp59_ = key;
#line 218 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (g_strcmp0 (_tmp59_, "CacheDir") == 0) {
#line 1453 "alpm_config.c"
								const gchar* _tmp60_;
								gchar** _tmp61_;
								gchar** _tmp62_;
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp60_ = val;
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp62_ = _tmp61_ = g_strsplit (_tmp60_, " ", 0);
#line 1461 "alpm_config.c"
								{
									gchar** dir_collection = NULL;
									gint dir_collection_length1 = 0;
									gint _dir_collection_size_ = 0;
									gint dir_it = 0;
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									dir_collection = _tmp62_;
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									dir_collection_length1 = _vala_array_length (_tmp61_);
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 1473 "alpm_config.c"
										const gchar* dir = NULL;
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										dir = dir_collection[dir_it];
#line 1477 "alpm_config.c"
										{
											const gchar* _tmp63_;
#line 220 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											_tmp63_ = dir;
#line 220 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											self->cachedirs = alpm_list_add (self->cachedirs, _tmp63_);
#line 1484 "alpm_config.c"
										}
									}
#line 219 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1489 "alpm_config.c"
								}
							} else {
								const gchar* _tmp64_;
#line 222 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp64_ = key;
#line 222 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (g_strcmp0 (_tmp64_, "HookDir") == 0) {
#line 1497 "alpm_config.c"
									const gchar* _tmp65_;
									gchar** _tmp66_;
									gchar** _tmp67_;
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp65_ = val;
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp67_ = _tmp66_ = g_strsplit (_tmp65_, " ", 0);
#line 1505 "alpm_config.c"
									{
										gchar** dir_collection = NULL;
										gint dir_collection_length1 = 0;
										gint _dir_collection_size_ = 0;
										gint dir_it = 0;
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										dir_collection = _tmp67_;
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										dir_collection_length1 = _vala_array_length (_tmp66_);
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 1517 "alpm_config.c"
											const gchar* dir = NULL;
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											dir = dir_collection[dir_it];
#line 1521 "alpm_config.c"
											{
												const gchar* _tmp68_;
#line 224 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												_tmp68_ = dir;
#line 224 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												self->hookdirs = alpm_list_add (self->hookdirs, _tmp68_);
#line 1528 "alpm_config.c"
											}
										}
#line 223 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1533 "alpm_config.c"
									}
								} else {
									const gchar* _tmp69_;
#line 226 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp69_ = key;
#line 226 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									if (g_strcmp0 (_tmp69_, "LogFile") == 0) {
#line 1541 "alpm_config.c"
										const gchar* _tmp70_;
										gchar* _tmp71_;
#line 227 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										_tmp70_ = val;
#line 227 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										_tmp71_ = g_strdup (_tmp70_);
#line 227 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										_g_free0 (self->logfile);
#line 227 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										self->logfile = _tmp71_;
#line 1552 "alpm_config.c"
									} else {
										const gchar* _tmp72_;
#line 228 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										_tmp72_ = key;
#line 228 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										if (g_strcmp0 (_tmp72_, "GPGDir") == 0) {
#line 1559 "alpm_config.c"
											const gchar* _tmp73_;
											gchar* _tmp74_;
#line 229 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											_tmp73_ = val;
#line 229 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											_tmp74_ = g_strdup (_tmp73_);
#line 229 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											_g_free0 (self->gpgdir);
#line 229 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											self->gpgdir = _tmp74_;
#line 1570 "alpm_config.c"
										} else {
											const gchar* _tmp75_;
#line 230 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											_tmp75_ = key;
#line 230 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
											if (g_strcmp0 (_tmp75_, "LogFile") == 0) {
#line 1577 "alpm_config.c"
												const gchar* _tmp76_;
												gchar* _tmp77_;
#line 231 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												_tmp76_ = val;
#line 231 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												_tmp77_ = g_strdup (_tmp76_);
#line 231 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												_g_free0 (self->logfile);
#line 231 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												self->logfile = _tmp77_;
#line 1588 "alpm_config.c"
											} else {
												const gchar* _tmp78_;
#line 232 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												_tmp78_ = key;
#line 232 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
												if (g_strcmp0 (_tmp78_, "Architecture") == 0) {
#line 1595 "alpm_config.c"
													const gchar* _tmp79_;
#line 233 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
													_tmp79_ = val;
#line 233 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
													if (g_strcmp0 (_tmp79_, "auto") == 0) {
#line 1601 "alpm_config.c"
														struct utsname _tmp80_ = {0};
														const gchar* _tmp81_;
#line 234 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														uname (&_tmp80_);
#line 234 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														_tmp81_ = _tmp80_.machine;
#line 234 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														self->architectures = alpm_list_add (self->architectures, _tmp81_);
#line 1610 "alpm_config.c"
													} else {
														const gchar* _tmp82_;
#line 236 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														_tmp82_ = val;
#line 236 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														self->architectures = alpm_list_add (self->architectures, _tmp82_);
#line 1617 "alpm_config.c"
													}
												} else {
													const gchar* _tmp83_;
#line 238 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
													_tmp83_ = key;
#line 238 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
													if (g_strcmp0 (_tmp83_, "UseSysLog") == 0) {
#line 239 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														self->usesyslog = 1;
#line 1627 "alpm_config.c"
													} else {
														const gchar* _tmp84_;
#line 240 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														_tmp84_ = key;
#line 240 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
														if (g_strcmp0 (_tmp84_, "CheckSpace") == 0) {
#line 241 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
															self->checkspace = 1;
#line 1636 "alpm_config.c"
														} else {
															const gchar* _tmp85_;
#line 242 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
															_tmp85_ = key;
#line 242 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
															if (g_strcmp0 (_tmp85_, "SigLevel") == 0) {
#line 1643 "alpm_config.c"
																const gchar* _tmp86_;
#line 243 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																_tmp86_ = val;
#line 243 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																alpm_config_process_siglevel (self, _tmp86_, &self->siglevel, &self->siglevel_mask);
#line 1649 "alpm_config.c"
															} else {
																const gchar* _tmp87_;
#line 244 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																_tmp87_ = key;
#line 244 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																if (g_strcmp0 (_tmp87_, "LocalFileSigLevel") == 0) {
#line 1656 "alpm_config.c"
																	const gchar* _tmp88_;
#line 245 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																	_tmp88_ = val;
#line 245 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																	alpm_config_process_siglevel (self, _tmp88_, &self->localfilesiglevel, &self->localfilesiglevel_mask);
#line 1662 "alpm_config.c"
																} else {
																	const gchar* _tmp89_;
#line 246 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																	_tmp89_ = key;
#line 246 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																	if (g_strcmp0 (_tmp89_, "RemoteFileSigLevel") == 0) {
#line 1669 "alpm_config.c"
																		const gchar* _tmp90_;
#line 247 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																		_tmp90_ = val;
#line 247 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																		alpm_config_process_siglevel (self, _tmp90_, &self->remotefilesiglevel, &self->remotefilesiglevel_mask);
#line 1675 "alpm_config.c"
																	} else {
																		const gchar* _tmp91_;
#line 248 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																		_tmp91_ = key;
#line 248 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																		if (g_strcmp0 (_tmp91_, "HoldPkg") == 0) {
#line 1682 "alpm_config.c"
																			const gchar* _tmp92_;
																			gchar** _tmp93_;
																			gchar** _tmp94_;
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																			_tmp92_ = val;
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																			_tmp94_ = _tmp93_ = g_strsplit (_tmp92_, " ", 0);
#line 1690 "alpm_config.c"
																			{
																				gchar** name_collection = NULL;
																				gint name_collection_length1 = 0;
																				gint _name_collection_size_ = 0;
																				gint name_it = 0;
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				name_collection = _tmp94_;
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				name_collection_length1 = _vala_array_length (_tmp93_);
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1702 "alpm_config.c"
																					const gchar* name = NULL;
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					name = name_collection[name_it];
#line 1706 "alpm_config.c"
																					{
																						const gchar* _tmp95_;
#line 250 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						_tmp95_ = name;
#line 250 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						self->holdpkgs = alpm_list_add (self->holdpkgs, _tmp95_);
#line 1713 "alpm_config.c"
																					}
																				}
#line 249 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1718 "alpm_config.c"
																			}
																		} else {
																			const gchar* _tmp96_;
#line 252 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																			_tmp96_ = key;
#line 252 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																			if (g_strcmp0 (_tmp96_, "SyncFirst") == 0) {
#line 1726 "alpm_config.c"
																				const gchar* _tmp97_;
																				gchar** _tmp98_;
																				gchar** _tmp99_;
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				_tmp97_ = val;
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				_tmp99_ = _tmp98_ = g_strsplit (_tmp97_, " ", 0);
#line 1734 "alpm_config.c"
																				{
																					gchar** name_collection = NULL;
																					gint name_collection_length1 = 0;
																					gint _name_collection_size_ = 0;
																					gint name_it = 0;
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					name_collection = _tmp99_;
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					name_collection_length1 = _vala_array_length (_tmp98_);
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1746 "alpm_config.c"
																						const gchar* name = NULL;
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						name = name_collection[name_it];
#line 1750 "alpm_config.c"
																						{
																							const gchar* _tmp100_;
#line 254 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							_tmp100_ = name;
#line 254 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							self->syncfirsts = alpm_list_add (self->syncfirsts, _tmp100_);
#line 1757 "alpm_config.c"
																						}
																					}
#line 253 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1762 "alpm_config.c"
																				}
																			} else {
																				const gchar* _tmp101_;
#line 256 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				_tmp101_ = key;
#line 256 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																				if (g_strcmp0 (_tmp101_, "IgnoreGroup") == 0) {
#line 1770 "alpm_config.c"
																					const gchar* _tmp102_;
																					gchar** _tmp103_;
																					gchar** _tmp104_;
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					_tmp102_ = val;
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					_tmp104_ = _tmp103_ = g_strsplit (_tmp102_, " ", 0);
#line 1778 "alpm_config.c"
																					{
																						gchar** name_collection = NULL;
																						gint name_collection_length1 = 0;
																						gint _name_collection_size_ = 0;
																						gint name_it = 0;
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						name_collection = _tmp104_;
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						name_collection_length1 = _vala_array_length (_tmp103_);
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1790 "alpm_config.c"
																							const gchar* name = NULL;
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							name = name_collection[name_it];
#line 1794 "alpm_config.c"
																							{
																								const gchar* _tmp105_;
#line 258 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								_tmp105_ = name;
#line 258 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								self->ignoregroups = alpm_list_add (self->ignoregroups, _tmp105_);
#line 1801 "alpm_config.c"
																							}
																						}
#line 257 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1806 "alpm_config.c"
																					}
																				} else {
																					const gchar* _tmp106_;
#line 260 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					_tmp106_ = key;
#line 260 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																					if (g_strcmp0 (_tmp106_, "IgnorePkg") == 0) {
#line 1814 "alpm_config.c"
																						const gchar* _tmp107_;
																						gchar** _tmp108_;
																						gchar** _tmp109_;
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						_tmp107_ = val;
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						_tmp109_ = _tmp108_ = g_strsplit (_tmp107_, " ", 0);
#line 1822 "alpm_config.c"
																						{
																							gchar** name_collection = NULL;
																							gint name_collection_length1 = 0;
																							gint _name_collection_size_ = 0;
																							gint name_it = 0;
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							name_collection = _tmp109_;
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							name_collection_length1 = _vala_array_length (_tmp108_);
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1834 "alpm_config.c"
																								const gchar* name = NULL;
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								name = name_collection[name_it];
#line 1838 "alpm_config.c"
																								{
																									const gchar* _tmp110_;
#line 262 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									_tmp110_ = name;
#line 262 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									self->ignorepkgs = alpm_list_add (self->ignorepkgs, _tmp110_);
#line 1845 "alpm_config.c"
																								}
																							}
#line 261 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1850 "alpm_config.c"
																						}
																					} else {
																						const gchar* _tmp111_;
#line 264 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						_tmp111_ = key;
#line 264 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																						if (g_strcmp0 (_tmp111_, "Noextract") == 0) {
#line 1858 "alpm_config.c"
																							const gchar* _tmp112_;
																							gchar** _tmp113_;
																							gchar** _tmp114_;
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							_tmp112_ = val;
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							_tmp114_ = _tmp113_ = g_strsplit (_tmp112_, " ", 0);
#line 1866 "alpm_config.c"
																							{
																								gchar** name_collection = NULL;
																								gint name_collection_length1 = 0;
																								gint _name_collection_size_ = 0;
																								gint name_it = 0;
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								name_collection = _tmp114_;
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								name_collection_length1 = _vala_array_length (_tmp113_);
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1878 "alpm_config.c"
																									const gchar* name = NULL;
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									name = name_collection[name_it];
#line 1882 "alpm_config.c"
																									{
																										const gchar* _tmp115_;
#line 266 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																										_tmp115_ = name;
#line 266 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																										self->noextracts = alpm_list_add (self->noextracts, _tmp115_);
#line 1889 "alpm_config.c"
																									}
																								}
#line 265 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1894 "alpm_config.c"
																							}
																						} else {
																							const gchar* _tmp116_;
#line 268 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							_tmp116_ = key;
#line 268 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																							if (g_strcmp0 (_tmp116_, "NoUpgrade") == 0) {
#line 1902 "alpm_config.c"
																								const gchar* _tmp117_;
																								gchar** _tmp118_;
																								gchar** _tmp119_;
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								_tmp117_ = val;
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																								_tmp119_ = _tmp118_ = g_strsplit (_tmp117_, " ", 0);
#line 1910 "alpm_config.c"
																								{
																									gchar** name_collection = NULL;
																									gint name_collection_length1 = 0;
																									gint _name_collection_size_ = 0;
																									gint name_it = 0;
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									name_collection = _tmp119_;
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									name_collection_length1 = _vala_array_length (_tmp118_);
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
#line 1922 "alpm_config.c"
																										const gchar* name = NULL;
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																										name = name_collection[name_it];
#line 1926 "alpm_config.c"
																										{
																											const gchar* _tmp120_;
#line 270 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																											_tmp120_ = name;
#line 270 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																											self->noupgrades = alpm_list_add (self->noupgrades, _tmp120_);
#line 1933 "alpm_config.c"
																										}
																									}
#line 269 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
																									name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1938 "alpm_config.c"
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					GList* found = NULL;
					GList* _tmp121_;
					const gchar* _tmp122_;
					GList* _tmp123_;
					GList* _tmp124_;
#line 274 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp121_ = self->repo_order;
#line 274 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp122_ = current_section;
#line 274 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp123_ = g_list_find_custom (_tmp121_, _tmp122_, (GCompareFunc) alpm_repo_search_name);
#line 274 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					found = _tmp123_;
#line 275 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp124_ = found;
#line 275 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (_tmp124_ != NULL) {
#line 1977 "alpm_config.c"
						AlpmRepo* repo = NULL;
						GList* _tmp125_;
						gconstpointer _tmp126_;
						const gchar* _tmp127_;
#line 276 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp125_ = found;
#line 276 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp126_ = _tmp125_->data;
#line 276 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						repo = (AlpmRepo*) _tmp126_;
#line 277 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp127_ = key;
#line 277 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (g_strcmp0 (_tmp127_, "Server") == 0) {
#line 1992 "alpm_config.c"
							AlpmRepo* _tmp128_;
							const gchar* _tmp129_;
							gchar* _tmp130_;
#line 278 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp128_ = repo;
#line 278 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp129_ = val;
#line 278 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp130_ = g_strdup (_tmp129_);
#line 278 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp128_->urls = g_list_append (_tmp128_->urls, _tmp130_);
#line 2004 "alpm_config.c"
						} else {
							const gchar* _tmp131_;
#line 279 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp131_ = key;
#line 279 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (g_strcmp0 (_tmp131_, "SigLevel") == 0) {
#line 2011 "alpm_config.c"
								const gchar* _tmp132_;
								AlpmRepo* _tmp133_;
								AlpmRepo* _tmp134_;
#line 280 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp132_ = val;
#line 280 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp133_ = repo;
#line 280 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp134_ = repo;
#line 280 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								alpm_config_process_siglevel (self, _tmp132_, &_tmp133_->siglevel, &_tmp134_->siglevel_mask);
#line 2023 "alpm_config.c"
							} else {
								const gchar* _tmp135_;
#line 281 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp135_ = key;
#line 281 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (g_strcmp0 (_tmp135_, "Usage") == 0) {
#line 2030 "alpm_config.c"
									AlpmRepo* _tmp136_;
									const gchar* _tmp137_;
#line 282 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp136_ = repo;
#line 282 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp137_ = val;
#line 282 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp136_->usage = alpm_config_define_usage (self, _tmp137_);
#line 2039 "alpm_config.c"
								}
							}
						}
					}
				}
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
#line 184 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_g_free0 (_tmp7_);
#line 2049 "alpm_config.c"
			}
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (line);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_object_unref0 (dis);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_object_unref0 (_tmp3_);
#line 2057 "alpm_config.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp138_;
			GError* _tmp139_;
			const gchar* _tmp140_;
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			e = _inner_error0_;
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_inner_error0_ = NULL;
#line 288 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp138_ = stderr;
#line 288 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp139_ = e;
#line 288 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_tmp140_ = _tmp139_->message;
#line 288 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			fprintf (_tmp138_, "%s\n", _tmp140_);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_error_free0 (e);
#line 2080 "alpm_config.c"
		}
		__finally0:
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_object_unref0 (file);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			_g_free0 (current_section);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			g_clear_error (&_inner_error0_);
#line 178 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			return;
#line 2095 "alpm_config.c"
		}
	} else {
		FILE* _tmp141_;
#line 291 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp141_ = stderr;
#line 291 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		fprintf (_tmp141_, "File '%s' doesn't exist.\n", path);
#line 2103 "alpm_config.c"
	}
#line 174 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_object_unref0 (file);
#line 174 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (current_section);
#line 2109 "alpm_config.c"
}

alpm_db_usage_t
alpm_config_define_usage (AlpmConfig* self,
                          const gchar* conf_string)
{
	alpm_db_usage_t usage = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	alpm_db_usage_t result;
#line 354 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 354 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (conf_string != NULL, 0);
#line 355 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	usage = 0;
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = _tmp0_ = g_strsplit (conf_string, " ", 0);
#line 2128 "alpm_config.c"
	{
		gchar** directive_collection = NULL;
		gint directive_collection_length1 = 0;
		gint _directive_collection_size_ = 0;
		gint directive_it = 0;
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection = _tmp1_;
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection_length1 = _vala_array_length (_tmp0_);
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		for (directive_it = 0; directive_it < directive_collection_length1; directive_it = directive_it + 1) {
#line 2140 "alpm_config.c"
			const gchar* directive = NULL;
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			directive = directive_collection[directive_it];
#line 2144 "alpm_config.c"
			{
				const gchar* _tmp2_;
#line 357 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp2_ = directive;
#line 357 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (g_strcmp0 (_tmp2_, "Sync") == 0) {
#line 358 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					usage |= ALPM_DB_USAGE_SYNC;
#line 2153 "alpm_config.c"
				} else {
					const gchar* _tmp3_;
#line 359 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp3_ = directive;
#line 359 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (g_strcmp0 (_tmp3_, "Search") == 0) {
#line 360 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						usage |= ALPM_DB_USAGE_SEARCH;
#line 2162 "alpm_config.c"
					} else {
						const gchar* _tmp4_;
#line 361 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp4_ = directive;
#line 361 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (g_strcmp0 (_tmp4_, "Install") == 0) {
#line 362 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							usage |= ALPM_DB_USAGE_INSTALL;
#line 2171 "alpm_config.c"
						} else {
							const gchar* _tmp5_;
#line 363 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp5_ = directive;
#line 363 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (g_strcmp0 (_tmp5_, "Upgrade") == 0) {
#line 364 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								usage |= ALPM_DB_USAGE_UPGRADE;
#line 2180 "alpm_config.c"
							} else {
								const gchar* _tmp6_;
#line 365 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp6_ = directive;
#line 365 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (g_strcmp0 (_tmp6_, "All") == 0) {
#line 366 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									usage |= ALPM_DB_USAGE_ALL;
#line 2189 "alpm_config.c"
								}
							}
						}
					}
				}
			}
		}
#line 356 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection = (_vala_array_free (directive_collection, directive_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2199 "alpm_config.c"
	}
#line 369 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	result = usage;
#line 369 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 2205 "alpm_config.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 2224 "alpm_config.c"
}

void
alpm_config_process_siglevel (AlpmConfig* self,
                              const gchar* conf_string,
                              alpm_siglevel_t* siglevel,
                              alpm_siglevel_t* siglevel_mask)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
#line 372 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_if_fail (self != NULL);
#line 372 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_if_fail (conf_string != NULL);
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_tmp1_ = _tmp0_ = g_strsplit (conf_string, " ", 0);
#line 2241 "alpm_config.c"
	{
		gchar** directive_collection = NULL;
		gint directive_collection_length1 = 0;
		gint _directive_collection_size_ = 0;
		gint directive_it = 0;
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection = _tmp1_;
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection_length1 = _vala_array_length (_tmp0_);
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		for (directive_it = 0; directive_it < directive_collection_length1; directive_it = directive_it + 1) {
#line 2253 "alpm_config.c"
			const gchar* directive = NULL;
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
			directive = directive_collection[directive_it];
#line 2257 "alpm_config.c"
			{
				gboolean affect_package = FALSE;
				gboolean affect_database = FALSE;
				const gchar* _tmp2_;
				const gchar* _tmp4_;
#line 374 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				affect_package = FALSE;
#line 375 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				affect_database = FALSE;
#line 376 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp2_ = directive;
#line 376 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (string_contains (_tmp2_, "Package")) {
#line 377 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					affect_package = TRUE;
#line 2273 "alpm_config.c"
				} else {
					const gchar* _tmp3_;
#line 378 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp3_ = directive;
#line 378 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (string_contains (_tmp3_, "Database")) {
#line 379 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						affect_database = TRUE;
#line 2282 "alpm_config.c"
					} else {
#line 381 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						affect_package = TRUE;
#line 382 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						affect_database = TRUE;
#line 2288 "alpm_config.c"
					}
				}
#line 384 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				_tmp4_ = directive;
#line 384 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
				if (string_contains (_tmp4_, "Never")) {
#line 385 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (affect_package) {
#line 386 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						*siglevel = (*siglevel) & (~ALPM_SIG_PACKAGE);
#line 387 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE;
#line 2301 "alpm_config.c"
					}
#line 389 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (affect_database) {
#line 390 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						*siglevel = (*siglevel) & (~ALPM_SIG_DATABASE);
#line 391 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE;
#line 2309 "alpm_config.c"
					}
				} else {
					const gchar* _tmp5_;
#line 393 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					_tmp5_ = directive;
#line 393 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
					if (string_contains (_tmp5_, "Optional")) {
#line 394 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (affect_package) {
#line 395 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							*siglevel = (*siglevel) | (ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL);
#line 396 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL);
#line 2323 "alpm_config.c"
						}
#line 398 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (affect_database) {
#line 399 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							*siglevel = (*siglevel) | (ALPM_SIG_DATABASE | ALPM_SIG_DATABASE_OPTIONAL);
#line 400 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE | ALPM_SIG_DATABASE_OPTIONAL);
#line 2331 "alpm_config.c"
						}
					} else {
						const gchar* _tmp6_;
#line 402 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						_tmp6_ = directive;
#line 402 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
						if (string_contains (_tmp6_, "Required")) {
#line 403 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (affect_package) {
#line 404 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel = (*siglevel) | ALPM_SIG_PACKAGE;
#line 405 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE;
#line 406 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel = (*siglevel) & (~ALPM_SIG_PACKAGE_OPTIONAL);
#line 407 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE_OPTIONAL;
#line 2349 "alpm_config.c"
							}
#line 409 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (affect_database) {
#line 410 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel = (*siglevel) | ALPM_SIG_DATABASE;
#line 411 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE;
#line 412 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel = (*siglevel) & (~ALPM_SIG_DATABASE_OPTIONAL);
#line 413 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE_OPTIONAL;
#line 2361 "alpm_config.c"
							}
						} else {
							const gchar* _tmp7_;
#line 415 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							_tmp7_ = directive;
#line 415 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
							if (string_contains (_tmp7_, "TrustedOnly")) {
#line 416 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (affect_package) {
#line 417 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									*siglevel = (*siglevel) & (~(ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK));
#line 418 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
#line 2375 "alpm_config.c"
								}
#line 420 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (affect_database) {
#line 421 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									*siglevel = (*siglevel) & (~(ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK));
#line 422 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
#line 2383 "alpm_config.c"
								}
							} else {
								const gchar* _tmp8_;
#line 424 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								_tmp8_ = directive;
#line 424 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
								if (string_contains (_tmp8_, "TrustAll")) {
#line 425 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									if (affect_package) {
#line 426 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										*siglevel = (*siglevel) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
#line 427 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
#line 2397 "alpm_config.c"
									}
#line 429 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									if (affect_database) {
#line 430 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										*siglevel = (*siglevel) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
#line 431 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
										*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
#line 2405 "alpm_config.c"
									}
								} else {
									FILE* _tmp9_;
#line 434 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									_tmp9_ = stderr;
#line 434 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
									fprintf (_tmp9_, "unrecognized siglevel: %s\n", conf_string);
#line 2413 "alpm_config.c"
								}
							}
						}
					}
				}
			}
		}
#line 373 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		directive_collection = (_vala_array_free (directive_collection, directive_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2423 "alpm_config.c"
	}
#line 437 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	*siglevel = (*siglevel) & (~ALPM_SIG_USE_DEFAULT);
#line 2427 "alpm_config.c"
}

alpm_siglevel_t
alpm_config_merge_siglevel (AlpmConfig* self,
                            alpm_siglevel_t sigbase,
                            alpm_siglevel_t sigover,
                            alpm_siglevel_t sigmask)
{
	alpm_siglevel_t _tmp0_ = 0;
	alpm_siglevel_t result;
#line 440 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 441 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	if (sigmask != 0) {
#line 441 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp0_ = (sigover & sigmask) | (sigbase & (~sigmask));
#line 2444 "alpm_config.c"
	} else {
#line 441 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
		_tmp0_ = sigover;
#line 2448 "alpm_config.c"
	}
#line 441 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	result = _tmp0_;
#line 441 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	return result;
#line 2454 "alpm_config.c"
}

static void
alpm_config_instance_init (AlpmConfig * self)
{
}

void
alpm_config_free (AlpmConfig * self)
{
#line 47 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->conf_path);
#line 48 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->rootdir);
#line 49 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->dbpath);
#line 50 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->logfile);
#line 51 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_g_free0 (self->gpgdir);
#line 52 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->architectures);
#line 55 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->cachedirs);
#line 56 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->hookdirs);
#line 57 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->ignoregroups);
#line 58 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->ignorepkgs);
#line 59 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->noextracts);
#line 60 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->noupgrades);
#line 61 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->holdpkgs);
#line 62 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	_alpm_list_free0 (self->syncfirsts);
#line 69 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	(self->repo_order == NULL) ? NULL : (self->repo_order = (_g_list_free__alpm_repo_free0_ (self->repo_order), NULL));
#line 46 "/var/lib/jenkins/workspace/Archlinux/jjgaming-aur/x86_64/CharityBuilds/TopVotedPackages/octopi/src/alpm_octopi_utils/src/alpm_config.vala"
	g_slice_free (AlpmConfig, self);
#line 2497 "alpm_config.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

