# type: ignore
from __future__ import annotations
import collections.abc
import openvino._pyopenvino.op
import typing
"""
openvino._offline_transformations is a private module contains different offline passes.
"""
__all__: list[str] = ['apply_fused_names_cleanup', 'apply_low_latency_transformation', 'apply_make_stateful_transformation', 'apply_moc_legacy_transformations', 'apply_moc_transformations', 'apply_pruning_transformation', 'compress_model_transformation', 'compress_quantize_weights_transformation', 'convert_sequence_to_tensor_iterator_transformation', 'paged_attention_transformation', 'stateful_to_stateless_transformation']
def apply_fused_names_cleanup(model: typing.Any) -> None:
    ...
def apply_low_latency_transformation(model: typing.Any, use_const_initializer: bool = True) -> None:
    ...
@typing.overload
def apply_make_stateful_transformation(model: typing.Any, param_res_names: collections.abc.Mapping[str, str]) -> None:
    ...
@typing.overload
def apply_make_stateful_transformation(model: typing.Any, pairs_to_replace: collections.abc.Sequence[tuple[openvino._pyopenvino.op.Parameter, openvino._pyopenvino.op.Result]]) -> None:
    ...
def apply_moc_legacy_transformations(model: typing.Any, params_with_custom_types: collections.abc.Sequence[str]) -> None:
    ...
def apply_moc_transformations(model: typing.Any, cf: bool, smart_reshape: bool = False) -> None:
    ...
def apply_pruning_transformation(model: typing.Any) -> None:
    ...
def compress_model_transformation(model: typing.Any) -> None:
    ...
def compress_quantize_weights_transformation(model: typing.Any) -> None:
    ...
def convert_sequence_to_tensor_iterator_transformation(model: typing.Any) -> None:
    ...
def paged_attention_transformation(model: typing.Any, use_block_indices_inputs: bool = False, use_score_outputs: bool = False, allow_score_aggregation: bool = False, allow_cache_rotation: bool = False, allow_xattention: bool = False) -> None:
    ...
def stateful_to_stateless_transformation(model: typing.Any) -> None:
    ...
