"""
This file contains the layout for multimedia keys.
"""

#: The multimedia keys layout
layout = {
    "Mute": 0xE2,
    "Next": 0xB5,
    "PlayPause": 0xCD,
    "Previous": 0xB6,
    "VolumeUp": 0xE9,
    "VolumeDown": 0xEA,
}

#: Alias for some keys of the layout
aliases = {
    "play": "PlayPause",
    "pause": "PlayPause",
    "prev": "Previous",
    "volup": "VolumeUp",
    "volume+": "VolumeUp",
    "vol+": "VolumeUp",
    "volumeplus": "VolumeUp",
    "volplus": "VolumeUp",
    "voldown": "VolumeDown",
    "voldwn": "VolumeDown",
    "voldn": "VolumeDown",
    "volume-": "VolumeDown",
    "vol-": "VolumeDown",
    "volumeminus": "VolumeDown",
    "volminus": "VolumeDown",
}
