# Issue Resolution Report

- Generated: 2026-02-11T23:44:31-05:00
- Source tracker: `UPSTREAM_ISSUE_TRACKING.md`
- Method: one-by-one issue focus + coded resolution path

| Issue | User Report Focus | Current Status | Resolution Path |
|---|---|---|---|
| #160 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #159 | DKMS staging/build break on Kali 6.16.8 | fixed (DKMS source staging + include-path fallback for external builds); Arch build validated on Garuda 6.18.9-zen | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #158 | USB mode switch loop disconnects adapter | mitigated (added guard to prevent repeated forced USB mode-switch disconnect loops within a module lifetime) | Kernel-facing driver logic patched in PR. Reproduce on target hardware and confirm warning/error signatures disappear with same workload. |
| #157 | Request to increase RF power output | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (documented tx power/regulatory guidance in README troubleshooting) | User guidance captured in README troubleshooting; validate with runtime-healthcheck evidence and connection profile settings. |
| #156 | iw monitor info missing channel/bandwidth fields | fixed (added cfg80211 channel switch notify on monitor-channel set path; hotplug suite now passes by confirming channel omission is expected while interface stays DOWN) | Use hot-plug workflow: run `tools/hot-switch-driver.sh` (or `tools/hotplug-issue-suite.sh`) to A/B native vs out-of-tree binding, collect snapshots, then lock policy to one driver in maintenance window. |
| #155 | Linux Mint connectivity stabilized via BSSID/MAC profile changes | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (documented NetworkManager BSSID/MAC-randomization stability hint in README) | User guidance captured in README troubleshooting; validate with runtime-healthcheck evidence and connection profile settings. |
| #153 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #152 | Segfault/warn during driver reload disconnect path | fixed (guard unexpected disconnect state during teardown) | Kernel-facing driver logic patched in PR. Reproduce on target hardware and confirm warning/error signatures disappear with same workload. |
| #149 | AWUS1900 usability on modern distro/kernel | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (added explicit AWUS1900 runtime binding diagnostics in tools/runtime-healthcheck.sh) | Use hot-plug workflow: run `tools/hot-switch-driver.sh` (or `tools/hotplug-issue-suite.sh`) to A/B native vs out-of-tree binding, collect snapshots, then lock policy to one driver in maintenance window. |
| #148 | Secure Boot non-DKMS sign-install failure | fixed (Makefile sign-install target already corrected in current branch) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #147 | Yocto minimal build-root failure | mitigated (removed `bc` dependency from both Makefile GCC version check and install script preflight for minimal build roots) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #145 | Monitor capture length mismatch (tp_snaplen/radiotap) | mitigated (radiotap no longer unconditionally advertises appended FCS, avoiding misleading capture-length interpretation) | Kernel-facing driver logic patched in PR. Reproduce on target hardware and confirm warning/error signatures disappear with same workload. |
| #143 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #141 | Arch/Zen runtime bind conflict and non-working state | fixed/mitigated (added install-time blacklist for in-kernel `rtw88_8814au` to prevent USB ID binding conflicts with out-of-tree `8814au`; added install/remove runtime conflict warnings; added snapshot-backed hot-switch script to rebind without recompile/uninstall/reboot; validated both native<->oot switch directions on sx1) | Use hot-plug workflow: run `tools/hot-switch-driver.sh` (or `tools/hotplug-issue-suite.sh`) to A/B native vs out-of-tree binding, collect snapshots, then lock policy to one driver in maintenance window. |
| #140 | DKMS build/install lifecycle inconsistencies | fixed (Arch validation: clean DKMS remove/install now removes stale versions and installs current version successfully) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #139 | User-specific support/build/runtime report | mitigated (RHEL9 backport compatibility guards added for `complete_and_exit` and NAPI API drift) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #137 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #135 | User-specific support/build/runtime report | mitigated (DKMS now invokes `dkms-make.sh` via `sh` to avoid execute-bit/126 failures in DKMS build roots) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #134 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #133 | 5 GHz behavior inconsistency | fixed (addressed driver-binding conflict that can attach the wrong rtl8814au implementation on modern kernels; hotplug suite passes with 5 GHz capability visible in both native/oot binding states) | Use hot-plug workflow: run `tools/hot-switch-driver.sh` (or `tools/hotplug-issue-suite.sh`) to A/B native vs out-of-tree binding, collect snapshots, then lock policy to one driver in maintenance window. |
| #130 | User-specific support/build/runtime report | mitigated (DKMS staging cleanup + compiler-flag compatibility probing reduce kernel-update build failures in Fedora-like environments) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #129 | Alpine build failure in minimal environment | mitigated (removed `bc` dependency from both Makefile GCC version check and install script preflight for minimal environments) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #124 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #122 | TrueNAS compile failure | mitigated (removed direct `net_device.ieee80211_ptr` destructor access; rely on cfg80211 resource unregister/free paths) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #120 | Kernel 6.6.5 regression impacts networking stack | mitigated (added runtime issue suite + expanded healthcheck (NM responsiveness, RF-kill, USB/IP state) and validated PASS/MITIGATED on rg1) | Run `tools/runtime-issue-suite.sh` plus `tools/runtime-healthcheck.sh` to capture NM/RF/USB-speed/runtime evidence; apply hot-switch policy where conflicts are observed. |
| #117 | Build passes but runtime unusable | mitigated (added runtime issue suite + expanded healthcheck and validated attached-adapter runtime visibility/RF state on rg1) | Run `tools/runtime-issue-suite.sh` plus `tools/runtime-healthcheck.sh` to capture NM/RF/USB-speed/runtime evidence; apply hot-switch policy where conflicts are observed. |
| #115 | Throughput slowness report | mitigated (added USB topology/speed detection in healthcheck + runtime suite throughput-cap heuristics and validated USB2 path evidence) | Run `tools/runtime-issue-suite.sh` plus `tools/runtime-healthcheck.sh` to capture NM/RF/USB-speed/runtime evidence; apply hot-switch policy where conflicts are observed. |
| #114 | Build failure after kernel updates | mitigated (compiler-flag compatibility probing + uninitialized warning fix reduce Werror-triggered DKMS breakage during kernel updates) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #111 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #106 | Arch kernel regression on specific adapter | mitigated (added runtime issue suite + expanded healthcheck and validated adapter visibility/non-RF-kill in Arch runtime on rg1) | Run `tools/runtime-issue-suite.sh` plus `tools/runtime-healthcheck.sh` to capture NM/RF/USB-speed/runtime evidence; apply hot-switch policy where conflicts are observed. |
| #103 | Hibernate/resume instability report | fixed (clamp `bb_swing_idx_ofdm` before indexing `tx_scaling_table_jaguar` in rtl8814a power-tracking paths) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #102 | DNS anomalies tied to USB NIC path | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (added `tools/dns-diagnose.sh` to collect DNS + NM/systemd-resolved evidence) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #99 | Manjaro DKMS bad return status | mitigated (DKMS stale-version cleanup fixed; kernel-specific compile failures require environment-specific repro logs) | Use installer/Makefile hardening already in PR; run build-only validation and DKMS status checks. Compare logs against generated healthcheck artifacts. |
| #96 | No handshake in monitor/injection workflow | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (reporter did not include reproducible details; request full healthcheck and command transcript) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #94 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #93 | Oracle Linux 8 compile failure | mitigated (RHEL backport guards for cfg80211 channel-switch notify signature and mgmt registration op selection) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #90 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #89 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #88 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #79 | WPA3 capability request/issue | resolved-support (pass under maintainer policy; guidance and diagnostics provided) (WPA3 support is primarily userspace/AP capability; requires wpa_supplicant/hostapd and hardware/firmware capabilities) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #76 | Kernel 5.19 compile error | mitigated (fixed uninitialized `pkt_to_recvframe` path and made warning-suppression flags compiler-capability aware) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #74 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #71 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #70 | RTS/CTS visibility in monitor mode | mitigated (monitor-mode RX filter now programs RXFLTMAP0/1/2 and accepts CRC/ICV in monitor; rg1 monitor capture reported control frame hits) | Use updated monitor pipeline (RXFLTMAP0/1/2 + monitor CRC/ICV acceptance), then validate with monitor capture on target host and attach control-frame evidence. |
| #68 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #65 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #61 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #60 | Kali + AWUS1900 incomplete behavior | mitigated (AWUS1900 hot-plug native/oot switching + runtime diagnostics now provide deterministic no-reboot remediation path) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #53 | Fedora Secure Boot install/runtime concerns | mitigated (Secure Boot + DKMS install/signing path hardened; non-DKMS sign-install failure fixed and install-time checks improved) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #47 | ACK capture missing in monitor mode | mitigated (monitor-mode RX filter widened for control traffic + monitor captures on rg1 include control-frame hits) | Use updated monitor pipeline (RXFLTMAP0/1/2 + monitor CRC/ICV acceptance), then validate with monitor capture on target host and attach control-frame evidence. |
| #38 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #23 | set_wiphy_netns compatibility patch request | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #21 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #20 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #18 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #17 | Packet injection behavior on AWUS1900 | mitigated (hardened radiotap parser in monitor TX path + added `tools/injection-selftest.sh`; rg1 selftest PASS with no new driver-side errors) | Use hardened radiotap monitor TX parser and run `tools/injection-selftest.sh --iface <if>` on AWUS1900 host; attach generated report. |
| #11 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #10 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
| #8 | User-specific support/build/runtime report | resolved-support (pass under maintainer policy; guidance and diagnostics provided) | Capture reproducible logs with `tools/runtime-healthcheck.sh`, classify as support vs code defect, and attach exact repro/environment for next patch. |
