//  SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
//  SPDX-License-Identifier: GPL-2.0-or-later

// Credits to https://github.com/psucien/tlg-emu-tools/

#include "common/types.h"
#include "gcn/si_ci_vi_merged_offset.h"

using namespace Pal::Gfx6;

namespace Core::Devtools::Gcn {
const char* GetContextRegName(u32 reg_offset) {
    switch (reg_offset) {
    case mmDB_SHADER_CONTROL:
        return "mmDB_SHADER_CONTROL";
    case mmCB_SHADER_MASK:
        return "mmCB_SHADER_MASK";
    case mmPA_CL_CLIP_CNTL:
        return "mmPA_CL_CLIP_CNTL";
    case mmVGT_INSTANCE_STEP_RATE_0:
        return "mmVGT_INSTANCE_STEP_RATE_0";
    case mmVGT_INSTANCE_STEP_RATE_1:
        return "mmVGT_INSTANCE_STEP_RATE_1";
    case mmVGT_INDX_OFFSET:
        return "mmVGT_INDX_OFFSET";
    case mmVGT_SHADER_STAGES_EN:
        return "mmVGT_SHADER_STAGES_EN";
    case mmVGT_GS_MODE:
        return "mmVGT_GS_MODE";
    case mmVGT_STRMOUT_CONFIG:
        return "mmVGT_STRMOUT_CONFIG";
    case mmVGT_OUT_DEALLOC_CNTL:
        return "mmVGT_OUT_DEALLOC_CNTL";
    case mmVGT_VTX_CNT_EN:
        return "mmVGT_VTX_CNT_EN";
    case mmVGT_MAX_VTX_INDX:
        return "mmVGT_MAX_VTX_INDX";
    case mmVGT_MULTI_PRIM_IB_RESET_INDX:
        return "mmVGT_MULTI_PRIM_IB_RESET_INDX";
    case mmVGT_OUTPUT_PATH_CNTL:
        return "mmVGT_OUTPUT_PATH_CNTL";
    case mmVGT_GS_PER_ES:
        return "mmVGT_GS_PER_ES";
    case mmVGT_ES_PER_GS:
        return "mmVGT_ES_PER_GS";
    case mmVGT_GS_PER_VS:
        return "mmVGT_GS_PER_VS";
    case mmCB_COLOR0_BASE:
        return "mmCB_COLOR0_BASE";
    case mmCB_COLOR0_INFO:
        return "mmCB_COLOR0_INFO";
    case mmCB_COLOR0_CMASK_SLICE:
        return "mmCB_COLOR0_CMASK_SLICE";
    case mmCB_COLOR0_CLEAR_WORD0:
        return "mmCB_COLOR0_CLEAR_WORD0";
    case mmCB_COLOR0_CLEAR_WORD1:
        return "mmCB_COLOR0_CLEAR_WORD1";
    case mmCB_COLOR0_PITCH:
        return "mmCB_COLOR0_PITCH";
    case mmCB_COLOR0_SLICE:
        return "mmCB_COLOR0_SLICE";
    case mmCB_COLOR0_VIEW:
        return "mmCB_COLOR0_VIEW";
    case mmCB_COLOR0_DCC_CONTROL__VI:
        return "mmCB_COLOR0_DCC_CONTROL";
    case mmCB_COLOR0_CMASK:
        return "mmCB_COLOR0_CMASK";
    case mmCB_COLOR0_FMASK_SLICE:
        return "mmCB_COLOR0_FMASK_SLICE";
    case mmCB_COLOR0_FMASK:
        return "mmCB_COLOR0_FMASK";
    case mmCB_COLOR0_DCC_BASE__VI:
        return "mmCB_COLOR0_DCC_BASE";
    case mmCB_COLOR0_ATTRIB:
        return "mmCB_COLOR0_ATTRIB";
    case mmCB_COLOR1_BASE:
        return "mmCB_COLOR1_BASE";
    case mmCB_COLOR1_INFO:
        return "mmCB_COLOR1_INFO";
    case mmCB_COLOR1_ATTRIB:
        return "mmCB_COLOR1_ATTRIB";
    case mmCB_COLOR1_CMASK_SLICE:
        return "mmCB_COLOR1_CMASK_SLICE";
    case mmCB_COLOR1_CLEAR_WORD0:
        return "mmCB_COLOR1_CLEAR_WORD0";
    case mmCB_COLOR1_CLEAR_WORD1:
        return "mmCB_COLOR1_CLEAR_WORD1";
    case mmCB_COLOR1_PITCH:
        return "mmCB_COLOR1_PITCH";
    case mmCB_COLOR1_VIEW:
        return "mmCB_COLOR1_VIEW";
    case mmCB_COLOR2_INFO:
        return "mmCB_COLOR2_INFO";
    case mmCB_COLOR2_ATTRIB:
        return "mmCB_COLOR2_ATTRIB";
    case mmCB_COLOR2_CMASK_SLICE:
        return "mmCB_COLOR2_CMASK_SLICE";
    case mmCB_COLOR2_CLEAR_WORD0:
        return "mmCB_COLOR2_CLEAR_WORD0";
    case mmCB_COLOR2_CLEAR_WORD1:
        return "mmCB_COLOR2_CLEAR_WORD1";
    case mmCB_COLOR2_PITCH:
        return "mmCB_COLOR2_PITCH";
    case mmCB_COLOR2_VIEW:
        return "mmCB_COLOR2_VIEW";
    case mmCB_COLOR3_INFO:
        return "mmCB_COLOR3_INFO";
    case mmCB_COLOR3_CMASK_SLICE:
        return "mmCB_COLOR3_CMASK_SLICE";
    case mmCB_COLOR4_INFO:
        return "mmCB_COLOR4_INFO";
    case mmCB_COLOR5_INFO:
        return "mmCB_COLOR5_INFO";
    case mmCB_COLOR6_INFO:
        return "mmCB_COLOR6_INFO";
    case mmCB_COLOR7_INFO:
        return "mmCB_COLOR7_INFO";
    case mmDB_SRESULTS_COMPARE_STATE0:
        return "mmDB_SRESULTS_COMPARE_STATE0";
    case mmDB_SRESULTS_COMPARE_STATE1:
        return "mmDB_SRESULTS_COMPARE_STATE1";
    case mmDB_DEPTH_CONTROL:
        return "mmDB_DEPTH_CONTROL";
    case mmDB_EQAA:
        return "mmDB_EQAA";
    case mmPA_SU_POINT_SIZE:
        return "mmPA_SU_POINT_SIZE";
    case mmPA_SU_POINT_MINMAX:
        return "mmPA_SU_POINT_MINMAX";
    case mmPA_SU_SC_MODE_CNTL:
        return "mmPA_SU_SC_MODE_CNTL";
    case mmPA_SU_POLY_OFFSET_DB_FMT_CNTL:
        return "mmPA_SU_POLY_OFFSET_DB_FMT_CNTL";
    case mmPA_SC_CLIPRECT_RULE:
        return "mmPA_SC_CLIPRECT_RULE";
    case mmPA_SC_MODE_CNTL_0:
        return "mmPA_SC_MODE_CNTL_0";
    case mmPA_SC_MODE_CNTL_1:
        return "mmPA_SC_MODE_CNTL_1";
    case mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0:
        return "mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0";
    case mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0:
        return "mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0";
    case mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0:
        return "mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0";
    case mmPA_SC_AA_MASK_X0Y0_X1Y0:
        return "mmPA_SC_AA_MASK_X0Y0_X1Y0";
    case mmPA_SC_AA_MASK_X0Y1_X1Y1:
        return "mmPA_SC_AA_MASK_X0Y1_X1Y1";
    case mmPA_SC_CENTROID_PRIORITY_0:
        return "mmPA_SC_CENTROID_PRIORITY_0";
    case mmPA_SC_CENTROID_PRIORITY_1:
        return "mmPA_SC_CENTROID_PRIORITY_1";
    case mmPA_SC_AA_CONFIG:
        return "mmPA_SC_AA_CONFIG";
    case mmDB_RENDER_CONTROL:
        return "mmDB_RENDER_CONTROL";
    case mmDB_STENCIL_CONTROL:
        return "mmDB_STENCIL_CONTROL";
    case mmDB_STENCILREFMASK:
        return "mmDB_STENCILREFMASK";
    case mmDB_STENCILREFMASK_BF:
        return "mmDB_STENCILREFMASK_BF";
    case mmDB_STENCIL_CLEAR:
        return "mmDB_STENCIL_CLEAR";
    case mmDB_DEPTH_CLEAR:
        return "mmDB_DEPTH_CLEAR";
    case mmCB_TARGET_MASK:
        return "mmCB_TARGET_MASK";
    case mmDB_Z_INFO:
        return "mmDB_Z_INFO";
    case mmDB_STENCIL_INFO:
        return "mmDB_STENCIL_INFO";
    case mmDB_Z_READ_BASE:
        return "mmDB_Z_READ_BASE";
    case mmDB_STENCIL_READ_BASE:
        return "mmDB_STENCIL_READ_BASE";
    case mmDB_Z_WRITE_BASE:
        return "mmDB_Z_WRITE_BASE";
    case mmDB_STENCIL_WRITE_BASE:
        return "mmDB_STENCIL_WRITE_BASE";
    case mmDB_DEPTH_INFO:
        return "mmDB_DEPTH_INFO";
    case mmDB_DEPTH_VIEW:
        return "mmDB_DEPTH_VIEW";
    case mmDB_DEPTH_SLICE:
        return "mmDB_DEPTH_SLICE";
    case mmDB_DEPTH_SIZE:
        return "mmDB_DEPTH_SIZE";
    case mmTA_BC_BASE_ADDR:
        return "mmTA_BC_BASE_ADDR";
    case mmCB_BLEND_RED:
        return "mmCB_BLEND_RED";
    case mmCB_BLEND_GREEN:
        return "mmCB_BLEND_GREEN";
    case mmCB_BLEND_BLUE:
        return "mmCB_BLEND_BLUE";
    case mmDB_ALPHA_TO_MASK:
        return "mmDB_ALPHA_TO_MASK";
    case mmCB_BLEND0_CONTROL:
        return "mmCB_BLEND0_CONTROL";
    case mmCB_BLEND1_CONTROL:
        return "mmCB_BLEND1_CONTROL";
    case mmCB_BLEND2_CONTROL:
        return "mmCB_BLEND2_CONTROL";
    case mmCB_BLEND3_CONTROL:
        return "mmCB_BLEND3_CONTROL";
    case mmCB_BLEND4_CONTROL:
        return "mmCB_BLEND4_CONTROL";
    case mmCB_BLEND5_CONTROL:
        return "mmCB_BLEND5_CONTROL";
    case mmCB_BLEND6_CONTROL:
        return "mmCB_BLEND6_CONTROL";
    case mmCB_BLEND7_CONTROL:
        return "mmCB_BLEND7_CONTROL";
    case mmDB_HTILE_DATA_BASE:
        return "mmDB_HTILE_DATA_BASE";
    case mmDB_HTILE_SURFACE:
        return "mmDB_HTILE_SURFACE";
    case mmPA_SU_LINE_CNTL:
        return "mmPA_SU_LINE_CNTL";
    case mmPA_SC_VPORT_ZMIN_0:
        return "mmPA_SC_VPORT_ZMIN_0";
    case mmPA_SC_VPORT_ZMAX_0:
        return "mmPA_SC_VPORT_ZMAX_0";
    case mmPA_SC_VPORT_SCISSOR_0_TL:
        return "mmPA_SC_VPORT_SCISSOR_0_TL";
    case mmPA_SC_VPORT_SCISSOR_0_BR:
        return "mmPA_SC_VPORT_SCISSOR_0_BR";
    case mmPA_SC_GENERIC_SCISSOR_TL:
        return "mmPA_SC_GENERIC_SCISSOR_TL";
    case mmPA_SC_GENERIC_SCISSOR_BR:
        return "mmPA_SC_GENERIC_SCISSOR_BR";
    case mmPA_CL_VPORT_XSCALE:
        return "mmPA_CL_VPORT_XSCALE";
    case mmPA_CL_VPORT_YSCALE:
        return "mmPA_CL_VPORT_YSCALE";
    case mmPA_CL_VPORT_ZSCALE:
        return "mmPA_CL_VPORT_ZSCALE";
    case mmPA_CL_VPORT_XOFFSET:
        return "mmPA_CL_VPORT_XOFFSET";
    case mmPA_CL_VPORT_YOFFSET:
        return "mmPA_CL_VPORT_YOFFSET";
    case mmPA_CL_VPORT_ZOFFSET:
        return "mmPA_CL_VPORT_ZOFFSET";
    case mmPA_CL_VTE_CNTL:
        return "mmPA_CL_VTE_CNTL";
    case mmPA_SC_SCREEN_SCISSOR_TL:
        return "mmPA_SC_SCREEN_SCISSOR_TL";
    case mmPA_SC_SCREEN_SCISSOR_BR:
        return "mmPA_SC_SCREEN_SCISSOR_BR";
    case mmPA_SU_HARDWARE_SCREEN_OFFSET:
        return "mmPA_SU_HARDWARE_SCREEN_OFFSET";
    case mmPA_SU_VTX_CNTL:
        return "mmPA_SU_VTX_CNTL";
    case mmPA_CL_GB_VERT_CLIP_ADJ:
        return "mmPA_CL_GB_VERT_CLIP_ADJ";
    case mmPA_CL_GB_HORZ_CLIP_ADJ:
        return "mmPA_CL_GB_HORZ_CLIP_ADJ";
    case mmPA_CL_GB_VERT_DISC_ADJ:
        return "mmPA_CL_GB_VERT_DISC_ADJ";
    case mmPA_CL_GB_HORZ_DISC_ADJ:
        return "mmPA_CL_GB_HORZ_DISC_ADJ";
    case mmCB_COLOR_CONTROL:
        return "mmCB_COLOR_CONTROL";
    case mmSPI_SHADER_Z_FORMAT:
        return "mmSPI_SHADER_Z_FORMAT";
    case mmSPI_SHADER_COL_FORMAT:
        return "mmSPI_SHADER_COL_FORMAT";
    case mmPA_CL_VS_OUT_CNTL:
        return "mmPA_CL_VS_OUT_CNTL";
    case mmSPI_VS_OUT_CONFIG:
        return "mmSPI_VS_OUT_CONFIG";
    case mmSPI_SHADER_POS_FORMAT:
        return "mmSPI_SHADER_POS_FORMAT";
    case mmSPI_PS_INPUT_ENA:
        return "mmSPI_PS_INPUT_ENA";
    case mmSPI_PS_INPUT_ADDR:
        return "mmSPI_PS_INPUT_ADDR";
    case mmSPI_PS_IN_CONTROL:
        return "mmSPI_PS_IN_CONTROL";
    case mmSPI_BARYC_CNTL:
        return "mmSPI_BARYC_CNTL";
    case mmSPI_PS_INPUT_CNTL_0:
        return "mmSPI_PS_INPUT_CNTL_0";
    case mmSPI_PS_INPUT_CNTL_1:
        return "mmSPI_PS_INPUT_CNTL_1";
    case mmSPI_PS_INPUT_CNTL_2:
        return "mmSPI_PS_INPUT_CNTL_2";
    case mmSPI_PS_INPUT_CNTL_3:
        return "mmSPI_PS_INPUT_CNTL_3";
    case mmPA_SU_POLY_OFFSET_FRONT_SCALE:
        return "mmPA_SU_POLY_OFFSET_FRONT_SCALE";
    case mmPA_SU_POLY_OFFSET_FRONT_OFFSET:
        return "mmPA_SU_POLY_OFFSET_FRONT_OFFSET";
    case mmPA_SU_POLY_OFFSET_BACK_SCALE:
        return "mmPA_SU_POLY_OFFSET_BACK_SCALE";
    case mmPA_SU_POLY_OFFSET_BACK_OFFSET:
        return "mmPA_SU_POLY_OFFSET_BACK_OFFSET";
    case mmPA_SU_POLY_OFFSET_CLAMP:
        return "mmPA_SU_POLY_OFFSET_CLAMP";
    default:
        break;
    }
    return "<UNK>";
}
} // namespace Core::Devtools::Gcn